/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.util.Context;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.impl.rdf.JcrRdfTools;
import org.fcrepo.kernel.impl.utils.JcrPropertyStatementListener;
import org.fcrepo.kernel.rdf.GraphProperties;
import org.fcrepo.kernel.rdf.IdentifierTranslator;

public class JcrGraphProperties
implements GraphProperties {
    private static final String MODEL_NAME = "tree";

    public String getPropertyModelName() {
        return MODEL_NAME;
    }

    public Dataset getProperties(Node node, IdentifierTranslator subjects, int offset, int limit) throws RepositoryException {
        JcrRdfTools jcrRdfTools = JcrRdfTools.withContext(subjects, node.getSession());
        Model model = jcrRdfTools.getJcrTriples(node).concat((Iterator)jcrRdfTools.getTreeTriples(node)).limit(Integer.valueOf(limit)).skip(Integer.valueOf(offset)).asModel();
        Model problemModel = JcrRdfTools.getProblemsModel();
        JcrPropertyStatementListener listener = JcrPropertyStatementListener.getListener(subjects, node.getSession(), problemModel);
        model.register((ModelChangedListener)listener);
        Dataset dataset = DatasetFactory.create((Model)model);
        dataset.addNamedModel(MODEL_NAME, model);
        Resource subject = subjects.getSubject(node.getPath());
        String uri = subject.getURI();
        Context context = dataset.getContext();
        context.set(URI_SYMBOL, (Object)uri);
        context.set(INLINED_RESOURCES_MODEL, (Object)MODEL_NAME);
        dataset.addNamedModel("problems", problemModel);
        return dataset;
    }

    public Dataset getProperties(Node node, IdentifierTranslator subjects) throws RepositoryException {
        return this.getProperties(node, subjects, 0, -1);
    }
}

