/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Collection;
import java.util.Map;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.impl.rdf.JcrRdfTools;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceRdfContext
extends RdfStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamespaceRdfContext.class);

    public NamespaceRdfContext(Session session) throws RepositoryException {
        NamespaceRegistry namespaceRegistry = session.getWorkspace().getNamespaceRegistry();
        Preconditions.checkNotNull((Object)namespaceRegistry, (Object)"Couldn't find namespace registry in repository!");
        ImmutableMap.Builder namespaces = ImmutableMap.builder();
        ImmutableSet.Builder nsTriples = ImmutableSet.builder();
        for (String prefix : namespaceRegistry.getPrefixes()) {
            if (prefix.isEmpty()) continue;
            String nsURI = namespaceRegistry.getURI(prefix);
            if (prefix.equals("jcr")) {
                prefix = "fcrepo";
            }
            LOGGER.trace("Discovered namespace prefix \"{}\" with URI \"{}\"", (Object)prefix, (Object)nsURI);
            String rdfNsUri = JcrRdfTools.getRDFNamespaceForJcrNamespace(nsURI);
            namespaces.put((Object)prefix, (Object)rdfNsUri);
            LOGGER.trace("Added namespace prefix \"{}\" with URI \"{}\"", (Object)prefix, (Object)rdfNsUri);
            Node nsSubject = NodeFactory.createURI((String)rdfNsUri);
            nsTriples.add((Object)Triple.create((Node)nsSubject, (Node)RDF.type.asNode(), (Node)RdfLexicon.VOAF_VOCABULARY.asNode()));
            nsTriples.add((Object)Triple.create((Node)nsSubject, (Node)RdfLexicon.HAS_NAMESPACE_PREFIX.asNode(), (Node)NodeFactory.createLiteral((String)prefix)));
            nsTriples.add((Object)Triple.create((Node)nsSubject, (Node)RdfLexicon.HAS_NAMESPACE_URI.asNode(), (Node)NodeFactory.createLiteral((String)rdfNsUri)));
        }
        this.concat((Collection)nsTriples.build()).namespaces((Map)namespaces.build());
    }
}

