/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.vocabulary.RDF;
import java.security.AccessControlException;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.impl.rdf.JcrRdfTools;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeRdfContext
extends RdfStream {
    private final javax.jcr.Node node;
    private final IdentifierTranslator graphSubjects;
    private final Node subject;
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeRdfContext.class);

    public NodeRdfContext(javax.jcr.Node node, IdentifierTranslator graphSubjects) throws RepositoryException {
        this.node = node;
        this.graphSubjects = graphSubjects;
        this.subject = graphSubjects.getSubject(node.getPath()).asNode();
        this.concatRdfTypes();
        this.concatWritable();
    }

    public javax.jcr.Node node() {
        return this.node;
    }

    public IdentifierTranslator graphSubjects() {
        return this.graphSubjects;
    }

    public Node subject() {
        return this.subject;
    }

    private Function<NodeType, Triple> nodetype2triple() {
        return new Function<NodeType, Triple>(){

            public Triple apply(NodeType nodeType) {
                try {
                    String fullTypeName = nodeType.getName();
                    LOGGER.trace("Translating JCR mixin name: {}", (Object)fullTypeName);
                    String prefix = fullTypeName.split(":")[0];
                    String typeName = fullTypeName.split(":")[1];
                    String namespace = NodeRdfContext.this.getJcrUri(prefix);
                    LOGGER.trace("with JCR namespace: {}", (Object)namespace);
                    Node rdfType = NodeFactory.createURI((String)(JcrRdfTools.getRDFNamespaceForJcrNamespace(namespace) + typeName));
                    LOGGER.trace("into RDF resource: {}", (Object)rdfType);
                    return Triple.create((Node)NodeRdfContext.this.subject(), (Node)RDF.type.asNode(), (Node)rdfType);
                }
                catch (RepositoryException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        };
    }

    private String getJcrUri(String prefix) throws RepositoryException {
        return this.node().getSession().getWorkspace().getNamespaceRegistry().getURI(prefix);
    }

    private void concatRdfTypes() throws RepositoryException {
        Object[] mixinNodeTypesArr;
        ImmutableList.Builder nodeTypesB = ImmutableList.builder();
        NodeType primaryNodeType = this.node.getPrimaryNodeType();
        nodeTypesB.add((Object)primaryNodeType);
        if (primaryNodeType != null && primaryNodeType.getSupertypes() != null) {
            ImmutableSet primarySupertypes = ImmutableSet.builder().add((Object[])primaryNodeType.getSupertypes()).build();
            nodeTypesB.addAll((Iterable)primarySupertypes);
        }
        if ((mixinNodeTypesArr = this.node.getMixinNodeTypes()) != null) {
            ImmutableSet mixinNodeTypes = ImmutableSet.builder().add(mixinNodeTypesArr).build();
            nodeTypesB.addAll((Iterable)mixinNodeTypes);
            ImmutableSet.Builder mixinSupertypes = ImmutableSet.builder();
            for (NodeType mixinNodeType : mixinNodeTypes) {
                mixinSupertypes.addAll((Iterable)ImmutableSet.builder().add((Object[])mixinNodeType.getSupertypes()).build());
            }
            nodeTypesB.addAll((Iterable)mixinSupertypes.build());
        }
        ImmutableList nodeTypes = nodeTypesB.build();
        UnmodifiableIterator nodeTypesIt = nodeTypes.iterator();
        this.concat(Iterators.transform((Iterator)nodeTypesIt, this.nodetype2triple()));
    }

    private void concatWritable() throws RepositoryException {
        boolean writable = false;
        try {
            this.node.getSession().checkPermission(this.node.getPath(), "add_node,set_property,remove");
            writable = true;
        }
        catch (AccessControlException ex) {
            writable = false;
        }
        this.concat(Triple.create((Node)this.subject(), (Node)RdfLexicon.WRITABLE.asNode(), (Node)NodeFactory.createLiteral((String)String.valueOf(writable), (RDFDatatype)XSDDatatype.XSDboolean)));
    }
}

