/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import java.util.Iterator;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.impl.rdf.impl.NodeRdfContext;
import org.fcrepo.kernel.impl.rdf.impl.RootRdfContext;
import org.fcrepo.kernel.impl.rdf.impl.mappings.PropertyToTriple;
import org.fcrepo.kernel.impl.rdf.impl.mappings.ZippingIterator;
import org.fcrepo.kernel.impl.utils.FedoraTypesUtils;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.utils.iterators.PropertyIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesRdfContext
extends NodeRdfContext {
    private PropertyToTriple property2triple;
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesRdfContext.class);

    public PropertiesRdfContext(javax.jcr.Node node, IdentifierTranslator graphSubjects) throws RepositoryException {
        super(node, graphSubjects);
        this.property2triple = new PropertyToTriple(graphSubjects);
        this.putPropertiesIntoContext();
    }

    private void putPropertiesIntoContext() throws RepositoryException {
        LOGGER.trace("Pushing RDF triples into context for properties of node: {}", (Object)this.node());
        if (this.node().hasProperties()) {
            this.concat(this.triplesFromProperties(this.node()));
        }
        javax.jcr.Node contentNode = null;
        try {
            if (this.node().hasNode("jcr:content")) {
                contentNode = this.node().getNode("jcr:content");
            }
        }
        catch (AccessDeniedException e) {
            LOGGER.trace("Access denied to content node", (Throwable)e);
        }
        if (contentNode != null) {
            Node contentSubject = this.graphSubjects().getSubject(contentNode.getPath()).asNode();
            Node subject = this.graphSubjects().getSubject(this.node().getPath()).asNode();
            this.concat(new Triple[]{Triple.create((Node)subject, (Node)RdfLexicon.HAS_CONTENT.asNode(), (Node)contentSubject), Triple.create((Node)contentSubject, (Node)RdfLexicon.IS_CONTENT_OF.asNode(), (Node)subject)});
            this.concat((Iterator)((Object)new PropertiesRdfContext(this.node().getNode("jcr:content"), this.graphSubjects())));
        }
        if (this.node().getPrimaryNodeType().getName().equals("mode:root")) {
            this.concat((Iterator)((Object)new RootRdfContext(this.node(), this.graphSubjects())));
        }
    }

    private Iterator<Triple> triplesFromProperties(javax.jcr.Node n) throws RepositoryException {
        LOGGER.trace("Creating triples for node: {}", (Object)n);
        UnmodifiableIterator nonBinaryProperties = Iterators.filter((Iterator)new PropertyIterator(n.getProperties()), (Predicate)Predicates.not(FedoraTypesUtils.isInternalProperty));
        UnmodifiableIterator nonBinaryPropertiesCopy = Iterators.filter((Iterator)new PropertyIterator(n.getProperties()), (Predicate)Predicates.not(FedoraTypesUtils.isInternalProperty));
        return Iterators.concat(new ZippingIterator(Iterators.transform((Iterator)nonBinaryProperties, FedoraTypesUtils.property2values), Iterators.transform((Iterator)nonBinaryPropertiesCopy, (Function)this.property2triple)));
    }
}

