/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.hp.hpl.jena.graph.Triple;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.impl.rdf.impl.mappings.PropertyToTriple;
import org.fcrepo.kernel.impl.rdf.impl.mappings.ZippingIterator;
import org.fcrepo.kernel.impl.utils.FedoraTypesUtils;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.utils.iterators.PropertyIterator;
import org.fcrepo.kernel.utils.iterators.RdfStream;

public class ReferencesRdfContext
extends RdfStream {
    private final Node node;
    private PropertyToTriple property2triple;

    public ReferencesRdfContext(Node node, IdentifierTranslator graphSubjects) throws RepositoryException {
        this.node = node;
        this.property2triple = new PropertyToTriple(graphSubjects);
        this.concat(this.putStrongReferencePropertiesIntoContext());
        this.concat(this.putWeakReferencePropertiesIntoContext());
    }

    private Iterator<Triple> putWeakReferencePropertiesIntoContext() throws RepositoryException {
        PropertyIterator properties = new PropertyIterator(this.node.getWeakReferences());
        PropertyIterator propertiesCopy = new PropertyIterator(this.node.getWeakReferences());
        return this.zipPropertiesToTriples((Iterator<Property>)properties, (Iterator<Property>)propertiesCopy);
    }

    private Iterator<Triple> putStrongReferencePropertiesIntoContext() throws RepositoryException {
        PropertyIterator properties = new PropertyIterator(this.node.getReferences());
        PropertyIterator propertiesCopy = new PropertyIterator(this.node.getReferences());
        return this.zipPropertiesToTriples((Iterator<Property>)properties, (Iterator<Property>)propertiesCopy);
    }

    private Iterator<Triple> zipPropertiesToTriples(Iterator<Property> propertyIterator, Iterator<Property> propertyIteratorCopy) {
        return Iterators.concat(new ZippingIterator(Iterators.transform(propertyIterator, FedoraTypesUtils.property2values), Iterators.transform(propertyIteratorCopy, (Function)this.property2triple)));
    }
}

