/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.impl.rdf.impl.PropertiesRdfContext;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.fcrepo.kernel.utils.iterators.VersionIterator;

public class VersionsRdfContext
extends RdfStream {
    private final VersionManager versionManager;
    private final VersionHistory versionHistory;
    private final IdentifierTranslator graphSubjects;
    private final Node subject;
    private Function<Version, Iterator<Triple>> version2triples = new Function<Version, Iterator<Triple>>(){

        public Iterator<Triple> apply(Version version) {
            try {
                javax.jcr.Node frozenNode = version.getFrozenNode();
                Node versionSubject = VersionsRdfContext.this.graphSubjects.getSubject(frozenNode.getPath()).asNode();
                RdfStream results = new RdfStream(new PropertiesRdfContext(frozenNode, VersionsRdfContext.this.graphSubjects).iterator());
                results.concat(Triple.create((Node)VersionsRdfContext.this.subject, (Node)RdfLexicon.HAS_VERSION.asNode(), (Node)versionSubject));
                for (String label : VersionsRdfContext.this.versionHistory.getVersionLabels(version)) {
                    results.concat(Triple.create((Node)versionSubject, (Node)RdfLexicon.HAS_VERSION_LABEL.asNode(), (Node)NodeFactory.createLiteral((String)label)));
                }
                return results;
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };

    public VersionsRdfContext(javax.jcr.Node node, IdentifierTranslator graphSubjects) throws RepositoryException {
        this.graphSubjects = graphSubjects;
        this.subject = graphSubjects.getSubject(node.getPath()).asNode();
        this.versionManager = node.getSession().getWorkspace().getVersionManager();
        this.versionHistory = this.versionManager.getVersionHistory(node.getPath());
        this.concat(this.versionTriples());
    }

    private Iterator<Triple> versionTriples() throws RepositoryException {
        return Iterators.concat((Iterator)Iterators.transform((Iterator)new VersionIterator(this.versionHistory.getAllVersions()), this.version2triples));
    }
}

