/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.spring;

import java.io.IOException;
import java.util.Collections;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.impl.spring.DefaultPropertiesLoader;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrRepositoryFactory;
import org.modeshape.jcr.api.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class ModeShapeRepositoryFactoryBean
implements FactoryBean<JcrRepository> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModeShapeRepositoryFactoryBean.class);
    private DefaultPropertiesLoader propertiesLoader;
    @Inject
    private JcrRepositoryFactory jcrRepositoryFactory;
    private Resource repositoryConfiguration;
    private JcrRepository repository;

    @PostConstruct
    public void buildRepository() throws RepositoryException, IOException {
        if (this.repositoryConfiguration instanceof ClassPathResource) {
            LOGGER.info("Using repo config: {}", (Object)((ClassPathResource)this.repositoryConfiguration).getPath());
        }
        this.getPropertiesLoader().loadSystemProperties();
        this.repository = (JcrRepository)this.jcrRepositoryFactory.getRepository(Collections.singletonMap("org.modeshape.jcr.URL", this.repositoryConfiguration.getURL()));
    }

    public JcrRepository getObject() throws RepositoryException, IOException {
        return this.repository;
    }

    public Class<?> getObjectType() {
        return Repository.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setRepositoryConfiguration(Resource repositoryConfiguration) {
        this.repositoryConfiguration = repositoryConfiguration;
    }

    private DefaultPropertiesLoader getPropertiesLoader() {
        if (null == this.propertiesLoader) {
            this.propertiesLoader = new DefaultPropertiesLoader();
        }
        return this.propertiesLoader;
    }
}

