/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.fcrepo.kernel.impl.utils.FixityInputStream;
import org.fcrepo.kernel.impl.utils.FixityResultImpl;
import org.fcrepo.kernel.utils.CacheEntry;
import org.fcrepo.kernel.utils.ContentDigest;
import org.fcrepo.kernel.utils.FixityResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicCacheEntry
implements CacheEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicCacheEntry.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<FixityResult> checkFixity(URI checksum, long size) throws RepositoryException {
        String digest = ContentDigest.getAlgorithm((URI)checksum);
        try (FixityInputStream fixityInputStream = new FixityInputStream(this.getInputStream(), MessageDigest.getInstance(digest));){
            IOUtils.copy((InputStream)((Object)fixityInputStream), (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
            URI calculatedChecksum = ContentDigest.asURI((String)digest, (byte[])fixityInputStream.getMessageDigest().digest());
            FixityResultImpl result = new FixityResultImpl(this, fixityInputStream.getByteCount(), calculatedChecksum);
            if (checksum == null || checksum.equals(ContentDigest.missingChecksum()) || size == -1L) {
                result.getStatus().add(FixityResult.FixityState.MISSING_STORED_FIXITY);
            }
            if (!result.matches(checksum)) {
                result.getStatus().add(FixityResult.FixityState.BAD_CHECKSUM);
            }
            if (!result.matches(size)) {
                result.getStatus().add(FixityResult.FixityState.BAD_SIZE);
            }
            if (result.matches(size, checksum)) {
                result.getStatus().add(FixityResult.FixityState.SUCCESS);
            }
            LOGGER.debug("Got {}", (Object)((Object)result).toString());
            ImmutableSet immutableSet = ImmutableSet.of((Object)result);
            return immutableSet;
        }
        catch (IOException e) {
            LOGGER.debug("Got error closing input stream: {}", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        catch (NoSuchAlgorithmException e1) {
            throw Throwables.propagate((Throwable)e1);
        }
    }
}

