/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils.impl;

import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.fcrepo.kernel.impl.utils.FixityInputStream;
import org.fcrepo.kernel.impl.utils.FixityResultImpl;
import org.fcrepo.kernel.impl.utils.infinispan.StoreChunkInputStream;
import org.fcrepo.kernel.utils.ContentDigest;
import org.fcrepo.kernel.utils.FixityResult;
import org.infinispan.Cache;
import org.infinispan.CacheImpl;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.decorators.ChainingCacheStore;

public class DistributedFixityCheck
implements DistributedCallable<String, byte[], Collection<FixityResult>>,
Serializable {
    private final String dataKey;
    private Cache<String, byte[]> cache;

    public DistributedFixityCheck(String dataKey) {
        this.dataKey = dataKey;
    }

    public Collection<FixityResult> call() throws Exception {
        ImmutableSet.Builder fixityResults = new ImmutableSet.Builder();
        for (CacheStore store : this.stores()) {
            String digest = ContentDigest.getAlgorithm((URI)new URI("urn:sha1"));
            StoreChunkInputStream cacheLoaderChunkInputStream = new StoreChunkInputStream(store, this.dataKey);
            FixityInputStream fixityInputStream = new FixityInputStream(cacheLoaderChunkInputStream, MessageDigest.getInstance(digest));
            IOUtils.copy((InputStream)((Object)fixityInputStream), (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
            URI calculatedChecksum = ContentDigest.asURI((String)digest, (byte[])fixityInputStream.getMessageDigest().digest());
            fixityResults.add((Object)new FixityResultImpl(this.getExternalIdentifier(store), fixityInputStream.getByteCount(), calculatedChecksum));
        }
        return fixityResults.build();
    }

    private String getExternalIdentifier(CacheStore store) {
        String address = this.cache.getCacheManager().getAddress() != null ? this.cache.getCacheManager().getAddress().toString() : "localhost";
        return "infinispan-cache-loader:" + address + "/" + store.toString() + "#" + this.dataKey;
    }

    public void setEnvironment(Cache<String, byte[]> cache, Set<String> inputKeys) {
        this.cache = cache;
    }

    private Set<CacheStore> stores() {
        CacheLoaderManager cacheLoaderManager = (CacheLoaderManager)((CacheImpl)this.cache).getComponentRegistry().getLocalComponent(CacheLoaderManager.class);
        if (cacheLoaderManager.getCacheLoader() instanceof ChainingCacheStore) {
            return ((ChainingCacheStore)cacheLoaderManager.getCacheLoader()).getStores().keySet();
        }
        return ImmutableSet.of((Object)cacheLoaderManager.getCacheStore());
    }
}

