/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils.impl;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.impl.services.ServiceHelpers;
import org.fcrepo.kernel.impl.utils.impl.DistributedFixityCheck;
import org.fcrepo.kernel.impl.utils.impl.LocalBinaryStoreEntry;
import org.fcrepo.kernel.utils.ContentDigest;
import org.fcrepo.kernel.utils.FixityResult;
import org.infinispan.distexec.DistributedExecutorService;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.infinispan.InfinispanBinaryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanCacheStoreEntry
extends LocalBinaryStoreEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfinispanCacheStoreEntry.class);
    private static final String DATA_SUFFIX = "-data";

    public InfinispanCacheStoreEntry(InfinispanBinaryStore store, Property property) {
        super((BinaryStore)store, property);
    }

    @Override
    public Collection<FixityResult> checkFixity(URI checksum, long size) throws RepositoryException {
        BinaryKey key = this.binaryKey();
        ImmutableSet.Builder fixityResults = new ImmutableSet.Builder();
        if (this.store().hasBinary(key)) {
            String dataKey = this.dataKeyFor(key);
            DistributedFixityCheck task = new DistributedFixityCheck(dataKey);
            List futures = this.clusterExecutor().submitEverywhere((Callable)((Object)task), (Object[])new String[]{dataKey + "-0"});
            while (!futures.isEmpty()) {
                Iterator iterator = futures.iterator();
                while (iterator.hasNext()) {
                    Future future = (Future)iterator.next();
                    try {
                        Collection result = (Collection)future.get(100L, TimeUnit.MILLISECONDS);
                        iterator.remove();
                        for (FixityResult fixityResult : result) {
                            this.setFixityStatus(fixityResult, size, checksum);
                        }
                        fixityResults.addAll((Iterable)result);
                    }
                    catch (TimeoutException e) {
                        LOGGER.trace("Going to retry cluster transform after timeout", (Throwable)e);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            }
        }
        return fixityResults.build();
    }

    private String dataKeyFor(BinaryKey key) {
        return key + DATA_SUFFIX;
    }

    private DistributedExecutorService clusterExecutor() {
        return ServiceHelpers.getClusterExecutor((InfinispanBinaryStore)this.store());
    }

    private void setFixityStatus(FixityResult result, long dsSize, URI dsChecksum) {
        if (dsChecksum.equals(ContentDigest.missingChecksum()) || dsSize == -1L) {
            result.getStatus().add(FixityResult.FixityState.MISSING_STORED_FIXITY);
        }
        if (!result.matches(dsChecksum)) {
            result.getStatus().add(FixityResult.FixityState.BAD_CHECKSUM);
        }
        if (!result.matches(dsSize)) {
            result.getStatus().add(FixityResult.FixityState.BAD_SIZE);
        }
        if (result.matches(dsSize, dsChecksum)) {
            result.getStatus().add(FixityResult.FixityState.SUCCESS);
        }
    }
}

