/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils.impl;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.impl.services.functions.GetBinaryKey;
import org.fcrepo.kernel.impl.utils.BasicCacheEntry;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalBinaryStoreEntry
extends BasicCacheEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalBinaryStoreEntry.class);
    private GetBinaryKey getBinaryKey = new GetBinaryKey();
    private final BinaryStore store;
    private final Property property;

    public LocalBinaryStoreEntry(BinaryStore store, Property property) {
        this.property = property;
        this.store = store;
    }

    BinaryStore store() {
        return this.store;
    }

    public InputStream getInputStream() throws RepositoryException {
        return this.store.getInputStream(this.binaryKey());
    }

    public String getExternalIdentifier() throws RepositoryException {
        try {
            return new URI("info", this.store.toString(), null) + "/" + this.binaryKey();
        }
        catch (URISyntaxException e) {
            return this.binaryKey().toString();
        }
    }

    public boolean equals(Object other) {
        if (other instanceof LocalBinaryStoreEntry) {
            LocalBinaryStoreEntry that = (LocalBinaryStoreEntry)other;
            return this.property().equals(that.property()) && (this.store == null && that.store == null || this.store != null && this.store.equals(that.store));
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.store, this.property);
    }

    protected Property property() {
        return this.property;
    }

    protected BinaryKey binaryKey() throws RepositoryException {
        return this.getBinaryKey.apply(this.property);
    }
}

