/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils.infinispan;

import java.io.IOException;
import java.io.InputStream;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreChunkInputStream
extends InputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreChunkInputStream.class);
    private final CacheStore blobCache;
    private final String key;
    protected int indexInBuffer;
    protected byte[] buffer;
    private int chunkNumber;

    public StoreChunkInputStream(CacheStore blobCache, String key) {
        this.blobCache = blobCache;
        this.key = key;
    }

    @Override
    public int read() throws IOException {
        if (this.indexInBuffer == -1) {
            return -1;
        }
        if (this.buffer == null || this.indexInBuffer >= this.buffer.length) {
            this.fillBuffer();
            return this.read();
        }
        return this.buffer[this.indexInBuffer++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int length = len;
        if (this.indexInBuffer == -1) {
            return -1;
        }
        if (this.buffer == null) {
            this.fillBuffer();
            return this.read(b, off, length);
        }
        if (this.indexInBuffer >= this.buffer.length) {
            return -1;
        }
        if (this.indexInBuffer + length > this.buffer.length) {
            length = this.buffer.length - this.indexInBuffer;
        }
        System.arraycopy(this.buffer, this.indexInBuffer, b, off, length);
        this.indexInBuffer += length;
        if (this.indexInBuffer == this.buffer.length) {
            this.buffer = null;
            this.indexInBuffer = 0;
        }
        return length;
    }

    @Override
    public int available() throws IOException {
        if (this.buffer == null) {
            return 0;
        }
        if (this.indexInBuffer >= 0) {
            return this.buffer.length - this.indexInBuffer;
        }
        return -1;
    }

    @Override
    public final long skip(long n) throws IOException {
        if (n <= 0L || this.indexInBuffer == -1) {
            return 0L;
        }
        if (this.buffer == null) {
            this.fillBuffer();
            return this.skip(n);
        }
        if ((long)this.indexInBuffer + n >= (long)this.buffer.length) {
            long skipped = this.buffer.length - this.indexInBuffer;
            this.buffer = null;
            this.indexInBuffer = 0;
            return skipped;
        }
        this.indexInBuffer = (int)((long)this.indexInBuffer + n);
        return n;
    }

    private void fillBuffer() throws IOException {
        this.buffer = this.nextChunk();
        if (this.buffer == null) {
            this.buffer = new byte[0];
            this.indexInBuffer = -1;
        } else {
            this.indexInBuffer = 0;
        }
    }

    protected byte[] nextChunk() throws IOException {
        String chunkKey = this.key + "-" + this.chunkNumber++;
        LOGGER.debug("Read chunk {0} from cache {1}", (Object)chunkKey, (Object)this.blobCache);
        try {
            InternalCacheEntry cacheEntry = this.blobCache.load((Object)chunkKey);
            if (cacheEntry == null) {
                LOGGER.trace("Unable to read chunk {0}", (Object)chunkKey);
                return null;
            }
            return (byte[])cacheEntry.getValue();
        }
        catch (CacheLoaderException e) {
            throw new IOException(e);
        }
    }
}

