/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterators;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.fcrepo.jcr.FedoraJcrTypes;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.impl.rdf.JcrRdfTools;
import org.fcrepo.kernel.impl.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.impl.testutilities.TestPropertyIterator;
import org.fcrepo.kernel.impl.utils.FixityResultImpl;
import org.fcrepo.kernel.impl.utils.NodePropertiesTools;
import org.fcrepo.kernel.rdf.HierarchyRdfContextOptions;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.utils.CacheEntry;
import org.fcrepo.kernel.utils.FixityResult;
import org.fcrepo.kernel.utils.iterators.NodeIterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.modeshape.jcr.api.NamespaceRegistry;
import org.modeshape.jcr.api.Namespaced;
import org.modeshape.jcr.value.BinaryValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrRdfToolsTest
implements FedoraJcrTypes {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrRdfToolsTest.class);
    private IdentifierTranslator testSubjects;
    private JcrRdfTools testObj;
    private static final String mockPredicateName = "http://example.com#someProperty";
    private static final String mockUri = "http://example.com/";
    private static final NodeType[] emptyNodeTypes = new NodeType[0];
    @Mock
    private com.hp.hpl.jena.rdf.model.Property mockPredicate;
    @Mock
    private Function<Property, com.hp.hpl.jena.rdf.model.Property> mockPredicateFactoryFunc;
    @Mock
    private javax.jcr.NodeIterator mockNodes;
    @Mock
    private javax.jcr.NodeIterator mockNodes2;
    @Mock
    private javax.jcr.NodeIterator mockNodes3;
    @Mock
    private Function<Node, ValueFactory> mockValueFactoryFunc;
    @Mock
    private Node mockNode;
    @Mock
    private Node mockNode1;
    @Mock
    private Node mockNode2;
    @Mock
    private Node mockNode3;
    @Mock
    private Node mockParent;
    @Mock
    private NamespaceRegistry mockNsRegistry;
    @Mock
    private IdentifierTranslator mockFactory;
    @Mock
    private Resource mockSubject;
    @Mock
    private Resource mockResource;
    @Mock
    private Session mockSession;
    @Mock
    private NodeType mockNodeType;
    @Mock
    private Property mockProperty;
    @Mock
    private PropertyDefinition mockPropertyDefinition;
    @Mock
    private Value mockValue;
    @Mock
    private Repository mockRepository;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private PropertyIterator mockProperties;
    @Mock
    private PropertyIterator mockProperties2;
    @Mock
    private PropertyIterator mockParentProperties;
    @Mock
    private Node mockContentNode;
    @Mock
    private Version mockVersion;
    @Mock
    private Node mockFrozenNode;
    @Mock
    private VersionManager mockVersionManager;
    @Mock
    private VersionIterator mockVersionIterator;
    @Mock
    private VersionHistory mockVersionHistory;
    @Mock
    private BinaryValue mockBinary;
    @Mock
    private CacheEntry mockCacheEntry;
    @Mock
    private QueryManager mockQueryManager;
    @Mock
    private Query mockQuery;
    @Mock
    private ValueFactory mockValueFactory;
    @Mock
    private QueryResult mockQueryResult;
    @Mock
    private RowIterator mockRowIterator;
    @Mock
    private MetricRegistry mockMetrics;
    @Mock
    private Node mockChildNode;
    @Mock
    private Node mockChildNode2;
    @Mock
    private Node mockChildNode3;
    @Mock
    private Node mockChildNode4;
    @Mock
    private Node mockChildNode5;
    @Mock
    private Node mockFullChildNode;
    @Mock
    private Counter mockCounter;
    @Mock
    private NodeTypeManager mockNodeTypeManager;
    @Mock
    private NodeTypeIterator mockNodeTypeIterator;
    @Mock
    private NodeType mockMixinNodeType;
    @Mock
    private NodeType mockPrimaryNodeType;
    @Mock
    private NamespacedProperty mockNamespacedProperty;

    @Before
    public final void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        this.testSubjects = new DefaultIdentifierTranslator();
        this.testObj = new JcrRdfTools(this.testSubjects, this.mockSession);
        this.buildMockNodeAndSurroundings();
    }

    private void buildMockNodeAndSurroundings() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getRepository()).thenReturn((Object)this.mockRepository);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        this.mockNamespaceRegistry();
        Mockito.when((Object)this.mockWorkspace.getNamespaceRegistry()).thenReturn((Object)this.mockNsRegistry);
        Mockito.when((Object)this.mockParent.getPath()).thenReturn((Object)"/test");
        Mockito.when((Object)this.mockParent.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockParent);
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)this.mockNodes);
        Mockito.when((Object)this.mockNodes.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNodes.next()).thenThrow(new Throwable[]{new NoSuchElementException()});
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[]{this.mockNodeType});
        Mockito.when((Object)this.mockNodeType.getName()).thenReturn((Object)"jcr:someType");
        Mockito.when((Object)this.mockNodeType.getChildNodeDefinitions()).thenReturn((Object)new NodeDefinition[]{(NodeDefinition)Mockito.mock(NodeDefinition.class)});
        Mockito.when((Object)this.mockNode.getProperties()).thenReturn((Object)new TestPropertyIterator(this.mockProperty), (Object[])new PropertyIterator[]{new TestPropertyIterator(this.mockProperty), new TestPropertyIterator(this.mockProperty)});
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)false);
        Mockito.when((Object)this.mockProperty.getParent()).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockProperty.getName()).thenReturn((Object)mockPredicateName);
        Mockito.when((Object)this.mockProperty.getValue()).thenReturn((Object)this.mockValue);
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)1);
        Mockito.when((Object)this.mockProperty.getParent()).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockNode.isNodeType("nt:frozenNode")).thenReturn((Object)false);
        Mockito.when((Object)this.mockProperty.getDefinition()).thenReturn((Object)this.mockPropertyDefinition);
        Mockito.when((Object)this.mockPropertyDefinition.isProtected()).thenReturn((Object)false);
        Mockito.when((Object)this.mockValue.getString()).thenReturn((Object)"abc");
        Mockito.when((Object)this.mockParent.getProperties()).thenReturn((Object)this.mockParentProperties);
        Mockito.when((Object)this.mockParentProperties.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNodeType.getSupertypes()).thenReturn((Object)new NodeType[]{this.mockNodeType});
    }

    @Test
    public final void testGetPropertiesModel() throws RepositoryException, IOException {
        LOGGER.debug("Entering testGetPropertiesModel()...");
        Mockito.when((Object)this.mockNode.hasProperties()).thenReturn((Object)true);
        Model actual = this.testObj.getJcrTriples(this.mockNode).asModel();
        JcrRdfToolsTest.logRDF(actual);
        Assert.assertTrue((String)"Didn't find appropriate triple!", (boolean)actual.contains(this.testSubjects.getSubject(this.mockNode.getPath()), actual.getProperty(mockPredicateName), (RDFNode)actual.createLiteral("abc")));
    }

    @Test
    public final void testGetPropertiesModelForRootNode() throws RepositoryException {
        LOGGER.debug("Entering testGetPropertiesModelForRootNode()...");
        Mockito.when((Object)this.mockRepository.login()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockRowIterator.getSize()).thenReturn((Object)0L);
        Mockito.when((Object)this.mockQueryResult.getRows()).thenReturn((Object)this.mockRowIterator);
        Mockito.when((Object)this.mockQuery.execute()).thenReturn((Object)this.mockQueryResult);
        Mockito.when((Object)this.mockQueryManager.createQuery(Matchers.anyString(), (String)Matchers.eq((Object)"JCR-SQL2"))).thenReturn((Object)this.mockQuery);
        Mockito.when((Object)this.mockWorkspace.getQueryManager()).thenReturn((Object)this.mockQueryManager);
        Mockito.when((Object)this.mockMetrics.getCounters()).thenReturn((Object)ImmutableSortedMap.of((Comparable)((Object)"LowLevelStorageService.fixity-check-counter"), (Object)this.mockCounter, (Comparable)((Object)"LowLevelStorageService.fixity-error-counter"), (Object)this.mockCounter, (Comparable)((Object)"LowLevelStorageService.fixity-repaired-counter"), (Object)this.mockCounter));
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/");
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType().getName()).thenReturn((Object)"mode:root");
        Mockito.when((Object)this.mockSession.getRepository()).thenReturn((Object)this.mockRepository);
        Mockito.when((Object)this.mockRepository.getDescriptorKeys()).thenReturn((Object)new String[]{"some-descriptor-key"});
        Mockito.when((Object)this.mockRepository.getDescriptor("some-descriptor-key")).thenReturn((Object)"some-descriptor-value");
        Mockito.when((Object)this.mockNodeTypeIterator.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNodeTypeManager.getAllNodeTypes()).thenReturn((Object)this.mockNodeTypeIterator);
        Mockito.when((Object)this.mockWorkspace.getNodeTypeManager()).thenReturn((Object)this.mockNodeTypeManager);
        Model actual = this.testObj.getJcrTriples(this.mockNode).asModel();
        Assert.assertTrue((boolean)actual.contains(this.testSubjects.getSubject(this.mockNode.getPath()), actual.createProperty("http://fedora.info/definitions/v4/repository#repository/some-descriptor-key"), (RDFNode)actual.createLiteral("some-descriptor-value")));
    }

    @Test
    public final void shouldExcludeBinaryProperties() throws RepositoryException, IOException {
        Mockito.when((Object)this.mockNode.getDepth()).thenReturn((Object)2);
        Mockito.reset((Object[])new Object[]{this.mockProperty, this.mockValue, this.mockNodes});
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)2);
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)false);
        Mockito.when((Object)this.mockProperty.getName()).thenReturn((Object)mockPredicateName);
        Mockito.when((Object)this.mockProperty.getBinary()).thenReturn((Object)this.mockBinary);
        Mockito.when((Object)this.mockProperty.getValue()).thenReturn((Object)this.mockValue);
        Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)2);
        Mockito.when((Object)this.mockNodes.hasNext()).thenReturn((Object)false);
        Model actual = this.testObj.getJcrTriples(this.mockNode).asModel();
        JcrRdfToolsTest.logRDF(actual);
        Assert.assertFalse((String)"RDF contained a statement based on a binary property when it shouldn't have!", (boolean)actual.contains(null, ResourceFactory.createProperty((String)mockPredicateName)));
    }

    @Test
    public final void shouldExcludeSomeProtectedProperties() throws RepositoryException, IOException {
        Mockito.when((Object)this.mockNode.hasProperties()).thenReturn((Object)true);
        Mockito.when((Object)this.mockPropertyDefinition.isProtected()).thenReturn((Object)true);
        Model actual = this.testObj.getJcrTriples(this.mockNode).asModel();
        Assert.assertFalse((String)"Found protected triple!", (boolean)actual.contains(this.testSubjects.getSubject(this.mockNode.getPath()), actual.getProperty(mockPredicateName), (RDFNode)actual.createLiteral("abc")));
    }

    @Test
    public final void shouldAllowSomeProtectedPropertiesForFrozenNodes() throws RepositoryException, IOException {
        Mockito.when((Object)this.mockNode.hasProperties()).thenReturn((Object)true);
        Mockito.when((Object)this.mockPropertyDefinition.isProtected()).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.isNodeType("nt:frozenNode")).thenReturn((Object)true);
        Model actual = this.testObj.getJcrTriples(this.mockNode).asModel();
        Assert.assertTrue((String)"Could not find protected triple!", (boolean)actual.contains(this.testSubjects.getSubject(this.mockNode.getPath()), actual.getProperty(mockPredicateName), (RDFNode)actual.createLiteral("abc")));
    }

    @Test
    public final void shouldBeAbleToDisableResourceInlining() throws RepositoryException {
        Model actual = this.testObj.getTreeTriples(this.mockNode).asModel();
        Assert.assertEquals((long)0L, (long)Iterators.size((Iterator)actual.listObjectsOfProperty(actual.createProperty("http://www.w3.org/ns/ldp#inlinedResource"))));
        ((Node)Mockito.verify((Object)this.mockParent, (VerificationMode)Mockito.never())).getProperties();
        ((Node)Mockito.verify((Object)this.mockNode, (VerificationMode)Mockito.never())).getNodes();
    }

    @Test
    public final void shouldIncludeContainerInfoWithMixinTypeContainer() throws RepositoryException {
        Mockito.when((Object)this.mockPrimaryNodeType.getChildNodeDefinitions()).thenReturn((Object)new NodeDefinition[0]);
        Mockito.when((Object)this.mockPrimaryNodeType.getName()).thenReturn((Object)"jcr:someType");
        Mockito.when((Object)this.mockMixinNodeType.getName()).thenReturn((Object)"jcr:mixin");
        Mockito.when((Object)this.mockMixinNodeType.getChildNodeDefinitions()).thenReturn((Object)new NodeDefinition[]{(NodeDefinition)Mockito.mock(NodeDefinition.class)});
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockPrimaryNodeType);
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[]{this.mockMixinNodeType});
        Mockito.when((Object)this.mockPrimaryNodeType.getSupertypes()).thenReturn((Object)new NodeType[]{this.mockNodeType});
        Mockito.when((Object)this.mockMixinNodeType.getSupertypes()).thenReturn((Object)new NodeType[]{this.mockNodeType});
        Mockito.when((Object)this.mockProperties.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.getDepth()).thenReturn((Object)0);
        Mockito.when((Object)this.mockNodes.hasNext()).thenReturn((Object)false);
        Model actual = this.testObj.getTreeTriples(this.mockNode).asModel();
        Resource graphSubject = this.testSubjects.getSubject(this.mockNode.getPath());
        Assert.assertTrue((boolean)actual.contains(graphSubject, RDF.type, (RDFNode)RdfLexicon.DIRECT_CONTAINER));
        Assert.assertTrue((boolean)actual.contains(graphSubject, RdfLexicon.MEMBERSHIP_RESOURCE, (RDFNode)graphSubject));
        Assert.assertTrue((boolean)actual.contains(graphSubject, RdfLexicon.HAS_MEMBER_RELATION, (RDFNode)RdfLexicon.HAS_CHILD));
    }

    @Test
    public void shouldIncludeFullChildNodeInformationInsideWindow() throws RepositoryException {
        Mockito.reset((Object[])new Object[]{this.mockChildNode, this.mockNodes, this.mockNode});
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)this.mockNodes);
        Mockito.when((Object)this.mockNode.hasNodes()).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.getName()).thenReturn((Object)"mockNode");
        Mockito.when((Object)this.mockNode.getProperties()).thenReturn((Object)this.mockProperties);
        Mockito.when((Object)this.mockNode.getDepth()).thenReturn((Object)0);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        Mockito.when((Object)this.mockNodes.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)this.mockNodes.next()).thenReturn((Object)this.mockFullChildNode, new Object[]{this.mockFullChildNode, this.mockChildNode});
        Mockito.when((Object)this.mockChildNode.getName()).thenReturn((Object)"some-name");
        Mockito.when((Object)this.mockChildNode.getPath()).thenReturn((Object)"/test/jcr/1", (Object[])new String[]{"/test/jcr/4", "/test/jcr/5"});
        Mockito.when((Object)this.mockFullChildNode.getName()).thenReturn((Object)"some-other-name");
        Mockito.when((Object)this.mockFullChildNode.getPath()).thenReturn((Object)"/test/jcr/2", (Object[])new String[]{"/test/jcr/3"});
        Mockito.when((Object)this.mockFullChildNode.getProperties()).thenReturn((Object)this.mockProperties);
        Mockito.when((Object)this.mockProperties.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.hasNodes()).thenReturn((Object)true);
        HierarchyRdfContextOptions options = new HierarchyRdfContextOptions(2, 0, true, false);
        Model actual = this.testObj.getTreeTriples(this.mockNode, options).asModel();
        Assert.assertEquals((long)2L, (long)Iterators.size((Iterator)actual.listObjectsOfProperty(this.testSubjects.getSubject(this.mockNode.getPath()), RdfLexicon.HAS_CHILD)));
        ((Node)Mockito.verify((Object)this.mockChildNode, (VerificationMode)Mockito.never())).getProperties();
    }

    @Test
    public final void shouldMapRdfValuesToJcrPropertyValues() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getSession().getValueFactory()).thenReturn((Object)this.mockValueFactory);
        Resource n = ResourceFactory.createResource((String)"info:fedora/abc");
        Mockito.when((Object)this.mockSession.getNode("/abc")).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockSession.nodeExists("/abc")).thenReturn((Object)true);
        this.testObj.createValue(this.mockNode, (RDFNode)n, 9);
        ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue(this.mockNode, false);
        this.testObj.createValue(this.mockNode, (RDFNode)n, 10);
        ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue(this.mockNode, true);
        this.testObj.createValue(this.mockNode, (RDFNode)n, 0);
        ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue("info:fedora/abc", 11);
        n = ResourceFactory.createResource();
        this.testObj.createValue(this.mockNode, (RDFNode)n, 0);
        ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue(n.toString(), 0);
        n = ResourceFactory.createTypedLiteral((Object)true);
        this.testObj.createValue(this.mockNode, (RDFNode)n, 0);
        ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue(true);
        n = ResourceFactory.createTypedLiteral((String)"1", (RDFDatatype)XSDDatatype.XSDbyte);
        this.testObj.createValue(this.mockNode, (RDFNode)n, 0);
        ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue(1L);
        n = ResourceFactory.createTypedLiteral((Object)2.0);
        this.testObj.createValue(this.mockNode, (RDFNode)n, 0);
        ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue(2.0);
        n = ResourceFactory.createTypedLiteral((Object)Float.valueOf(3.0f));
        this.testObj.createValue(this.mockNode, (RDFNode)n, 0);
        ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue(3.0);
        n = ResourceFactory.createTypedLiteral((Object)4);
        this.testObj.createValue(this.mockNode, (RDFNode)n, 0);
        ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue(4L);
        n = ResourceFactory.createTypedLiteral((String)"5", (RDFDatatype)XSDDatatype.XSDlong);
        this.testObj.createValue(this.mockNode, (RDFNode)n, 0);
        ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue(5L);
        n = ResourceFactory.createTypedLiteral((String)"6", (RDFDatatype)XSDDatatype.XSDshort);
        this.testObj.createValue(this.mockNode, (RDFNode)n, 0);
        ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue(6L);
        Calendar calendar = Calendar.getInstance();
        n = ResourceFactory.createTypedLiteral((Object)calendar);
        this.testObj.createValue(this.mockNode, (RDFNode)n, 0);
        ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue((Calendar)Matchers.any(Calendar.class));
        n = ResourceFactory.createTypedLiteral((Object)"string");
        this.testObj.createValue(this.mockNode, (RDFNode)n, 0);
        ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue("string", 1);
        n = ResourceFactory.createTypedLiteral((Object)"string");
        this.testObj.createValue(this.mockNode, (RDFNode)n, 7);
        ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue("string", 7);
    }

    @Test(expected=ValueFormatException.class)
    public final void shouldMapRdfValuesToJcrPropertyValuesError() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getSession().getValueFactory()).thenReturn((Object)this.mockValueFactory);
        Resource n = ResourceFactory.createResource();
        this.testObj.createValue(this.mockNode, (RDFNode)n, 9);
    }

    @Test
    public final void testJcrNodeIteratorModel() throws RepositoryException {
        Mockito.when((Object)this.mockNodes.hasNext()).thenReturn((Object)false);
        Model model = this.testObj.getJcrPropertiesModel((Iterator)new NodeIterator(this.mockNodes), this.mockResource).asModel();
        Assert.assertNotNull((Object)model);
    }

    @Test
    public final void testJcrNodeIteratorAddsPredicatesForEachNode() throws RepositoryException {
        Resource mockResource = ResourceFactory.createResource((String)"info:fedora/search/resource");
        Mockito.when((Object)this.mockProperties.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode1.getProperties()).thenReturn((Object)this.mockProperties);
        Mockito.when((Object)this.mockNode1.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockNode2.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockNode3.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockNode1.getPath()).thenReturn((Object)"/path/to/first/node");
        Mockito.when((Object)this.mockNode2.getPath()).thenReturn((Object)"/second/path/to/node");
        Mockito.when((Object)this.mockNode3.getPath()).thenReturn((Object)"/third/path/to/node");
        Mockito.when((Object)this.mockNode1.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNode2.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNode3.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNode1.getMixinNodeTypes()).thenReturn((Object)emptyNodeTypes);
        Mockito.when((Object)this.mockNode2.getMixinNodeTypes()).thenReturn((Object)emptyNodeTypes);
        Mockito.when((Object)this.mockNode3.getMixinNodeTypes()).thenReturn((Object)emptyNodeTypes);
        Mockito.when((Object)this.mockNode1.getProperties()).thenReturn((Object)this.mockProperties);
        Mockito.when((Object)this.mockNode2.getProperties()).thenReturn((Object)this.mockProperties);
        Mockito.when((Object)this.mockNode3.getProperties()).thenReturn((Object)this.mockProperties);
        Iterator<Node> mockIterator = Arrays.asList(this.mockNode1, this.mockNode2, this.mockNode3).iterator();
        Model model = this.testObj.getJcrPropertiesModel(mockIterator, mockResource).asModel();
        Assert.assertEquals((long)3L, (long)model.listObjectsOfProperty(RdfLexicon.HAS_MEMBER_OF_RESULT).toSet().size());
    }

    @Test
    public final void testGetFixityResultsModel() throws RepositoryException, URISyntaxException, IOException {
        Mockito.when((Object)this.mockCacheEntry.getExternalIdentifier()).thenReturn((Object)"http://xyz");
        String testFixityUri = "http://abc";
        FixityResultImpl mockResult = new FixityResultImpl(this.mockCacheEntry, 123L, new URI("http://abc"));
        mockResult.getStatus().add(FixityResult.FixityState.BAD_CHECKSUM);
        mockResult.getStatus().add(FixityResult.FixityState.BAD_SIZE);
        List<FixityResult> mockBlobs = Arrays.asList(mockResult);
        Model fixityResultsModel = this.testObj.getJcrTriples(this.mockNode, mockBlobs).asModel();
        JcrRdfToolsTest.logRDF(fixityResultsModel);
        Assert.assertTrue((boolean)fixityResultsModel.contains(ResourceFactory.createResource((String)"info:fedora/test/jcr"), RdfLexicon.HAS_FIXITY_RESULT, (RDFNode)null));
        Assert.assertTrue((boolean)fixityResultsModel.contains(null, RdfLexicon.HAS_MESSAGE_DIGEST, (RDFNode)ResourceFactory.createResource((String)"http://abc")));
        Assert.assertTrue((boolean)fixityResultsModel.contains(null, RdfLexicon.HAS_SIZE, (RDFNode)ResourceFactory.createTypedLiteral((Object)123)));
    }

    @Test
    public final void testGetJcrNamespaceModel() throws Exception {
        Model jcrNamespaceModel = this.testObj.getNamespaceTriples().asModel();
        Assert.assertTrue((boolean)jcrNamespaceModel.contains(ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/repository#"), RdfLexicon.HAS_NAMESPACE_PREFIX, "fcrepo"));
        Resource nsSubject = ResourceFactory.createResource((String)mockUri);
        Assert.assertTrue((boolean)jcrNamespaceModel.contains(nsSubject, RDF.type, (RDFNode)RdfLexicon.VOAF_VOCABULARY));
        Assert.assertTrue((boolean)jcrNamespaceModel.contains(nsSubject, RdfLexicon.HAS_NAMESPACE_PREFIX, "some-prefix"));
        Assert.assertTrue((boolean)jcrNamespaceModel.contains(nsSubject, RdfLexicon.HAS_NAMESPACE_URI, mockUri));
    }

    @Test
    public final void testGetJcrVersionsModel() throws Exception {
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockVersionManager.getVersionHistory(this.mockNode.getPath())).thenReturn((Object)this.mockVersionHistory);
        Mockito.when((Object)this.mockVersionIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)this.mockFrozenNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockFrozenNode.getPath()).thenReturn((Object)"/jcr:system/versions/test/jcr");
        Mockito.when((Object)this.mockFrozenNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockFrozenNode.getMixinNodeTypes()).thenReturn((Object)emptyNodeTypes);
        Mockito.when((Object)this.mockVersion.getFrozenNode()).thenReturn((Object)this.mockFrozenNode);
        Mockito.when((Object)this.mockVersionIterator.next()).thenReturn((Object)this.mockVersion);
        Mockito.when((Object)this.mockVersionHistory.getAllVersions()).thenReturn((Object)this.mockVersionIterator);
        Mockito.when((Object)this.mockWorkspace.getVersionManager()).thenReturn((Object)this.mockVersionManager);
        Mockito.when((Object)this.mockVersionHistory.getVersionLabels(this.mockVersion)).thenReturn((Object)new String[]{"abc"});
        Mockito.when((Object)this.mockProperties.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockFrozenNode.getProperties()).thenReturn((Object)this.mockProperties);
        Model actual = this.testObj.getVersionTriples(this.mockNode).asModel();
        Assert.assertTrue((boolean)actual.contains(this.testSubjects.getSubject(this.mockNode.getPath()), RdfLexicon.HAS_VERSION, (RDFNode)this.testSubjects.getSubject(this.mockFrozenNode.getPath())));
        Assert.assertTrue((boolean)actual.contains(this.testSubjects.getSubject(this.mockFrozenNode.getPath()), RdfLexicon.HAS_VERSION_LABEL, (RDFNode)actual.createLiteral("abc")));
    }

    @Test
    public final void testIsInternalProperty() throws Exception {
        Assert.assertTrue((boolean)this.testObj.isInternalProperty(this.mockNode, (Resource)ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#", (String)"some-property")));
        Assert.assertTrue((boolean)this.testObj.isInternalProperty(this.mockNode, (Resource)ResourceFactory.createProperty((String)"http://www.jcp.org/jcr/1.0", (String)"some-property")));
        Assert.assertTrue((boolean)this.testObj.isInternalProperty(this.mockNode, (Resource)ResourceFactory.createProperty((String)"http://www.w3.org/ns/ldp#some-property")));
        Assert.assertFalse((boolean)this.testObj.isInternalProperty(this.mockNode, (Resource)ResourceFactory.createProperty((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#label")));
        Assert.assertFalse((boolean)this.testObj.isInternalProperty(this.mockNode, (Resource)ResourceFactory.createProperty((String)"my-own-ns", (String)"some-property")));
    }

    private void mockNamespaceRegistry() throws RepositoryException {
        Mockito.when((Object)this.mockNsRegistry.isRegisteredUri(mockUri)).thenReturn((Object)true);
        Mockito.when((Object)this.mockNsRegistry.isRegisteredUri("not-registered-uri#")).thenReturn((Object)false);
        Mockito.when((Object)this.mockNsRegistry.isRegisteredUri("http://www.jcp.org/jcr/1.0")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNsRegistry.getPrefix("http://www.jcp.org/jcr/1.0")).thenReturn((Object)"jcr");
        Mockito.when((Object)this.mockNsRegistry.getPrefix(mockUri)).thenReturn((Object)"some-prefix");
        Mockito.when((Object)this.mockNsRegistry.getURI("jcr")).thenReturn((Object)"http://www.jcp.org/jcr/1.0");
        Mockito.when((Object)this.mockNsRegistry.getURI("some-prefix")).thenReturn((Object)mockUri);
        Mockito.when((Object)this.mockNsRegistry.getPrefixes()).thenReturn((Object)new String[]{"jcr", "some-prefix"});
        Mockito.when((Object)this.mockSession.getWorkspace().getNamespaceRegistry()).thenReturn((Object)this.mockNsRegistry);
        Mockito.when((Object)this.mockNode.getSession().getWorkspace().getNamespaceRegistry()).thenReturn((Object)this.mockNsRegistry);
    }

    @Test
    public final void shouldMapInternalJcrNamespaceToFcrepoNamespace() {
        Assert.assertEquals((Object)"http://fedora.info/definitions/v4/repository#", (Object)JcrRdfTools.getRDFNamespaceForJcrNamespace((String)"http://www.jcp.org/jcr/1.0"));
    }

    @Test
    public final void shouldMapFcrepoNamespaceToJcrNamespace() {
        Assert.assertEquals((Object)"http://www.jcp.org/jcr/1.0", (Object)JcrRdfTools.getJcrNamespaceForRDFNamespace((String)"http://fedora.info/definitions/v4/repository#"));
    }

    @Test
    public final void shouldPassThroughOtherNamespaceValues() {
        Assert.assertEquals((Object)"some-namespace-uri", (Object)JcrRdfTools.getJcrNamespaceForRDFNamespace((String)"some-namespace-uri"));
        Assert.assertEquals((Object)"some-namespace-uri", (Object)JcrRdfTools.getRDFNamespaceForJcrNamespace((String)"some-namespace-uri"));
    }

    @Test
    public final void shouldMapRdfPredicatesToJcrProperties() throws RepositoryException {
        com.hp.hpl.jena.rdf.model.Property p = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#", (String)"uuid");
        Assert.assertEquals((Object)"jcr:uuid", (Object)this.testObj.getPropertyNameFromPredicate(this.mockNode, p));
    }

    @Test
    public final void shouldReuseRegisteredNamespaces() throws RepositoryException {
        com.hp.hpl.jena.rdf.model.Property p = ResourceFactory.createProperty((String)mockUri, (String)"uuid");
        Assert.assertEquals((Object)"some-prefix:uuid", (Object)this.testObj.getPropertyNameFromPredicate(this.mockNode, p));
    }

    @Test
    public final void shouldRegisterUnknownUris() throws RepositoryException {
        Mockito.when((Object)this.mockNsRegistry.registerNamespace("not-registered-uri#")).thenReturn((Object)"ns001");
        com.hp.hpl.jena.rdf.model.Property p = ResourceFactory.createProperty((String)"not-registered-uri#", (String)"uuid");
        Assert.assertEquals((Object)"ns001:uuid", (Object)this.testObj.getPropertyNameFromPredicate(this.mockNode, p));
    }

    @Test
    public final void shouldMapInternalReferencePropertiesToPublicUris() throws RepositoryException {
        Mockito.when((Object)this.mockNamespacedProperty.getNamespaceURI()).thenReturn((Object)"info:xyz#");
        Mockito.when((Object)this.mockNamespacedProperty.getLocalName()).thenReturn((Object)NodePropertiesTools.getReferencePropertyName((String)"some_reference"));
        Mockito.when((Object)this.mockNamespacedProperty.getType()).thenReturn((Object)9);
        Mockito.when((Object)this.mockNamespacedProperty.getName()).thenReturn((Object)("xyz:" + NodePropertiesTools.getReferencePropertyName((String)"some_reference")));
        com.hp.hpl.jena.rdf.model.Property property = (com.hp.hpl.jena.rdf.model.Property)JcrRdfTools.getPredicateForProperty.apply((Object)this.mockNamespacedProperty);
        assert (property != null);
        Assert.assertEquals((Object)"some_reference", (Object)property.getLocalName());
    }

    private static void logRDF(Model rdf) throws IOException {
        try (StringWriter writer = new StringWriter();){
            rdf.write((Writer)writer);
            LOGGER.debug("Found model: {}", (Object)writer);
        }
    }

    private static interface NamespacedProperty
    extends Namespaced,
    Property {
    }
}

