/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import org.fcrepo.jcr.FedoraJcrTypes;
import org.fcrepo.kernel.impl.rdf.JcrRdfTools;
import org.fcrepo.kernel.impl.services.RepositoryServiceImpl;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.services.RepositoryService;
import org.fcrepo.kernel.utils.iterators.NodeIterator;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.modeshape.jcr.api.NamespaceRegistry;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "org.apache.xerces.*", "javax.xml.*", "org.xml.sax.*", "javax.management.*"})
@PrepareForTest(value={JcrRdfTools.class})
public class RepositoryServiceImplTest
implements FedoraJcrTypes {
    private static final String TESTPID = "testObj";
    private static final String TESTDSID = "testDs";
    private static final String MOCKPREFIX = "mock1";
    private static final Long EXPECTED_SIZE = 5L;
    private static final Long EXPECTED_COUNT = 0L;
    private RepositoryService testObj;
    @Mock
    private Repository mockRepo;
    @Mock
    private Session mockSession;
    @Mock
    private Node mockRootNode;
    @Mock
    private Node mockDsNode;
    @Mock
    private Property mockProp;
    @Mock
    private javax.jcr.NodeIterator mockNI;
    @Mock
    private RowIterator mockRowIterator;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private QueryManager mockQueryManager;
    @Mock
    private QueryObjectModel mockQueryOM;
    @Mock
    private QueryResult mockQueryResult;
    @Mock
    private Query mockQuery;
    @Mock
    private RowIterator mockRI;
    @Mock
    private Value mockValue;
    @Mock
    private Row mockRow;
    @Mock
    private IdentifierTranslator mockSubjectFactory;
    @Mock
    private QueryObjectModelFactory mockQOMFactory;
    @Mock
    private ValueFactory mockFactory;
    @Mock
    private NamespaceRegistry mockNamespaceRegistry;
    private Map<String, String> expectedNS;
    private Resource subject;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        String relPath = "/testObj/testDs";
        String[] mockPrefixes = new String[]{MOCKPREFIX};
        this.expectedNS = new HashMap<String, String>();
        try {
            Mockito.when((Object)this.mockSession.getRootNode()).thenReturn((Object)this.mockRootNode);
            Mockito.when((Object)this.mockRootNode.getNode("/testObj/testDs")).thenReturn((Object)this.mockDsNode);
            Mockito.when((Object)this.mockRootNode.getProperty("fedora:size")).thenReturn((Object)this.mockProp);
            Mockito.when((Object)this.mockProp.getLong()).thenReturn((Object)EXPECTED_SIZE);
            Mockito.when((Object)this.mockRepo.login()).thenReturn((Object)this.mockSession);
            this.testObj = new RepositoryServiceImpl();
            this.testObj.setRepository(this.mockRepo);
            Mockito.when((Object)this.mockSession.getNode("/objects")).thenReturn((Object)this.mockRootNode);
            Mockito.when((Object)this.mockRootNode.getNodes()).thenReturn((Object)this.mockNI);
            Mockito.when((Object)this.mockNI.getSize()).thenReturn((Object)EXPECTED_SIZE);
            Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
            Mockito.when((Object)this.mockWorkspace.getQueryManager()).thenReturn((Object)this.mockQueryManager);
            Mockito.when((Object)this.mockWorkspace.getNamespaceRegistry()).thenReturn((Object)this.mockNamespaceRegistry);
            Mockito.when((Object)this.mockNamespaceRegistry.getPrefixes()).thenReturn((Object)mockPrefixes);
            Mockito.when((Object)this.mockQueryManager.createQuery(Matchers.anyString(), (String)Matchers.eq((Object)"JCR-SQL2"))).thenReturn((Object)this.mockQuery);
            Mockito.when((Object)this.mockQuery.execute()).thenReturn((Object)this.mockQueryResult);
            Mockito.when((Object)this.mockQueryResult.getRows()).thenReturn((Object)this.mockRI);
            Mockito.when((Object)this.mockRI.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
            Mockito.when((Object)this.mockRI.nextRow()).thenReturn((Object)this.mockRow);
            Mockito.when((Object)this.mockRow.getValue("premis:hasSize")).thenReturn((Object)this.mockValue);
            Mockito.when((Object)this.mockValue.getLong()).thenReturn((Object)EXPECTED_SIZE);
            this.expectedNS.put(MOCKPREFIX, this.mockNamespaceRegistry.getURI(MOCKPREFIX));
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetRepositorySize() {
        Long actual = this.testObj.getRepositorySize();
        Assert.assertEquals((Object)EXPECTED_SIZE, (Object)actual);
    }

    @Test
    public void testGetRepositoryObjectCount() {
        Long actual = this.testObj.getRepositoryObjectCount();
        Assert.assertEquals((Object)EXPECTED_COUNT, (Object)actual);
    }

    @Test
    public void testGetRepositoryNamespaces() throws RepositoryException {
        Map actual = this.testObj.getRepositoryNamespaces(this.mockSession);
        Assert.assertEquals(this.expectedNS, (Object)actual);
    }

    private void setupSearchRepository() throws RepositoryException {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        JcrRdfTools mockJcrRdfTools = (JcrRdfTools)Mockito.mock(JcrRdfTools.class);
        Mockito.when((Object)JcrRdfTools.withContext((IdentifierTranslator)this.mockSubjectFactory, (Session)this.mockSession)).thenReturn((Object)mockJcrRdfTools);
        this.subject = ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/rest-api#search/request");
        Mockito.when((Object)this.mockSession.getValueFactory()).thenReturn((Object)this.mockFactory);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getQueryManager()).thenReturn((Object)this.mockQueryManager);
        Mockito.when((Object)this.mockQueryManager.getQOMFactory()).thenReturn((Object)this.mockQOMFactory);
        Mockito.when((Object)this.mockQOMFactory.createQuery(null, null, null, null)).thenReturn((Object)this.mockQueryOM);
        Mockito.when((Object)this.mockQueryOM.execute()).thenReturn((Object)this.mockQueryResult);
        Mockito.when((Object)this.mockQueryResult.getNodes()).thenReturn((Object)this.mockNI);
        Mockito.when((Object)this.mockNI.getSize()).thenReturn((Object)500L);
        Mockito.when((Object)this.mockNI.next()).thenReturn((Object)"");
        Mockito.when((Object)mockJcrRdfTools.getJcrPropertiesModel((Iterator)Matchers.any(NodeIterator.class), (Resource)Matchers.eq((Object)this.subject))).thenReturn((Object)new RdfStream());
    }

    @Test
    public void testSearchRepository() throws RepositoryException {
        this.setupSearchRepository();
        Dataset dataset = this.testObj.searchRepository(this.mockSubjectFactory, this.subject, this.mockSession, "search terms", 10, 0L);
        ((QueryObjectModel)Mockito.verify((Object)this.mockQueryOM)).setLimit(11L);
        ((QueryObjectModel)Mockito.verify((Object)this.mockQueryOM)).setOffset(0L);
        ((QueryObjectModel)Mockito.verify((Object)this.mockQueryOM)).execute();
        Assert.assertFalse((String)"Dataset graph should contain results", (boolean)dataset.getDefaultModel().getGraph().isEmpty());
    }

    @Test
    public void testSearchRepositoryNullSearchTerms() throws RepositoryException {
        this.setupSearchRepository();
        Dataset dataset = this.testObj.searchRepository(this.mockSubjectFactory, this.subject, this.mockSession, null, 10, 0L);
        ((QueryManager)Mockito.verify((Object)this.mockQueryManager, (VerificationMode)Mockito.never())).getQOMFactory();
        ((QueryObjectModel)Mockito.verify((Object)this.mockQueryOM, (VerificationMode)Mockito.never())).execute();
        Assert.assertTrue((String)"Null search terms should return an empty result graph", (boolean)dataset.getDefaultModel().getGraph().isEmpty());
    }

    @Test
    public void testSearchRepositoryNoSearchTerms() throws RepositoryException {
        this.setupSearchRepository();
        Dataset dataset = this.testObj.searchRepository(this.mockSubjectFactory, this.subject, this.mockSession, "", 10, 0L);
        ((QueryManager)Mockito.verify((Object)this.mockQueryManager, (VerificationMode)Mockito.never())).getQOMFactory();
        ((QueryObjectModel)Mockito.verify((Object)this.mockQueryOM, (VerificationMode)Mockito.never())).execute();
        Assert.assertTrue((String)"Blank query should return an empty result graph", (boolean)dataset.getDefaultModel().getGraph().isEmpty());
    }

    @Test
    public void testGetObjectSize() throws RepositoryException {
        Mockito.when((Object)this.mockRepo.login()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getQueryManager()).thenReturn((Object)this.mockQueryManager);
        Mockito.when((Object)this.mockQueryManager.createQuery("SELECT [premis:hasSize] FROM [fedora:binary]", "JCR-SQL2")).thenReturn((Object)this.mockQuery);
        Mockito.when((Object)this.mockQuery.execute()).thenReturn((Object)this.mockQueryResult);
        Mockito.when((Object)this.mockQueryResult.getRows()).thenReturn((Object)this.mockRowIterator);
        Mockito.when((Object)this.mockRowIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)this.mockRowIterator.nextRow()).thenReturn((Object)this.mockRow, (Object[])new Row[]{this.mockRow, this.mockRow});
        Mockito.when((Object)this.mockRow.getValue("premis:hasSize")).thenReturn((Object)this.mockValue);
        Mockito.when((Object)this.mockValue.getLong()).thenReturn((Object)5L, (Object[])new Long[]{10L, 1L});
        long count = this.testObj.getRepositorySize();
        Assert.assertEquals((String)"Got wrong count!", (long)16L, (long)count);
        ((Session)Mockito.verify((Object)this.mockSession)).logout();
        ((Session)Mockito.verify((Object)this.mockSession, (VerificationMode)Mockito.never())).save();
    }

    @Test
    public void testGetObjectCount() throws RepositoryException {
        Mockito.when((Object)this.mockRepo.login()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getQueryManager()).thenReturn((Object)this.mockQueryManager);
        Mockito.when((Object)this.mockQueryManager.createQuery("SELECT [jcr:path] FROM [fedora:object]", "JCR-SQL2")).thenReturn((Object)this.mockQuery);
        Mockito.when((Object)this.mockQuery.execute()).thenReturn((Object)this.mockQueryResult);
        Mockito.when((Object)this.mockQueryResult.getRows()).thenReturn((Object)this.mockRowIterator);
        Mockito.when((Object)this.mockRowIterator.getSize()).thenReturn((Object)3L);
        long count = this.testObj.getRepositoryObjectCount();
        Assert.assertEquals((long)3L, (long)count);
        ((Session)Mockito.verify((Object)this.mockSession)).logout();
        ((Session)Mockito.verify((Object)this.mockSession, (VerificationMode)Mockito.never())).save();
    }
}

