/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.identifiers;

import org.fcrepo.kernel.identifiers.InternalIdentifierConverter;
import org.fcrepo.kernel.impl.rdf.JcrRdfTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceConverter
extends InternalIdentifierConverter {
    private static final Logger log = LoggerFactory.getLogger(NamespaceConverter.class);

    protected String doForward(String inputId) {
        log.trace("Converting identifier {} from internal to external...", (Object)inputId);
        String result = inputId;
        for (String jcrNamespace : JcrRdfTools.jcrNamespacesToRDFNamespaces.keySet()) {
            log.trace("Replacing namespace: {} with: {}", (Object)jcrNamespace, JcrRdfTools.jcrNamespacesToRDFNamespaces.get((Object)jcrNamespace));
            result = result.replace(jcrNamespace, (CharSequence)JcrRdfTools.jcrNamespacesToRDFNamespaces.get((Object)jcrNamespace));
        }
        if (result.endsWith("jcr:content")) {
            result = result.replace("jcr:content", "fcr:content");
        }
        log.trace("Converted identifier {} from internal to external {}...", (Object)inputId, (Object)result);
        return result;
    }

    protected String doBackward(String b) {
        log.trace("Converting identifier from external to internal...");
        String result = b;
        for (String rdfNamespace : JcrRdfTools.rdfNamespacesToJcrNamespaces.keySet()) {
            log.trace("Replacing namespace: {} with: {}", (Object)rdfNamespace, JcrRdfTools.rdfNamespacesToJcrNamespaces.get((Object)rdfNamespace));
            result = result.replace(rdfNamespace, (CharSequence)JcrRdfTools.rdfNamespacesToJcrNamespaces.get((Object)rdfNamespace));
        }
        if (result.endsWith("fcr:content")) {
            result = result.replace("fcr:content", "jcr:content");
        }
        return result;
    }
}

