/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.Datastream;
import org.fcrepo.kernel.exception.InvalidChecksumException;
import org.fcrepo.kernel.impl.DatastreamImpl;
import org.fcrepo.kernel.impl.rdf.JcrRdfTools;
import org.fcrepo.kernel.impl.services.AbstractService;
import org.fcrepo.kernel.impl.utils.impl.CacheEntryFactory;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.services.DatastreamService;
import org.fcrepo.kernel.services.policy.StoragePolicyDecisionPoint;
import org.fcrepo.kernel.utils.FixityResult;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.fcrepo.metrics.RegistryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DatastreamServiceImpl
extends AbstractService
implements DatastreamService {
    @Autowired(required=false)
    StoragePolicyDecisionPoint storagePolicyDecisionPoint;
    static final Counter fixityCheckCounter = RegistryService.getMetrics().counter(MetricRegistry.name(DatastreamService.class, (String[])new String[]{"fixity-check-counter"}));
    static final Timer timer = RegistryService.getMetrics().timer(MetricRegistry.name(Datastream.class, (String[])new String[]{"fixity-check-time"}));
    private static final Logger LOGGER = LoggerFactory.getLogger(DatastreamService.class);

    public Datastream createDatastream(Session session, String dsPath) throws RepositoryException {
        return new DatastreamImpl(session, dsPath);
    }

    public Datastream createDatastream(Session session, String dsPath, String contentType, String originalFileName, InputStream requestBodyStream) throws RepositoryException, InvalidChecksumException {
        return this.createDatastream(session, dsPath, contentType, originalFileName, requestBodyStream, null);
    }

    public Datastream createDatastream(Session session, String dsPath, String contentType, String originalFileName, InputStream requestBodyStream, URI checksum) throws RepositoryException, InvalidChecksumException {
        Datastream ds = this.createDatastream(session, dsPath);
        ds.setContent(requestBodyStream, contentType, checksum, originalFileName, this.getStoragePolicyDecisionPoint());
        return ds;
    }

    public Node getDatastreamNode(Session session, String path) throws RepositoryException {
        LOGGER.trace("Executing getDatastreamNode() with path: {}", (Object)path);
        Node dsNode = this.getDatastream(session, path).getNode();
        LOGGER.trace("Retrieved datastream node: {}", (Object)dsNode.getName());
        return dsNode;
    }

    public Datastream getDatastream(Session session, String path) throws RepositoryException {
        return new DatastreamImpl(session, path);
    }

    public Datastream asDatastream(Node node) throws RepositoryException {
        return new DatastreamImpl(node);
    }

    public RdfStream getFixityResultsModel(IdentifierTranslator subjects, Datastream datastream) throws RepositoryException {
        Collection<FixityResult> blobs = this.runFixityAndFixProblems(datastream);
        return JcrRdfTools.withContext(subjects, datastream.getNode().getSession()).getJcrTriples(datastream.getNode(), blobs).topic(subjects.getSubject(datastream.getNode().getPath()).asNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FixityResult> runFixityAndFixProblems(Datastream datastream) throws RepositoryException {
        ImmutableSet goodEntries;
        ImmutableSet fixityResults;
        final URI digestUri = datastream.getContentDigest();
        final long size = datastream.getContentSize();
        fixityCheckCounter.inc();
        Timer.Context context = timer.time();
        try {
            fixityResults = ImmutableSet.copyOf(this.getFixity(datastream.getNode().getNode("jcr:content"), digestUri, size));
            goodEntries = ImmutableSet.copyOf((Collection)Collections2.filter((Collection)fixityResults, (Predicate)new Predicate<FixityResult>(){

                public boolean apply(FixityResult input) {
                    return input.matches(size, digestUri);
                }
            }));
        }
        finally {
            context.stop();
        }
        if (goodEntries.isEmpty()) {
            LOGGER.error("ALL COPIES OF " + datastream.getNode().getPath() + " HAVE FAILED FIXITY CHECKS.");
        }
        return fixityResults;
    }

    public Collection<FixityResult> getFixity(Node resource, URI dsChecksum, long dsSize) throws RepositoryException {
        LOGGER.debug("Checking resource: " + resource.getPath());
        return CacheEntryFactory.forProperty(this.repo, resource.getProperty("jcr:data")).checkFixity(dsChecksum, dsSize);
    }

    public void setStoragePolicyDecisionPoint(StoragePolicyDecisionPoint pdp) {
        this.storagePolicyDecisionPoint = pdp;
    }

    private StoragePolicyDecisionPoint getStoragePolicyDecisionPoint() {
        return this.storagePolicyDecisionPoint;
    }
}

