/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils.iterators;

import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.fcrepo.kernel.impl.utils.NodePropertiesTools;
import org.fcrepo.kernel.impl.utils.iterators.PersistingRdfStreamConsumer;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfRemover
extends PersistingRdfStreamConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RdfRemover.class);
    private final NodePropertiesTools propertiesTools = new NodePropertiesTools();

    public RdfRemover(IdentifierTranslator graphSubjects, Session session, RdfStream stream) {
        super(graphSubjects, session, stream);
    }

    @Override
    protected void operateOnMixin(Resource mixinResource, Node subjectNode) throws RepositoryException {
        String mixinName = this.getPropertyNameFromPredicate(subjectNode, mixinResource);
        if (this.session().getWorkspace().getNodeTypeManager().hasNodeType(mixinName)) {
            LOGGER.debug("Removing mixin: {} from node: {}.", (Object)mixinName, (Object)subjectNode.getPath());
            try {
                subjectNode.removeMixin(mixinName);
            }
            catch (NoSuchNodeTypeException e) {
                LOGGER.debug("which that node turned out not to have.");
                LOGGER.trace("Backtrace: ", (Throwable)e);
            }
        }
    }

    @Override
    protected void operateOnProperty(Statement t, Node n) throws RepositoryException {
        LOGGER.debug("Trying to remove property from triple: {} on node: {}.", (Object)t, (Object)n.getPath());
        String propertyName = this.getPropertyNameFromPredicate(n, t.getPredicate());
        if (n.hasProperty(propertyName)) {
            Value v = this.jcrRdfTools().createValue(n, t.getObject(), this.propertiesTools.getPropertyType(n, propertyName));
            this.propertiesTools.removeNodeProperty(this.idTranslator(), n, propertyName, v);
        }
    }
}

