/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.RepositoryException;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrWorkspace;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.RepositoryIndexManager;
import org.modeshape.jcr.RepositoryIndexes;
import org.modeshape.jcr.api.query.QueryCancelledException;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.PathCache;
import org.modeshape.jcr.cache.RepositoryCache;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.query.BufferManager;
import org.modeshape.jcr.query.CancellableQuery;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.QueryEngine;
import org.modeshape.jcr.query.QueryResults;
import org.modeshape.jcr.query.engine.IndexQueryEngine;
import org.modeshape.jcr.query.engine.ScanningQueryEngine;
import org.modeshape.jcr.query.model.QueryCommand;
import org.modeshape.jcr.query.plan.PlanHints;
import org.modeshape.jcr.query.validate.Schemata;
import org.modeshape.jcr.spi.index.IndexManager;
import org.modeshape.jcr.spi.index.IndexWriter;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.WorkspaceAndPath;

class RepositoryQueryManager
implements ChangeSetListener {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final JcrRepository.RunningState runningState;
    private final ExecutorService indexingExecutorService;
    private final RepositoryConfiguration repoConfig;
    private final RepositoryIndexManager indexManager;
    private final Lock engineInitLock = new ReentrantLock();
    private volatile QueryEngine queryEngine;
    private volatile Future<Void> asyncReindexingResult;
    private volatile RepositoryIndexManager.ScanningTasks toBeScanned = new RepositoryIndexManager.ScanningTasks();
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    RepositoryQueryManager(JcrRepository.RunningState runningState, ExecutorService indexingExecutorService, RepositoryConfiguration config) {
        this.runningState = runningState;
        this.indexingExecutorService = indexingExecutorService;
        this.repoConfig = config;
        this.indexManager = new RepositoryIndexManager(runningState, config);
    }

    synchronized void initialize() {
        this.toBeScanned.add(this.indexManager.initialize());
        this.initialized.set(true);
    }

    public synchronized void notify(ChangeSet changeSet) {
        boolean scanRequired = this.toBeScanned.add(this.indexManager.notify(changeSet));
        if (scanRequired && this.initialized.get()) {
            this.reindexIfNeeded();
        }
    }

    ChangeSetListener getListener() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        block7: {
            this.indexingExecutorService.shutdown();
            if (this.queryEngine != null) {
                try {
                    this.engineInitLock.lock();
                    if (this.queryEngine == null) break block7;
                    try {
                        this.queryEngine.shutdown();
                    }
                    finally {
                        this.queryEngine = null;
                    }
                }
                finally {
                    this.engineInitLock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopReindexing() {
        try {
            this.engineInitLock.lock();
            if (this.asyncReindexingResult != null) {
                try {
                    this.asyncReindexingResult.get(1L, TimeUnit.MINUTES);
                }
                catch (TimeoutException e) {
                    this.logger.debug("Re-indexing has not finished in time, attempting to cancel operation", new Object[0]);
                    this.asyncReindexingResult.cancel(true);
                }
                catch (Exception e) {
                    this.logger.debug((Throwable)e, "Unexpected exception while waiting for re-indexing to terminate", new Object[0]);
                }
            }
        }
        finally {
            this.asyncReindexingResult = null;
            this.engineInitLock.unlock();
        }
    }

    public CancellableQuery query(ExecutionContext context, RepositoryCache repositoryCache, Set<String> workspaceNames, Map<String, NodeCache> overriddenNodeCachesByWorkspaceName, org.modeshape.jcr.api.query.qom.QueryCommand query, Schemata schemata, RepositoryIndexes indexDefns, NodeTypes nodeTypes, PlanHints hints, Map<String, Object> variables) {
        final QueryEngine queryEngine = this.queryEngine();
        final QueryContext queryContext = queryEngine.createQueryContext(context, repositoryCache, workspaceNames, overriddenNodeCachesByWorkspaceName, schemata, indexDefns, nodeTypes, new BufferManager(context), hints, variables);
        final QueryCommand command = (QueryCommand)query;
        return new CancellableQuery(){
            private final Lock lock = new ReentrantLock();
            private QueryResults results;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public QueryResults execute() throws QueryCancelledException, RepositoryException {
                try {
                    this.lock.lock();
                    if (this.results == null) {
                        this.results = queryEngine.execute(queryContext, command);
                    }
                    QueryResults queryResults = this.results;
                    return queryResults;
                }
                finally {
                    this.lock.unlock();
                }
            }

            public boolean cancel() {
                return queryContext.cancel();
            }
        };
    }

    public IndexWriter getIndexWriter() {
        return this.indexManager.getIndexWriter();
    }

    protected IndexManager getIndexManager() {
        return this.indexManager;
    }

    RepositoryIndexes getIndexes() {
        return this.indexManager.getIndexes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final QueryEngine queryEngine() {
        if (this.queryEngine == null) {
            try {
                this.engineInitLock.lock();
                if (this.queryEngine == null) {
                    IndexQueryEngine.Builder builder = null;
                    if (!this.repoConfig.getIndexProviders().isEmpty()) {
                        builder = IndexQueryEngine.builder();
                        this.logger.debug("Queries with indexes are enabled for the '{0}' repository. Executing queries may require scanning the repository contents when the query cannot use the defined indexes.", new Object[]{this.repoConfig.getName()});
                    } else {
                        builder = ScanningQueryEngine.builder();
                        this.logger.debug("Queries with no indexes are enabled for the '{0}' repository. Executing queries will always scan the repository contents.", new Object[]{this.repoConfig.getName()});
                    }
                    this.queryEngine = builder.using(this.repoConfig, (IndexManager)this.indexManager, this.runningState.context()).build();
                }
            }
            finally {
                this.engineInitLock.unlock();
            }
        }
        return this.queryEngine;
    }

    protected void reindexIfNeeded() {
        final RepositoryIndexManager.ScanningRequest request = this.toBeScanned.drain();
        if (!request.isEmpty()) {
            final IndexWriter writer = this.indexManager.getIndexWriterForProviders(request.providerNames());
            final RepositoryCache repoCache = this.runningState.repositoryCache();
            this.scan(true, writer, new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    for (WorkspaceAndPath workspaceAndPath : request) {
                        String workspaceName = workspaceAndPath.getWorkspaceName();
                        WorkspaceCache workspaceCache = repoCache.getWorkspaceCache(workspaceName);
                        if (workspaceCache == null) continue;
                        Path path = workspaceAndPath.getPath();
                        CachedNode node = workspaceCache.getNode(workspaceCache.getRootKey());
                        if (!path.isRoot()) {
                            for (Path.Segment segment : path) {
                                ChildReference child = node.getChildReferences((NodeCache)workspaceCache).getChild(segment);
                                if (child == null) {
                                    node = null;
                                    break;
                                }
                                node = workspaceCache.getNode(child);
                                if (node != null) continue;
                                break;
                            }
                        }
                        if (node == null) continue;
                        boolean scanSystemContent = repoCache.getSystemWorkspaceName().equals(workspaceName);
                        RepositoryQueryManager.this.reindexContent(workspaceName, (NodeCache)workspaceCache, node, Integer.MAX_VALUE, scanSystemContent, writer);
                    }
                    return null;
                }
            });
        }
    }

    protected void cleanAndReindex(boolean async) {
        final IndexWriter writer = this.getIndexWriter();
        this.scan(async, this.getIndexWriter(), new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                writer.clearAllIndexes();
                RepositoryQueryManager.this.reindexContent(true, writer);
                return null;
            }
        });
    }

    private void scan(boolean async, IndexWriter indexes, Callable<Void> callable) {
        if (!indexes.canBeSkipped()) {
            if (async) {
                this.asyncReindexingResult = this.indexingExecutorService.submit(callable);
            } else {
                try {
                    callable.call();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException();
                }
            }
        }
    }

    private void reindexContent(boolean includeSystemContent, IndexWriter indexes) {
        if (indexes.canBeSkipped()) {
            return;
        }
        RepositoryCache repoCache = this.runningState.repositoryCache();
        this.logger.debug(JcrI18n.reindexAll.text(new Object[]{this.runningState.name()}), new Object[0]);
        if (includeSystemContent) {
            WorkspaceCache systemWorkspaceCache = repoCache.getWorkspaceCache(repoCache.getSystemWorkspaceName());
            CachedNode rootNode = systemWorkspaceCache.getNode(repoCache.getSystemKey());
            this.logger.debug("Starting reindex of system content in '{0}' repository.", new Object[]{this.runningState.name()});
            this.reindexSystemContent(rootNode, Integer.MAX_VALUE, indexes);
            this.logger.debug("Completed reindex of system content in '{0}' repository.", new Object[]{this.runningState.name()});
        }
        for (String workspaceName : repoCache.getWorkspaceNames()) {
            WorkspaceCache workspaceCache = repoCache.getWorkspaceCache(workspaceName);
            CachedNode rootNode = workspaceCache.getNode(workspaceCache.getRootKey());
            this.logger.debug("Starting reindex of workspace '{0}' content in '{1}' repository.", new Object[]{this.runningState.name(), workspaceName});
            this.reindexContent(workspaceName, (NodeCache)workspaceCache, rootNode, Integer.MAX_VALUE, false, indexes);
            this.logger.debug("Completed reindex of workspace '{0}' content in '{1}' repository.", new Object[]{this.runningState.name(), workspaceName});
        }
    }

    public void reindexContent(JcrWorkspace workspace) {
        this.reindexContent(workspace, Path.ROOT_PATH, Integer.MAX_VALUE);
    }

    public void reindexContent(JcrWorkspace workspace, Path path, int depth) {
        if (this.getIndexWriter().canBeSkipped()) {
            return;
        }
        CheckArg.isPositive((int)depth, (String)"depth");
        JcrSession session = workspace.getSession();
        NodeCache cache = session.cache().getWorkspace();
        String workspaceName = workspace.getName();
        CachedNode node = cache.getNode(cache.getRootKey());
        for (Path.Segment segment : path) {
            ChildReference ref = node.getChildReferences(cache).getChild(segment);
            if (ref == null) {
                return;
            }
            node = cache.getNode(ref);
        }
        String systemWorkspaceKey = this.runningState.repositoryCache().getSystemWorkspaceKey();
        if (node.getKey().getWorkspaceKey().equals(systemWorkspaceKey)) {
            this.reindexSystemContent(node, depth, this.getIndexWriter());
        } else {
            this.reindexContent(workspaceName, cache, node, depth, path.isRoot(), this.getIndexWriter());
        }
    }

    protected void reindexContent(String workspaceName, NodeCache cache, CachedNode node, int depth, boolean reindexSystemContent, IndexWriter indexes) {
        NodeKey key;
        assert (indexes != null);
        if (indexes.canBeSkipped()) {
            return;
        }
        if (!node.isQueryable(cache)) {
            return;
        }
        PathCache paths = new PathCache(cache);
        Path nodePath = paths.getPath(node);
        indexes.add(workspaceName, node.getKey(), nodePath, node.getPrimaryType(cache), node.getMixinTypes(cache), node.getPropertiesByName(cache));
        if (depth == 1) {
            return;
        }
        LinkedList<NodeKey> queue = new LinkedList<NodeKey>();
        if (reindexSystemContent) {
            ChildReferences childRefs = node.getChildReferences(cache);
            ChildReference systemRef = childRefs.getChild(JcrLexicon.SYSTEM);
            NodeKey systemKey = systemRef != null ? systemRef.getKey() : null;
            for (ChildReference childRef : node.getChildReferences(cache)) {
                NodeKey childKey = childRef.getKey();
                if (childKey.equals((Object)systemKey)) {
                    node = cache.getNode(childKey);
                    this.reindexSystemContent(node, depth - 1, indexes);
                    continue;
                }
                queue.add(childKey);
            }
        } else {
            for (ChildReference childRef : node.getChildReferences(cache)) {
                NodeKey childKey = childRef.getKey();
                if (childKey.getWorkspaceKey().equals(this.runningState.systemWorkspaceKey())) continue;
                queue.add(childKey);
            }
        }
        while ((key = (NodeKey)queue.poll()) != null) {
            node = cache.getNode(key);
            if (node == null || !node.isQueryable(cache)) continue;
            nodePath = paths.getPath(node);
            indexes.add(workspaceName, node.getKey(), nodePath, node.getPrimaryType(cache), node.getMixinTypes(cache), node.getPropertiesByName(cache));
            if (nodePath.size() > depth) continue;
            for (ChildReference childRef : node.getChildReferences(cache)) {
                queue.add(childRef.getKey());
            }
        }
    }

    protected void reindexSystemContent(CachedNode nodeInSystemBranch, int depth, IndexWriter indexes) {
        RepositoryCache repoCache = this.runningState.repositoryCache();
        String workspaceName = repoCache.getSystemWorkspaceName();
        WorkspaceCache systemWorkspaceCache = repoCache.getWorkspaceCache(workspaceName);
        this.reindexContent(workspaceName, (NodeCache)systemWorkspaceCache, nodeInSystemBranch, depth, true, indexes);
    }

    public Future<Boolean> reindexContentAsync(final JcrWorkspace workspace) {
        return this.indexingExecutorService.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                RepositoryQueryManager.this.reindexContent(workspace);
                return Boolean.TRUE;
            }
        });
    }

    public Future<Boolean> reindexContentAsync(final JcrWorkspace workspace, final Path path, final int depth) {
        return this.indexingExecutorService.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                RepositoryQueryManager.this.reindexContent(workspace, path, depth);
                return Boolean.TRUE;
            }
        });
    }
}

