/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.OnParentVersionAction;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeDefinitionTemplate;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNodeTypeTemplate;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrPropertyDefinitionTemplate;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.JcrValueFactory;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.RepositoryIndexColumnDefinition;
import org.modeshape.jcr.RepositoryIndexDefinition;
import org.modeshape.jcr.RepositoryLockManager;
import org.modeshape.jcr.api.PropertyType;
import org.modeshape.jcr.api.index.IndexColumnDefinition;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.PropertyTypeUtil;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.PropertyFactory;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ReferenceFactory;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.basic.BasicName;
import org.modeshape.jcr.value.basic.BasicNamespace;
import org.modeshape.jcr.value.basic.NodeKeyReference;

public class SystemContent {
    public static final String GENERATED_PREFIX = "ns";
    private static final Name GENERATED_NAMESPACE_NODE_NAME = new BasicName("", "ns");
    protected static final Pattern GENERATED_PREFIX_PATTERN = Pattern.compile("ns(\\d{3})");
    private final SessionCache system;
    private NodeKey systemKey;
    private NodeKey nodeTypesKey;
    private NodeKey namespacesKey;
    private NodeKey locksKey;
    private NodeKey versionStorageKey;
    private NodeKey indexesKey;
    private final PropertyFactory propertyFactory;
    private final ValueFactory<Boolean> booleans;
    private final ValueFactory<String> strings;
    private final NameFactory names;
    private final ReferenceFactory referenceFactory;
    private final javax.jcr.ValueFactory jcrValues;

    SystemContent(SessionCache systemCache) {
        this.system = systemCache;
        ExecutionContext context = systemCache.getContext();
        this.propertyFactory = context.getPropertyFactory();
        ValueFactories factories = context.getValueFactories();
        this.booleans = factories.getBooleanFactory();
        this.strings = factories.getStringFactory();
        this.names = factories.getNameFactory();
        this.referenceFactory = factories.getReferenceFactory();
        this.jcrValues = new JcrValueFactory(context);
    }

    public void save() {
        this.system.save();
    }

    private final ExecutionContext context() {
        return this.system.getContext();
    }

    public final SessionCache cache() {
        return this.system;
    }

    public NodeKey systemKey() {
        if (this.systemKey == null) {
            CachedNode rootNode = this.system.getNode(this.system.getRootKey());
            ChildReference systemRef = rootNode.getChildReferences((NodeCache)this.system).getChild(JcrLexicon.SYSTEM);
            this.systemKey = systemRef.getKey();
        }
        return this.systemKey;
    }

    public NodeKey nodeTypesKey() {
        if (this.nodeTypesKey == null) {
            CachedNode systemNode = this.systemNode();
            ChildReference nodeTypesRef = systemNode.getChildReferences((NodeCache)this.system).getChild(JcrLexicon.NODE_TYPES);
            this.nodeTypesKey = nodeTypesRef.getKey();
        }
        return this.nodeTypesKey;
    }

    public NodeKey indexesKey() {
        if (this.indexesKey == null) {
            CachedNode systemNode = this.systemNode();
            ChildReference nodeTypesRef = systemNode.getChildReferences((NodeCache)this.system).getChild(ModeShapeLexicon.INDEXES);
            this.indexesKey = nodeTypesRef.getKey();
        }
        return this.indexesKey;
    }

    public NodeKey namespacesKey() {
        if (this.namespacesKey == null) {
            CachedNode systemNode = this.systemNode();
            ChildReference namespacesRef = systemNode.getChildReferences((NodeCache)this.system).getChild(ModeShapeLexicon.NAMESPACES);
            this.namespacesKey = namespacesRef.getKey();
        }
        return this.namespacesKey;
    }

    public NodeKey locksKey() {
        if (this.locksKey == null) {
            CachedNode systemNode = this.systemNode();
            ChildReference locksRef = systemNode.getChildReferences((NodeCache)this.system).getChild(ModeShapeLexicon.LOCKS);
            this.locksKey = locksRef.getKey();
        }
        return this.locksKey;
    }

    public NodeKey versionStorageKey() {
        if (this.versionStorageKey == null) {
            CachedNode systemNode = this.systemNode();
            ChildReference locksRef = systemNode.getChildReferences((NodeCache)this.system).getChild(JcrLexicon.VERSION_STORAGE);
            this.versionStorageKey = locksRef.getKey();
        }
        return this.versionStorageKey;
    }

    public CachedNode systemNode() {
        return this.system.getNode(this.systemKey());
    }

    public CachedNode nodeTypesNode() {
        return this.system.getNode(this.nodeTypesKey());
    }

    public CachedNode namespacesNode() {
        return this.system.getNode(this.namespacesKey());
    }

    public CachedNode indexesNode() {
        return this.system.getNode(this.indexesKey());
    }

    public CachedNode locksNode() {
        return this.system.getNode(this.locksKey());
    }

    public CachedNode versionStorageNode() {
        return this.system.getNode(this.versionStorageKey());
    }

    public MutableCachedNode mutableNodeTypesNode() {
        return this.system.mutable(this.nodeTypesKey());
    }

    public MutableCachedNode mutableNamespacesNode() {
        return this.system.mutable(this.namespacesKey());
    }

    public MutableCachedNode mutableIndexesNode() {
        return this.system.mutable(this.indexesKey());
    }

    public MutableCachedNode mutableLocksNode() {
        return this.system.mutable(this.locksKey());
    }

    public MutableCachedNode mutableVersionStorageNode() {
        return this.system.mutable(this.versionStorageKey());
    }

    public MutableCachedNode mutableSystemNode() {
        return this.system.mutable(this.systemKey());
    }

    public void store(Iterable<JcrNodeType> nodeTypes, boolean updateExisting) {
        MutableCachedNode nodeTypesNode = this.mutableNodeTypesNode();
        HashSet<Name> names = new HashSet<Name>();
        HashSet<NodeKey> keys = new HashSet<NodeKey>();
        for (JcrNodeType nodeType : nodeTypes) {
            if (!names.add(nodeType.getInternalName())) {
                Logger.getLogger(this.getClass()).debug("Found duplicate node type: " + nodeType, new Object[0]);
            }
            if (keys.add(nodeType.key())) continue;
            Logger.getLogger(this.getClass()).debug("Found duplicate key: " + nodeType, new Object[0]);
        }
        for (JcrNodeType nodeType : nodeTypes) {
            this.store(nodeType, nodeTypesNode, updateExisting);
        }
    }

    public void store(JcrNodeType nodeType, boolean updateExisting) {
        MutableCachedNode nodeTypesNode = this.mutableNodeTypesNode();
        this.store(nodeType, nodeTypesNode, updateExisting);
    }

    private void store(JcrNodeType nodeType, MutableCachedNode nodeTypes, boolean updateExisting) {
        assert (nodeType != null);
        assert (this.system != null);
        assert (nodeTypes != null);
        Name name = nodeType.getInternalName();
        NodeKey key = nodeType.key();
        MutableCachedNode nodeTypeNode = null;
        HashSet<NodeKey> existingChildKeys = null;
        if (nodeTypes.getChildReferences((NodeCache)this.system).hasChild(key)) {
            if (!updateExisting) {
                return;
            }
            nodeTypeNode = this.system.mutable(key);
            existingChildKeys = new HashSet<NodeKey>();
            for (ChildReference childRef : nodeTypeNode.getChildReferences((NodeCache)this.system)) {
                existingChildKeys.add(childRef.getKey());
            }
        }
        JcrNodeType[] supertypes = nodeType.getDeclaredSupertypes();
        ArrayList<Name> supertypeNames = new ArrayList<Name>(supertypes.length);
        for (int i = 0; i < supertypes.length; ++i) {
            supertypeNames.add(supertypes[i].getInternalName());
        }
        ArrayList<Property> properties = new ArrayList<Property>();
        properties.add(this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, (Object)JcrNtLexicon.NODE_TYPE));
        properties.add(this.propertyFactory.create(JcrLexicon.IS_MIXIN, (Object)nodeType.isMixin()));
        properties.add(this.propertyFactory.create(JcrLexicon.IS_ABSTRACT, (Object)nodeType.isAbstract()));
        properties.add(this.propertyFactory.create(JcrLexicon.IS_QUERYABLE, (Object)nodeType.isQueryable()));
        if (nodeType.getPrimaryItemName() != null) {
            properties.add(this.propertyFactory.create(JcrLexicon.PRIMARY_ITEM_NAME, (Object)nodeType.getPrimaryItemName()));
        }
        properties.add(this.propertyFactory.create(JcrLexicon.NODE_TYPE_NAME, (Object)nodeType.getName()));
        properties.add(this.propertyFactory.create(JcrLexicon.HAS_ORDERABLE_CHILD_NODES, (Object)nodeType.hasOrderableChildNodes()));
        properties.add(this.propertyFactory.create(JcrLexicon.SUPERTYPES, supertypeNames));
        if (nodeTypeNode != null) {
            nodeTypeNode.setProperties(this.system, properties);
            for (JcrNodeType jcrNodeType : supertypes) {
                CachedNode superTypeNode = this.system.getNode(((JcrNodeType)jcrNodeType).key());
                if (!(superTypeNode instanceof MutableCachedNode) || !((MutableCachedNode)superTypeNode).isNew()) continue;
                nodeTypes.reorderChild(this.system, superTypeNode.getKey(), nodeTypeNode.getKey());
            }
        } else {
            nodeTypeNode = nodeTypes.createChild(this.system, key, name, properties);
        }
        for (JcrPropertyDefinition jcrPropertyDefinition : nodeType.getDeclaredPropertyDefinitions()) {
            this.store(nodeTypeNode, jcrPropertyDefinition);
            if (existingChildKeys == null) continue;
            existingChildKeys.remove(jcrPropertyDefinition.key());
        }
        for (JcrNodeDefinition jcrNodeDefinition : nodeType.getDeclaredChildNodeDefinitions()) {
            this.store(nodeTypeNode, jcrNodeDefinition);
            if (existingChildKeys == null) continue;
            existingChildKeys.remove(jcrNodeDefinition.key());
        }
        if (existingChildKeys != null && !existingChildKeys.isEmpty()) {
            for (NodeKey childKey : existingChildKeys) {
                nodeTypeNode.removeChild(this.system, childKey);
                this.system.destroy(childKey);
            }
        }
    }

    private void store(MutableCachedNode nodeTypeNode, JcrPropertyDefinition propertyDef) {
        Object[] valueConstraints;
        NodeKey key = propertyDef.key();
        Name name = propertyDef.getInternalName();
        MutableCachedNode propDefnNode = null;
        if (!nodeTypeNode.isNew() && nodeTypeNode.getChildReferences((NodeCache)this.system).hasChild(key)) {
            propDefnNode = this.system.mutable(key);
        }
        ArrayList<Property> properties = new ArrayList<Property>();
        properties.add(this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, (Object)JcrNtLexicon.PROPERTY_DEFINITION));
        if (!"*".equals(propertyDef.getName())) {
            properties.add(this.propertyFactory.create(JcrLexicon.NAME, (Object)name));
        }
        properties.add(this.propertyFactory.create(JcrLexicon.AUTO_CREATED, (Object)propertyDef.isAutoCreated()));
        properties.add(this.propertyFactory.create(JcrLexicon.MANDATORY, (Object)propertyDef.isMandatory()));
        properties.add(this.propertyFactory.create(JcrLexicon.MULTIPLE, (Object)propertyDef.isMultiple()));
        properties.add(this.propertyFactory.create(JcrLexicon.PROTECTED, (Object)propertyDef.isProtected()));
        properties.add(this.propertyFactory.create(JcrLexicon.ON_PARENT_VERSION, (Object)OnParentVersionAction.nameFromValue((int)propertyDef.getOnParentVersion())));
        properties.add(this.propertyFactory.create(JcrLexicon.REQUIRED_TYPE, (Object)PropertyType.nameFromValue((int)propertyDef.getRequiredType()).toUpperCase()));
        ArrayList<String> symbols = new ArrayList<String>();
        for (String value : propertyDef.getAvailableQueryOperators()) {
            if (value == null) continue;
            symbols.add(value);
        }
        properties.add(this.propertyFactory.create(JcrLexicon.AVAILABLE_QUERY_OPERATORS, symbols));
        JcrValue[] defaultValues = propertyDef.getDefaultValues();
        if (defaultValues != null && defaultValues.length > 0) {
            Object[] defaultsAsString = new String[defaultValues.length];
            for (int i = 0; i < defaultValues.length; ++i) {
                try {
                    defaultsAsString[i] = defaultValues[i].getString();
                    continue;
                }
                catch (RepositoryException re) {
                    throw new IllegalStateException(re);
                }
            }
            properties.add(this.propertyFactory.create(JcrLexicon.DEFAULT_VALUES, defaultsAsString));
        }
        if ((valueConstraints = propertyDef.getValueConstraints()).length > 0) {
            properties.add(this.propertyFactory.create(JcrLexicon.VALUE_CONSTRAINTS, valueConstraints));
        }
        if (propDefnNode != null) {
            propDefnNode.setProperties(this.system, properties);
        } else {
            propDefnNode = nodeTypeNode.createChild(this.system, key, name, properties);
        }
    }

    private void store(MutableCachedNode nodeTypeNode, JcrNodeDefinition childNodeDef) {
        NodeKey key = childNodeDef.key();
        Name name = childNodeDef.getInternalName();
        MutableCachedNode nodeDefnNode = null;
        if (!nodeTypeNode.isNew() && nodeTypeNode.getChildReferences((NodeCache)this.system).hasChild(key)) {
            nodeDefnNode = this.system.mutable(key);
        }
        ArrayList<Property> props = new ArrayList<Property>();
        props.add(this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, (Object)JcrNtLexicon.CHILD_NODE_DEFINITION));
        if (!"*".equals(childNodeDef.getName())) {
            props.add(this.propertyFactory.create(JcrLexicon.NAME, (Object)name));
        }
        if (childNodeDef.defaultPrimaryTypeName() != null) {
            props.add(this.propertyFactory.create(JcrLexicon.DEFAULT_PRIMARY_TYPE, (Object)childNodeDef.defaultPrimaryTypeName()));
        }
        props.add(this.propertyFactory.create(JcrLexicon.REQUIRED_PRIMARY_TYPES, (Object[])childNodeDef.requiredPrimaryTypeNames()));
        props.add(this.propertyFactory.create(JcrLexicon.SAME_NAME_SIBLINGS, (Object)childNodeDef.allowsSameNameSiblings()));
        props.add(this.propertyFactory.create(JcrLexicon.ON_PARENT_VERSION, (Object)OnParentVersionAction.nameFromValue((int)childNodeDef.getOnParentVersion())));
        props.add(this.propertyFactory.create(JcrLexicon.AUTO_CREATED, (Object)childNodeDef.isAutoCreated()));
        props.add(this.propertyFactory.create(JcrLexicon.MANDATORY, (Object)childNodeDef.isMandatory()));
        props.add(this.propertyFactory.create(JcrLexicon.PROTECTED, (Object)childNodeDef.isProtected()));
        if (nodeDefnNode != null) {
            nodeDefnNode.setProperties(this.system, props);
        } else {
            nodeDefnNode = nodeTypeNode.createChild(this.system, key, name, props);
        }
    }

    public IndexDefinition readIndexDefinition(CachedNode indexDefn, Name providerName) {
        String name = (String)this.strings.create(indexDefn.getName((NodeCache)this.system));
        String desc = (String)this.strings.create(this.first(indexDefn, JcrLexicon.DESCRIPTION));
        String providerNameStr = (String)this.strings.create(providerName);
        String kindStr = (String)this.strings.create(this.first(indexDefn, ModeShapeLexicon.KIND));
        String workspacesRule = (String)this.strings.create(this.first(indexDefn, ModeShapeLexicon.WORKSPACES));
        IndexDefinition.IndexKind kind = IndexDefinition.IndexKind.valueOf((String)kindStr);
        String nodeTypeName = (String)this.strings.create((Name)this.names.create(this.first(indexDefn, ModeShapeLexicon.NODE_TYPE_NAME)));
        HashMap<String, Object> extendedProps = new HashMap<String, Object>();
        Iterator props = indexDefn.getProperties((NodeCache)this.system);
        while (props.hasNext()) {
            Property prop = (Property)props.next();
            if (prop.isSingle()) {
                extendedProps.put((String)this.strings.create(prop.getName()), prop);
                continue;
            }
            if (!prop.isMultiple()) continue;
            extendedProps.put((String)this.strings.create(prop.getName()), prop);
        }
        extendedProps.remove(ModeShapeLexicon.KIND);
        extendedProps.remove(ModeShapeLexicon.WORKSPACES);
        extendedProps.remove(JcrLexicon.DESCRIPTION);
        LinkedList<IndexColumnDefinition> columnDefns = new LinkedList<IndexColumnDefinition>();
        for (ChildReference ref : indexDefn.getChildReferences((NodeCache)this.system)) {
            CachedNode indexColumnDefn = this.system.getNode(ref);
            IndexColumnDefinition defn = this.readIndexColumnDefinition(indexColumnDefn);
            columnDefns.add(defn);
        }
        IndexDefinition.WorkspaceMatchRule rule = RepositoryIndexDefinition.workspaceMatchRule(workspacesRule);
        return new RepositoryIndexDefinition(name, providerNameStr, kind, nodeTypeName, columnDefns, extendedProps, desc, true, rule);
    }

    public IndexColumnDefinition readIndexColumnDefinition(CachedNode indexColumnDefn) {
        String propertyName = (String)this.strings.create((Name)this.names.create(this.first(indexColumnDefn, ModeShapeLexicon.PROPERTY_NAME)));
        String columnTypeName = (String)this.strings.create(this.first(indexColumnDefn, ModeShapeLexicon.COLUMN_TYPE_NAME));
        org.modeshape.jcr.value.PropertyType columnType = org.modeshape.jcr.value.PropertyType.valueFor((String)columnTypeName);
        return new RepositoryIndexColumnDefinition(propertyName, columnType.jcrType());
    }

    public List<IndexDefinition> readAllIndexDefinitions(Set<String> providerNames) {
        CachedNode indexes = this.indexesNode();
        ArrayList<IndexDefinition> defns = new ArrayList<IndexDefinition>();
        for (ChildReference ref : indexes.getChildReferences((NodeCache)this.system)) {
            CachedNode provider = this.system.getNode(ref);
            Name providerName = provider.getName((NodeCache)this.system);
            for (ChildReference indexRef : provider.getChildReferences((NodeCache)this.system)) {
                CachedNode indexDefn = this.system.getNode(indexRef);
                IndexDefinition defn = this.readIndexDefinition(indexDefn, providerName);
                if (providerNames.contains(defn.getProviderName())) continue;
                defn = RepositoryIndexDefinition.createFrom(defn, false);
            }
        }
        return defns;
    }

    private final NodeKey nodeKey(NodeKey prototype, IndexDefinition defn) {
        return prototype.withId("/jcr:system/mode:indexes/" + defn.getProviderName() + "/" + defn.getName());
    }

    private final NodeKey nodeKey(NodeKey indexDefnKey, IndexColumnDefinition defn) {
        String id = (String)this.strings.create((String)this.strings.create(defn.getPropertyName()));
        return indexDefnKey.withId(indexDefnKey.getIdentifier() + id);
    }

    private final NodeKey nodeKey(NodeKey prototype, String providerName) {
        return prototype.withId("/jcr:system/mode:indexes/" + providerName);
    }

    public void remove(IndexDefinition indexDefn) {
        assert (indexDefn != null);
        assert (this.system != null);
        MutableCachedNode indexes = this.mutableIndexesNode();
        NodeKey providerKey = this.nodeKey(indexes.getKey(), indexDefn.getProviderName());
        if (indexes.getChildReferences((NodeCache)this.system).hasChild(providerKey)) {
            MutableCachedNode providerNode = this.system.mutable(providerKey);
            NodeKey key = this.nodeKey(providerNode.getKey(), indexDefn);
            providerNode.removeChild(this.system, key);
            this.system.destroy(key);
            if (providerNode.getChildReferences((NodeCache)this.system).isEmpty()) {
                indexes.removeChild(this.system, providerKey);
                this.system.destroy(providerKey);
            }
        }
    }

    public void store(IndexDefinition indexDefn, boolean updateExisting) {
        MutableCachedNode indexesNode = this.mutableIndexesNode();
        this.store(indexDefn, indexesNode, updateExisting);
    }

    private void store(IndexDefinition indexDefn, MutableCachedNode indexes, boolean updateExisting) {
        assert (indexDefn != null);
        assert (this.system != null);
        assert (indexes != null);
        assert (indexDefn.getName() != null);
        MutableCachedNode providerNode = null;
        NodeKey providerKey = this.nodeKey(indexes.getKey(), indexDefn.getProviderName());
        if (indexes.getChildReferences((NodeCache)this.system).hasChild(providerKey)) {
            providerNode = this.system.mutable(providerKey);
        } else {
            Property primaryType = this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, (Object)ModeShapeLexicon.INDEX_PROVIDER);
            Name providerName = (Name)this.names.create(indexDefn.getProviderName());
            providerNode = indexes.createChild(this.system, providerKey, providerName, primaryType, new Property[0]);
        }
        assert (providerNode != null);
        Name name = (Name)this.names.create(indexDefn.getName());
        NodeKey key = this.nodeKey(indexes.getKey(), indexDefn);
        MutableCachedNode indexNode = null;
        HashSet<NodeKey> existingChildKeys = null;
        if (providerNode.getChildReferences((NodeCache)this.system).hasChild(key)) {
            if (!updateExisting) {
                return;
            }
            indexNode = this.system.mutable(key);
            existingChildKeys = new HashSet<NodeKey>();
            for (ChildReference childRef : indexNode.getChildReferences((NodeCache)this.system)) {
                existingChildKeys.add(childRef.getKey());
            }
        }
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Map.Entry entry : indexDefn.getIndexProperties().entrySet()) {
            Property prop = this.createProperty((String)entry.getKey(), entry.getValue());
            if (prop == null) continue;
            properties.add(prop);
        }
        properties.add(this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, (Object)ModeShapeLexicon.INDEX));
        properties.add(this.propertyFactory.create(JcrLexicon.DESCRIPTION, (Object)indexDefn.getDescription()));
        properties.add(this.propertyFactory.create(ModeShapeLexicon.KIND, (Object)indexDefn.getKind().name()));
        properties.add(this.propertyFactory.create(ModeShapeLexicon.NODE_TYPE_NAME, (Object)indexDefn.getNodeTypeName()));
        if (indexNode != null) {
            indexNode.setProperties(this.system, properties);
        } else {
            indexNode = providerNode.createChild(this.system, key, name, properties);
        }
        for (IndexColumnDefinition columnDefn : indexDefn) {
            NodeKey columnDefnKey = this.store(indexNode, columnDefn);
            if (existingChildKeys == null) continue;
            existingChildKeys.remove(columnDefnKey);
        }
        if (existingChildKeys != null && !existingChildKeys.isEmpty()) {
            for (NodeKey childKey : existingChildKeys) {
                indexNode.removeChild(this.system, childKey);
                this.system.destroy(childKey);
            }
        }
    }

    private Property createProperty(String name, Object valueOrValues) {
        Name propName = (Name)this.names.create(name);
        Property prop = null;
        if (valueOrValues instanceof Object[]) {
            Object[] values = (Object[])valueOrValues;
            org.modeshape.jcr.value.PropertyType type = this.propertyTypeOf(values);
            prop = this.propertyFactory.create(propName, type, values);
        } else if (valueOrValues == null) {
            prop = this.propertyFactory.create(propName, new Object[0]);
        } else {
            org.modeshape.jcr.value.PropertyType type = org.modeshape.jcr.value.PropertyType.discoverType((Object)valueOrValues);
            prop = this.propertyFactory.create(propName, type, valueOrValues);
        }
        return prop;
    }

    private org.modeshape.jcr.value.PropertyType propertyTypeOf(Object[] values) {
        if (values != null) {
            for (Object value : values) {
                org.modeshape.jcr.value.PropertyType type;
                if (value == null || (type = org.modeshape.jcr.value.PropertyType.discoverType((Object)value)) == org.modeshape.jcr.value.PropertyType.OBJECT) continue;
                return type;
            }
        }
        return org.modeshape.jcr.value.PropertyType.OBJECT;
    }

    private NodeKey store(MutableCachedNode indexDefn, IndexColumnDefinition columnDefn) {
        NodeKey key = this.nodeKey(indexDefn.getKey(), columnDefn);
        Name name = ModeShapeLexicon.INDEX_COLUMN;
        MutableCachedNode columnDefnNode = null;
        if (!indexDefn.isNew() && indexDefn.getChildReferences((NodeCache)this.system).hasChild(key)) {
            columnDefnNode = this.system.mutable(key);
        }
        String propTypeName = PropertyType.nameFromValue((int)columnDefn.getColumnType());
        ArrayList<Property> props = new ArrayList<Property>();
        props.add(this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, (Object)ModeShapeLexicon.INDEX_COLUMN));
        props.add(this.propertyFactory.create(ModeShapeLexicon.PROPERTY_NAME, (Object)columnDefn.getPropertyName()));
        props.add(this.propertyFactory.create(ModeShapeLexicon.COLUMN_TYPE_NAME, (Object)propTypeName));
        if (columnDefnNode != null) {
            columnDefnNode.setProperties(this.system, props);
        } else {
            columnDefnNode = indexDefn.createChild(this.system, key, name, props);
        }
        return key;
    }

    public List<NodeTypeDefinition> readNodeTypes(Set<Name> nodeTypesToRefresh) {
        return this.readAllNodeTypes();
    }

    public List<NodeTypeDefinition> readAllNodeTypes() {
        CachedNode nodeTypes = this.nodeTypesNode();
        ArrayList<NodeTypeDefinition> defns = new ArrayList<NodeTypeDefinition>();
        for (ChildReference ref : nodeTypes.getChildReferences((NodeCache)this.system)) {
            CachedNode nodeType = this.system.getNode(ref);
            defns.add(this.readNodeTypeDefinition(nodeType));
        }
        return defns;
    }

    public NodeTypeDefinition readNodeTypeDefinition(CachedNode nodeType) {
        try {
            JcrNodeTypeTemplate defn = new JcrNodeTypeTemplate(this.context());
            defn.setMixin((Boolean)this.booleans.create(this.first(nodeType, JcrLexicon.IS_MIXIN)));
            defn.setAbstract((Boolean)this.booleans.create(this.first(nodeType, JcrLexicon.IS_ABSTRACT)));
            defn.setQueryable((Boolean)this.booleans.create(this.first(nodeType, JcrLexicon.IS_QUERYABLE)));
            defn.setOrderableChildNodes((Boolean)this.booleans.create(this.first(nodeType, JcrLexicon.HAS_ORDERABLE_CHILD_NODES)));
            defn.setName((String)this.strings.create(this.first(nodeType, JcrLexicon.NODE_TYPE_NAME)));
            defn.setPrimaryItemName((String)this.strings.create(this.first(nodeType, JcrLexicon.PRIMARY_ITEM_NAME)));
            Property supertypes = nodeType.getProperty(JcrLexicon.SUPERTYPES, (NodeCache)this.system);
            if (supertypes != null && !supertypes.isEmpty()) {
                String[] supertypeNames = new String[supertypes.size()];
                int i = 0;
                for (Object name : supertypes) {
                    supertypeNames[i++] = (String)this.strings.create(name);
                }
                defn.setDeclaredSuperTypeNames(supertypeNames);
            }
            for (ChildReference ref : nodeType.getChildReferences((NodeCache)this.system)) {
                CachedNode itemDefn = this.system.getNode(ref);
                Name primaryType = (Name)this.names.create(this.first(itemDefn, JcrLexicon.PRIMARY_TYPE));
                if (JcrNtLexicon.PROPERTY_DEFINITION.equals(primaryType)) {
                    PropertyDefinition propDefn = this.readPropertyDefinition(itemDefn);
                    assert (propDefn != null);
                    defn.getPropertyDefinitionTemplates().add(propDefn);
                    continue;
                }
                if (!JcrNtLexicon.CHILD_NODE_DEFINITION.equals(primaryType)) continue;
                NodeDefinition childDefn = this.readChildNodeDefinition(itemDefn);
                assert (childDefn != null);
                defn.getNodeDefinitionTemplates().add(childDefn);
            }
            return defn;
        }
        catch (ConstraintViolationException e) {
            throw new SystemFailureException((Throwable)e);
        }
    }

    protected PropertyDefinition readPropertyDefinition(CachedNode propDefn) throws ConstraintViolationException {
        Property constraints;
        Property defaultValues;
        JcrPropertyDefinitionTemplate defn = new JcrPropertyDefinitionTemplate(this.context());
        defn.setName((String)this.strings.create(this.first(propDefn, JcrLexicon.NAME, "*")));
        defn.setAutoCreated((Boolean)this.booleans.create(this.first(propDefn, JcrLexicon.AUTO_CREATED)));
        defn.setMandatory((Boolean)this.booleans.create(this.first(propDefn, JcrLexicon.MANDATORY)));
        defn.setMultiple((Boolean)this.booleans.create(this.first(propDefn, JcrLexicon.MULTIPLE)));
        defn.setProtected((Boolean)this.booleans.create(this.first(propDefn, JcrLexicon.PROTECTED)));
        defn.setOnParentVersion(OnParentVersionAction.valueFromName((String)((String)this.strings.create(this.first(propDefn, JcrLexicon.ON_PARENT_VERSION)))));
        defn.setRequiredType(this.propertyType(this.first(propDefn, JcrLexicon.REQUIRED_TYPE)));
        Property queryOps = propDefn.getProperty(JcrLexicon.AVAILABLE_QUERY_OPERATORS, (NodeCache)this.system);
        if (queryOps != null && !queryOps.isEmpty()) {
            String[] queryOperators = new String[queryOps.size()];
            int i = 0;
            for (Object op : queryOps) {
                queryOperators[i++] = (String)this.strings.create(op);
            }
            defn.setAvailableQueryOperators(queryOperators);
        }
        if ((defaultValues = propDefn.getProperty(JcrLexicon.DEFAULT_VALUES, (NodeCache)this.system)) != null && !defaultValues.isEmpty()) {
            Value[] values = new Value[defaultValues.size()];
            int i = 0;
            for (Object value : defaultValues) {
                org.modeshape.jcr.value.PropertyType modeType = org.modeshape.jcr.value.PropertyType.discoverType(value);
                int jcrType = PropertyTypeUtil.jcrPropertyTypeFor((org.modeshape.jcr.value.PropertyType)modeType);
                String strValue = (String)this.strings.create(value);
                try {
                    values[i++] = this.jcrValues.createValue(strValue, jcrType);
                }
                catch (ValueFormatException err) {
                    values[i++] = this.jcrValues.createValue(strValue);
                }
                ++i;
            }
            defn.setDefaultValues(values);
        }
        if ((constraints = propDefn.getProperty(JcrLexicon.VALUE_CONSTRAINTS, (NodeCache)this.system)) != null && !constraints.isEmpty()) {
            String[] values = new String[constraints.size()];
            int i = 0;
            for (Object value : constraints) {
                values[i++] = (String)this.strings.create(value);
            }
            defn.setValueConstraints(values);
        }
        return defn;
    }

    protected NodeDefinition readChildNodeDefinition(CachedNode childDefn) throws ConstraintViolationException {
        Property requiredPrimaryTypes;
        JcrNodeDefinitionTemplate defn = new JcrNodeDefinitionTemplate(this.context());
        defn.setName((String)this.strings.create(this.first(childDefn, JcrLexicon.NAME, "*")));
        defn.setAutoCreated((Boolean)this.booleans.create(this.first(childDefn, JcrLexicon.AUTO_CREATED)));
        defn.setMandatory((Boolean)this.booleans.create(this.first(childDefn, JcrLexicon.MANDATORY)));
        defn.setSameNameSiblings((Boolean)this.booleans.create(this.first(childDefn, JcrLexicon.SAME_NAME_SIBLINGS)));
        defn.setProtected((Boolean)this.booleans.create(this.first(childDefn, JcrLexicon.PROTECTED)));
        defn.setOnParentVersion(OnParentVersionAction.valueFromName((String)((String)this.strings.create(this.first(childDefn, JcrLexicon.ON_PARENT_VERSION)))));
        String defaultPrimaryType = (String)this.strings.create(this.first(childDefn, JcrLexicon.DEFAULT_PRIMARY_TYPE));
        if (defaultPrimaryType != null) {
            defn.setDefaultPrimaryTypeName(defaultPrimaryType);
        }
        if ((requiredPrimaryTypes = childDefn.getProperty(JcrLexicon.REQUIRED_PRIMARY_TYPES, (NodeCache)this.system)) != null && !requiredPrimaryTypes.isEmpty()) {
            String[] values = new String[requiredPrimaryTypes.size()];
            int i = 0;
            for (Object op : requiredPrimaryTypes) {
                values[i++] = (String)this.strings.create(op);
            }
            defn.setRequiredPrimaryTypeNames(values);
        }
        return defn;
    }

    protected final int propertyType(Object value) {
        org.modeshape.jcr.value.PropertyType type = org.modeshape.jcr.value.PropertyType.valueFor((String)((String)this.strings.create(value)).toLowerCase());
        return PropertyTypeUtil.jcrPropertyTypeFor((org.modeshape.jcr.value.PropertyType)type);
    }

    protected final Iterable<?> all(CachedNode node, Name propertyName) {
        return node.getProperty(propertyName, (NodeCache)this.system);
    }

    protected final Object first(CachedNode node, Name propertyName) {
        return this.first(node, propertyName, null);
    }

    protected final Object first(CachedNode node, Name propertyName, Object defaultValue) {
        Property property = node.getProperty(propertyName, (NodeCache)this.system);
        return property != null ? property.getFirstValue() : defaultValue;
    }

    public Collection<NamespaceRegistry.Namespace> readAllNamespaces() {
        CachedNode namespaces = this.namespacesNode();
        ArrayList<NamespaceRegistry.Namespace> results = new ArrayList<NamespaceRegistry.Namespace>();
        results.add((NamespaceRegistry.Namespace)new BasicNamespace("", ""));
        for (ChildReference ref : namespaces.getChildReferences((NodeCache)this.system)) {
            CachedNode namespace = this.system.getNode(ref);
            String prefix = this.prefixFor(ref.getSegment());
            String uri = (String)this.strings.create(this.first(namespace, ModeShapeLexicon.URI));
            results.add((NamespaceRegistry.Namespace)new BasicNamespace(prefix, uri));
        }
        return results;
    }

    private String prefixFor(Path.Segment segment) {
        Name name = segment.getName();
        if (ModeShapeLexicon.NAMESPACE.equals(name)) {
            return "";
        }
        String localName = name.getLocalName();
        int index = segment.getIndex();
        return this.prefixFor(localName, index);
    }

    private String prefixFor(String name, int counter) {
        if (counter == 1 && !GENERATED_PREFIX.equals(name)) {
            return name;
        }
        if (counter < 10) {
            return name + "00" + counter;
        }
        if (counter < 100) {
            return name + "0" + counter;
        }
        assert (counter < 1000);
        return name + counter;
    }

    private Name nameForPrefix(String prefix) {
        if (prefix.length() == 0) {
            return ModeShapeLexicon.NAMESPACE;
        }
        Matcher matcher = GENERATED_PREFIX_PATTERN.matcher(prefix);
        if (matcher.matches()) {
            prefix = GENERATED_PREFIX;
        }
        return (Name)this.names.create(prefix);
    }

    public Set<String> registerNamespaces(Map<String, String> newUrisByPrefix) {
        HashSet<String> removedPrefixes = new HashSet<String>();
        MutableCachedNode namespaces = this.mutableNamespacesNode();
        ChildReferences childRefs = namespaces.getChildReferences((NodeCache)this.system);
        for (Map.Entry<String, String> newNamespaceEntry : newUrisByPrefix.entrySet()) {
            String newPrefix = newNamespaceEntry.getKey().trim();
            String newUri = newNamespaceEntry.getValue().trim();
            Name newPrefixName = this.nameForPrefix(newPrefix);
            ChildReference ref = childRefs.getChild(newPrefixName);
            if (ref != null) {
                CachedNode existingNode = this.system.getNode(ref);
                String existingUri = (String)this.strings.create(existingNode.getProperty(ModeShapeLexicon.URI, (NodeCache)this.system).getFirstValue());
                if (newUri.equals(existingUri)) continue;
                namespaces.removeChild(this.system, ref.getKey());
                this.system.destroy(ref.getKey());
                continue;
            }
            NodeKey key = this.keyForNamespaceUri(newUri);
            CachedNode existingNode = this.system.getNode(key);
            if (existingNode != null) {
                Path.Segment segment = existingNode.getSegment((NodeCache)this.system);
                String existingPrefix = this.prefixFor(segment);
                if (!GENERATED_NAMESPACE_NODE_NAME.equals(segment.getName()) && existingPrefix.equals(newPrefix)) continue;
                namespaces.renameChild(this.system, key, (Name)this.names.create(newPrefix));
                removedPrefixes.add(existingPrefix);
                continue;
            }
            if (newUri.length() <= 0) continue;
            Name name = (Name)this.names.create(newPrefix);
            ArrayList<Property> props = new ArrayList<Property>(3);
            props.add(this.propertyFactory.create(ModeShapeLexicon.URI, (Object)newUri));
            props.add(this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, (Object)ModeShapeLexicon.NAMESPACE));
            props.add(this.propertyFactory.create(ModeShapeLexicon.GENERATED, this.booleans.create(false)));
            namespaces.createChild(this.system, key, name, props);
        }
        return removedPrefixes;
    }

    public String readNamespacePrefix(String namespaceUri, boolean generateIfMissing) {
        NodeKey key = this.keyForNamespaceUri(namespaceUri);
        CachedNode nsNode = this.system.getNode(key);
        if (nsNode != null) {
            Path.Segment segment = nsNode.getSegment((NodeCache)this.system);
            return this.prefixFor(segment);
        }
        if (!generateIfMissing) {
            return null;
        }
        MutableCachedNode mutableNamespaces = this.mutableNamespacesNode();
        ArrayList<Property> props = new ArrayList<Property>(3);
        props.add(this.propertyFactory.create(ModeShapeLexicon.URI, (Object)namespaceUri));
        props.add(this.propertyFactory.create(ModeShapeLexicon.GENERATED, this.booleans.create(true)));
        props.add(this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, (Object)ModeShapeLexicon.NAMESPACE));
        MutableCachedNode newNsNode = mutableNamespaces.createChild(this.system, key, GENERATED_NAMESPACE_NODE_NAME, props);
        return this.prefixFor(newNsNode.getSegment((NodeCache)this.system));
    }

    protected boolean unregisterNamespace(String namespaceUri) {
        MutableCachedNode namespaces = this.mutableNamespacesNode();
        NodeKey key = this.keyForNamespaceUri(namespaceUri);
        CachedNode nsNode = this.system.getNode(key);
        if (nsNode != null) {
            namespaces.removeChild(this.system, key);
            this.system.destroy(key);
            return true;
        }
        return false;
    }

    protected void unregisterNodeTypes(JcrNodeType ... nodeTypes) {
        MutableCachedNode nodeTypesNode = this.mutableNodeTypesNode();
        for (JcrNodeType nodeType : nodeTypes) {
            NodeKey nodeTypeKey = nodeType.key();
            nodeTypesNode.removeChild(this.system, nodeTypeKey);
            this.system.destroy(nodeTypeKey);
        }
    }

    protected final NodeKey keyForNamespaceUri(String namespaceUri) {
        return this.namespacesKey().withId("mode:namespaces-" + namespaceUri);
    }

    void storeLock(RepositoryLockManager.ModeShapeLock lock) {
        MutableCachedNode locksNode = this.mutableLocksNode();
        Name name = (Name)this.names.create(lock.getLockToken());
        ArrayList<Property> properties = new ArrayList<Property>();
        properties.add(this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, (Object)ModeShapeLexicon.LOCK));
        properties.add(this.propertyFactory.create(JcrLexicon.LOCK_OWNER, (Object)lock.getLockOwner()));
        properties.add(this.propertyFactory.create(JcrLexicon.LOCK_IS_DEEP, (Object)lock.isDeep()));
        properties.add(this.propertyFactory.create(ModeShapeLexicon.WORKSPACE, (Object)lock.getWorkspaceName()));
        properties.add(this.propertyFactory.create(ModeShapeLexicon.LOCK_TOKEN, (Object)lock.getLockToken()));
        properties.add(this.propertyFactory.create(ModeShapeLexicon.IS_SESSION_SCOPED, (Object)lock.isSessionScoped()));
        properties.add(this.propertyFactory.create(ModeShapeLexicon.IS_HELD_BY_SESSION, (Object)true));
        properties.add(this.propertyFactory.create(ModeShapeLexicon.LOCKING_SESSION, (Object)lock.getLockingSessionId()));
        properties.add(this.propertyFactory.create(ModeShapeLexicon.EXPIRATION_DATE, (Object)lock.getExpiryTime()));
        locksNode.createChild(this.system, lock.getLockKey(), name, properties);
    }

    void removeLock(RepositoryLockManager.ModeShapeLock lock) {
        MutableCachedNode locksNode = this.mutableLocksNode();
        NodeKey lockKey = lock.getLockKey();
        locksNode.removeChild(this.system, lockKey);
        this.system.destroy(lockKey);
    }

    boolean changeLockHeldBySession(String lockToken, boolean value) throws LockException {
        Name name;
        CachedNode locksNode = this.locksNode();
        ChildReferences childRefs = locksNode.getChildReferences((NodeCache)this.system);
        ChildReference ref = childRefs.getChild(name = (Name)this.names.create(lockToken));
        if (ref == null) {
            throw new LockException(JcrI18n.invalidLockToken.text(new Object[]{lockToken}));
        }
        MutableCachedNode lockNode = this.system.mutable(ref.getKey());
        boolean isHeld = (Boolean)this.booleans.create(this.first((CachedNode)lockNode, ModeShapeLexicon.IS_HELD_BY_SESSION, false));
        if (isHeld && value) {
            return false;
        }
        lockNode.setProperty(this.system, this.propertyFactory.create(ModeShapeLexicon.IS_HELD_BY_SESSION, (Object)value));
        return true;
    }

    public NodeKey versionHistoryNodeKeyFor(NodeKey versionableNodeKey) {
        return this.systemKey().withId(versionableNodeKey.getIdentifier());
    }

    public boolean hasVersionHistory(NodeKey versionableNodeKey) {
        return this.cache().getNode(this.versionHistoryNodeKeyFor(versionableNodeKey)) != null;
    }

    protected MutableCachedNode initializeVersionStorage(NodeKey versionableNodeKey, NodeKey versionHistoryKey, NodeKey versionKey, Name primaryTypeName, Set<Name> mixinTypeNames, Path versionHistoryPath, NodeKey originalVersionKey, DateTime now) {
        assert (versionHistoryPath != null);
        assert (versionHistoryPath.size() == 6);
        CachedNode node = this.versionStorageNode();
        MutableCachedNode mutable = null;
        Path parentPathInStorage = versionHistoryPath.getParent().subpath(2);
        Property primaryType = null;
        for (Path.Segment segment : parentPathInStorage) {
            ChildReferences childRefs = node.getChildReferences((NodeCache)this.system);
            ChildReference ref = childRefs.getChild(segment);
            if (ref != null) {
                node = this.system.getNode(ref);
                continue;
            }
            MutableCachedNode mutableNode = this.system.mutable(node.getKey());
            NodeKey key = this.systemKey().withRandomId();
            if (primaryType == null) {
                primaryType = this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, (Object)ModeShapeLexicon.VERSION_HISTORY_FOLDER);
            }
            mutable = mutableNode.createChild(this.system, key, segment.getName(), primaryType, new Property[0]);
            node = mutable;
        }
        MutableCachedNode historyParent = mutable != null ? mutable : this.system.mutable(node.getKey());
        ArrayList<Property> historyProps = new ArrayList<Property>();
        historyProps.add(this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, (Object)JcrNtLexicon.VERSION_HISTORY));
        historyProps.add(this.propertyFactory.create(JcrLexicon.VERSIONABLE_UUID, (Object)versionableNodeKey.getIdentifier()));
        historyProps.add(this.propertyFactory.create(JcrLexicon.UUID, (Object)versionHistoryKey.getIdentifier()));
        if (originalVersionKey != null) {
            historyProps.add(this.propertyFactory.create(JcrLexicon.COPIED_FROM, org.modeshape.jcr.value.PropertyType.WEAKREFERENCE, (Object)this.referenceFactory.create(originalVersionKey, true)));
        }
        Name historyName = versionHistoryPath.getLastSegment().getName();
        MutableCachedNode history = historyParent.createChild(this.system, versionHistoryKey, historyName, historyProps);
        Property labelProp = this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, (Object)JcrNtLexicon.VERSION_LABELS);
        MutableCachedNode labels = history.createChild(this.system, null, JcrLexicon.VERSION_LABELS, labelProp, new Property[0]);
        assert (labels != null);
        NodeKey rootVersionKey = versionKey != null ? versionKey : this.systemKey().withRandomId();
        ArrayList<Property> rootProps = new ArrayList<Property>();
        rootProps.add(this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, (Object)JcrNtLexicon.VERSION));
        rootProps.add(this.propertyFactory.create(JcrLexicon.CREATED, (Object)now));
        rootProps.add(this.propertyFactory.create(JcrLexicon.UUID, (Object)rootVersionKey.getIdentifier()));
        MutableCachedNode rootVersion = history.createChild(this.system, rootVersionKey, JcrLexicon.ROOT_VERSION, rootProps);
        NodeKey frozenNodeKey = rootVersion.getKey().withRandomId();
        ArrayList<Property> frozenProps = new ArrayList<Property>();
        frozenProps.add(this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, (Object)JcrNtLexicon.FROZEN_NODE));
        frozenProps.add(this.propertyFactory.create(JcrLexicon.FROZEN_UUID, (Object)versionableNodeKey.getIdentifier()));
        frozenProps.add(this.propertyFactory.create(JcrLexicon.FROZEN_PRIMARY_TYPE, (Object)primaryTypeName));
        frozenProps.add(this.propertyFactory.create(JcrLexicon.UUID, (Object)frozenNodeKey));
        if (mixinTypeNames != null && !mixinTypeNames.isEmpty()) {
            frozenProps.add(this.propertyFactory.create(JcrLexicon.FROZEN_MIXIN_TYPES, mixinTypeNames));
        }
        MutableCachedNode frozenNode = rootVersion.createChild(this.system, frozenNodeKey, JcrLexicon.FROZEN_NODE, frozenProps);
        assert (frozenNode != null);
        return history;
    }

    public MutableCachedNode recordNewVersion(CachedNode versionableNode, SessionCache cacheForVersionableNode, Path versionHistoryPath, NodeKey originalVersionKey, Collection<Property> versionableProperties, DateTime now, AtomicReference<MutableCachedNode> frozenNodeOutput) {
        assert (versionHistoryPath != null);
        assert (versionHistoryPath.size() == 6);
        NodeKey versionableNodeKey = versionableNode.getKey();
        Name primaryTypeName = versionableNode.getPrimaryType((NodeCache)cacheForVersionableNode);
        Set mixinTypeNames = versionableNode.getMixinTypes((NodeCache)cacheForVersionableNode);
        NodeKey versionHistoryKey = this.versionHistoryNodeKeyFor(versionableNodeKey);
        Name versionName = null;
        MutableCachedNode historyNode = this.system.mutable(versionHistoryKey);
        Property predecessors = null;
        NodeKey versionKey = versionHistoryKey.withRandomId();
        if (historyNode == null) {
            historyNode = this.initializeVersionStorage(versionableNodeKey, versionHistoryKey, null, primaryTypeName, mixinTypeNames, versionHistoryPath, originalVersionKey, now);
            NodeKey rootVersionKey = historyNode.getChildReferences((NodeCache)this.system).getChild(JcrLexicon.ROOT_VERSION).getKey();
            Reference rootVersionRef = this.referenceFactory.create(rootVersionKey, true);
            predecessors = this.propertyFactory.create(JcrLexicon.PREDECESSORS, new Object[]{rootVersionRef});
            versionName = (Name)this.names.create("1.0");
        } else {
            ChildReferences historyChildren = historyNode.getChildReferences((NodeCache)this.system);
            predecessors = versionableNode.getProperty(JcrLexicon.PREDECESSORS, (NodeCache)cacheForVersionableNode);
            versionName = this.nextNameForVersionNode(predecessors, historyChildren);
        }
        ArrayList<Property> props = new ArrayList<Property>();
        props.add(this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, (Object)JcrNtLexicon.VERSION));
        props.add(predecessors);
        props.add(this.propertyFactory.create(JcrLexicon.CREATED, (Object)now));
        props.add(this.propertyFactory.create(JcrLexicon.UUID, (Object)versionKey.getIdentifier()));
        MutableCachedNode versionNode = historyNode.createChild(this.system, versionKey, versionName, props);
        NodeKey frozenNodeKey = this.systemKey().withRandomId();
        props = new ArrayList();
        props.add(this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, (Object)JcrNtLexicon.FROZEN_NODE));
        props.add(this.propertyFactory.create(JcrLexicon.FROZEN_UUID, (Object)versionableNodeKey.getIdentifier()));
        props.add(this.propertyFactory.create(JcrLexicon.FROZEN_PRIMARY_TYPE, (Object)primaryTypeName));
        props.add(this.propertyFactory.create(JcrLexicon.FROZEN_MIXIN_TYPES, (Iterable)mixinTypeNames));
        props.add(this.propertyFactory.create(JcrLexicon.UUID, (Object)frozenNodeKey));
        if (versionableProperties != null) {
            props.addAll(versionableProperties);
        }
        MutableCachedNode frozenNode = versionNode.createChild(this.system, frozenNodeKey, JcrLexicon.FROZEN_NODE, props);
        assert (frozenNode != null);
        frozenNodeOutput.set(frozenNode);
        Property successors = null;
        HashSet<Reference> successorReferences = new HashSet<Reference>();
        for (Object value : predecessors) {
            NodeKey predecessorKey = ((NodeKeyReference)value).getNodeKey();
            CachedNode predecessor = this.system.getNode(predecessorKey);
            successors = predecessor.getProperty(JcrLexicon.SUCCESSORS, (NodeCache)this.system);
            if (successors != null) {
                successorReferences.clear();
                for (Object successorValue : successors) {
                    NodeKey successorKey = ((NodeKeyReference)successorValue).getNodeKey();
                    successorReferences.add(this.referenceFactory.create(successorKey, true));
                }
            }
            successorReferences.add(this.referenceFactory.create(versionKey, true));
            successors = this.propertyFactory.create(JcrLexicon.SUCCESSORS, org.modeshape.jcr.value.PropertyType.REFERENCE, successorReferences);
            this.system.mutable(predecessorKey).setProperty(this.system, successors);
        }
        return versionNode;
    }

    protected Name nextNameForVersionNode(Property predecessors, ChildReferences historyChildren) {
        String proposedName = null;
        CachedNode versionNode = null;
        if (predecessors != null) {
            for (Object predecessor : predecessors) {
                if (predecessor == null) continue;
                NodeKey key = ((NodeKeyReference)predecessor).getNodeKey();
                CachedNode predecessorNode = this.system.getNode(key);
                Name predecessorName = predecessorNode.getName((NodeCache)this.system);
                if (proposedName != null && predecessorName.getLocalName().length() >= proposedName.length()) continue;
                proposedName = predecessorName.getLocalName();
                versionNode = predecessorNode;
            }
        }
        if (proposedName == null) {
            proposedName = "1.0";
            Name versionName = (Name)this.names.create(proposedName);
            if (historyChildren.getChild(versionName) == null) {
                return versionName;
            }
            versionNode = this.system.getNode(historyChildren.getChild(JcrLexicon.ROOT_VERSION));
        }
        assert (versionNode != null);
        int index = proposedName.lastIndexOf(46);
        if (index > 0) {
            proposedName = proposedName.substring(0, index + 1) + (Integer.parseInt(proposedName.substring(index + 1)) + 1);
            Name versionName = (Name)this.names.create(proposedName);
            while (historyChildren.getChild(versionName) != null) {
                proposedName = proposedName + ".0";
                versionName = (Name)this.names.create(proposedName);
            }
            return versionName;
        }
        Property successors = versionNode.getProperty(JcrLexicon.SUCCESSORS, (NodeCache)this.system);
        String baseName = successors != null ? Integer.toString(successors.size() + 1) : "1";
        return (Name)this.names.create(baseName + ".0");
    }
}

