/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.kernel.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import org.fcrepo.integration.kernel.impl.AbstractIT;
import org.fcrepo.kernel.FedoraObject;
import org.fcrepo.kernel.FedoraResource;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.exception.InvalidChecksumException;
import org.fcrepo.kernel.impl.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.services.DatastreamService;
import org.fcrepo.kernel.services.NodeService;
import org.fcrepo.kernel.services.ObjectService;
import org.fcrepo.kernel.utils.iterators.PropertyIterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"/spring-test/repo.xml"})
public class FedoraResourceImplIT
extends AbstractIT {
    @Inject
    Repository repo;
    @Inject
    NodeService nodeService;
    @Inject
    ObjectService objectService;
    @Inject
    DatastreamService datastreamService;
    private Session session;
    private DefaultIdentifierTranslator subjects;

    @Before
    public void setUp() throws RepositoryException {
        this.session = this.repo.login();
        this.subjects = new DefaultIdentifierTranslator();
    }

    @After
    public void tearDown() {
        this.session.logout();
    }

    @Test
    public void testGetRootNode() throws RepositoryException {
        Session session = this.repo.login();
        FedoraResource object = this.nodeService.getObject(session, "/");
        Assert.assertEquals((Object)"/", (Object)object.getPath());
        session.logout();
    }

    private Node createGraphSubjectNode(String absPath) throws RepositoryException {
        return this.subjects.getSubject(absPath).asNode();
    }

    @Test
    public void testRandomNodeGraph() throws RepositoryException {
        FedoraResource object = this.nodeService.findOrCreateObject(this.session, "/testNodeGraph");
        this.logger.debug(object.getPropertiesDataset((IdentifierTranslator)new DefaultIdentifierTranslator()).toString());
        Node s = this.createGraphSubjectNode("/testNodeGraph");
        Node p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#primaryType");
        Node o = NodeFactory.createLiteral((String)"nt:unstructured");
        Assert.assertTrue((boolean)object.getPropertiesDataset((IdentifierTranslator)this.subjects).asDatasetGraph().contains(Node.ANY, s, p, o));
    }

    @Test
    public void testLastModified() throws RepositoryException {
        String pid = UUID.randomUUID().toString();
        FedoraObject obj1 = this.objectService.createObject(this.session, "/" + pid);
        this.session.save();
        this.session.logout();
        this.session = this.repo.login();
        FedoraObject obj2 = this.objectService.getObject(this.session, "/" + pid);
        Assert.assertFalse((boolean)obj2.getLastModifiedDate().before(obj2.getCreatedDate()));
    }

    @Test
    public void testRepositoryRootGraph() throws RepositoryException {
        FedoraResource object = this.nodeService.getObject(this.session, "/");
        this.logger.debug(object.getPropertiesDataset((IdentifierTranslator)this.subjects).toString());
        Node s = this.createGraphSubjectNode("/");
        Node p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#primaryType");
        Node o = NodeFactory.createLiteral((String)"mode:root");
        Assert.assertTrue((boolean)object.getPropertiesDataset((IdentifierTranslator)this.subjects).asDatasetGraph().contains(Node.ANY, s, p, o));
        p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#repository/jcr.repository.vendor.url");
        o = NodeFactory.createLiteral((String)"http://www.modeshape.org");
        Assert.assertTrue((boolean)object.getPropertiesDataset((IdentifierTranslator)this.subjects).asDatasetGraph().contains(Node.ANY, s, p, o));
        p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#hasNodeType");
        o = NodeFactory.createLiteral((String)"fedora:resource");
        Assert.assertTrue((boolean)object.getPropertiesDataset((IdentifierTranslator)this.subjects).asDatasetGraph().contains(Node.ANY, s, p, o));
    }

    @Test
    public void testObjectGraph() throws RepositoryException {
        FedoraObject object = this.objectService.createObject(this.session, "/testObjectGraph");
        this.logger.debug(object.getPropertiesDataset((IdentifierTranslator)this.subjects).toString());
        Node s = this.createGraphSubjectNode("/testObjectGraph");
        Node p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#uuid");
        Node o = NodeFactory.createLiteral((String)object.getNode().getIdentifier());
        Assert.assertTrue((boolean)object.getPropertiesDataset((IdentifierTranslator)this.subjects).asDatasetGraph().contains(Node.ANY, s, p, o));
        p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#mixinTypes");
        o = NodeFactory.createLiteral((String)"fedora:resource");
        Assert.assertTrue((boolean)object.getPropertiesDataset((IdentifierTranslator)this.subjects).asDatasetGraph().contains(Node.ANY, s, p, o));
        o = NodeFactory.createLiteral((String)"fedora:object");
        Assert.assertTrue((boolean)object.getPropertiesDataset((IdentifierTranslator)this.subjects).asDatasetGraph().contains(Node.ANY, s, p, o));
    }

    @Test
    public void testObjectGraphWithCustomProperty() throws RepositoryException {
        FedoraObject object = this.objectService.createObject(this.session, "/testObjectGraph");
        javax.jcr.Node node = object.getNode();
        node.setProperty("dc:title", "this-is-some-title");
        node.setProperty("dc:subject", "this-is-some-subject-stored-as-a-binary", 2);
        node.setProperty("jcr:data", "jcr-data-should-be-ignored", 2);
        this.session.save();
        this.session.logout();
        this.session = this.repo.login();
        object = this.objectService.getObject(this.session, "/testObjectGraph");
        this.logger.debug(object.getPropertiesDataset((IdentifierTranslator)this.subjects).toString());
        Node s = this.createGraphSubjectNode("/testObjectGraph");
        Node p = RdfLexicon.DC_TITLE.asNode();
        Node o = NodeFactory.createLiteral((String)"this-is-some-title");
        Assert.assertTrue((boolean)object.getPropertiesDataset((IdentifierTranslator)this.subjects).asDatasetGraph().contains(Node.ANY, s, p, o));
        p = NodeFactory.createURI((String)"http://purl.org/dc/elements/1.1/subject");
        o = NodeFactory.createLiteral((String)"this-is-some-subject-stored-as-a-binary");
        Assert.assertTrue((boolean)object.getPropertiesDataset((IdentifierTranslator)this.subjects).asDatasetGraph().contains(Node.ANY, s, p, o));
        p = Node.ANY;
        o = NodeFactory.createLiteral((String)"jcr-data-should-be-ignored");
        Assert.assertFalse((boolean)object.getPropertiesDataset((IdentifierTranslator)this.subjects).asDatasetGraph().contains(Node.ANY, s, p, o));
    }

    @Test
    public void testRdfTypeInheritance() throws RepositoryException {
        this.logger.info("in testRdfTypeInheritance...");
        NodeTypeManager mgr = this.session.getWorkspace().getNodeTypeManager();
        NodeTypeTemplate type = mgr.createNodeTypeTemplate();
        type.setName("test:aSupertype");
        type.setMixin(true);
        NodeTypeDefinition[] nodeTypes = new NodeTypeDefinition[]{type};
        mgr.registerNodeTypes(nodeTypes, true);
        NodeTypeTemplate type2 = mgr.createNodeTypeTemplate();
        type2.setName("test:testInher");
        type2.setMixin(true);
        type2.setDeclaredSuperTypeNames(new String[]{"test:aSupertype"});
        NodeTypeDefinition[] nodeTypes2 = new NodeTypeDefinition[]{type2};
        mgr.registerNodeTypes(nodeTypes2, true);
        FedoraObject object = this.objectService.createObject(this.session, "/testNTTnheritanceObject");
        javax.jcr.Node node = object.getNode();
        node.addMixin("test:testInher");
        this.session.save();
        this.session.logout();
        this.session = this.repo.login();
        object = this.objectService.createObject(this.session, "/testNTTnheritanceObject");
        Node s = this.createGraphSubjectNode("/testNTTnheritanceObject");
        Node p = ResourceFactory.createProperty((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#type").asNode();
        Node o = ResourceFactory.createProperty((String)"info:fedora/test/aSupertype").asNode();
        Assert.assertTrue((String)"supertype test:aSupertype not found inherited in test:testInher!", (boolean)object.getPropertiesDataset((IdentifierTranslator)this.subjects).asDatasetGraph().contains(Node.ANY, s, p, o));
    }

    @Test
    public void testDatastreamGraph() throws RepositoryException, InvalidChecksumException {
        this.objectService.createObject(this.session, "/testDatastreamGraphParent");
        this.datastreamService.createDatastream(this.session, "/testDatastreamGraph", "text/plain", null, (InputStream)new ByteArrayInputStream("123456789test123456789".getBytes()));
        FedoraResource object = this.nodeService.getObject(this.session, "/testDatastreamGraph");
        object.getNode().setProperty("fedorarelsext:isPartOf", this.session.getNode("/testDatastreamGraphParent"));
        Dataset propertiesDataset = object.getPropertiesDataset((IdentifierTranslator)this.subjects);
        Assert.assertTrue((boolean)propertiesDataset.getContext().isDefined(Symbol.create((String)"uri")));
        this.logger.debug(propertiesDataset.toString());
        Node s = this.createGraphSubjectNode("/testDatastreamGraph");
        Node p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#uuid");
        Node o = NodeFactory.createLiteral((String)object.getNode().getIdentifier());
        DatasetGraph datasetGraph = propertiesDataset.asDatasetGraph();
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, o));
        p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#mixinTypes");
        o = NodeFactory.createLiteral((String)"fedora:resource");
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, o));
        o = NodeFactory.createLiteral((String)"fedora:datastream");
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, o));
        p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#numberOfChildren");
        o = NodeFactory.createLiteral((String)"0");
        p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/rels-ext#isPartOf");
        o = this.createGraphSubjectNode("/testDatastreamGraphParent");
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, o));
        p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#hasContent");
        o = this.createGraphSubjectNode("/testDatastreamGraph/fcr:content");
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, o));
        s = this.createGraphSubjectNode("/testDatastreamGraph/fcr:content");
        p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#mimeType");
        o = NodeFactory.createLiteral((String)"text/plain");
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, o));
        p = RdfLexicon.HAS_SIZE.asNode();
        o = NodeFactory.createLiteral((String)"22", (RDFDatatype)ResourceFactory.createTypedLiteral((Object)22L).getDatatype());
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, o));
    }

    @Test
    @Ignore(value="Skipping until we restablish paging behavior for RDF")
    public void testObjectGraphWindow() throws RepositoryException {
        FedoraObject object = this.objectService.createObject(this.session, "/testObjectGraphWindow");
        this.objectService.createObject(this.session, "/testObjectGraphWindow/a");
        this.objectService.createObject(this.session, "/testObjectGraphWindow/b");
        this.objectService.createObject(this.session, "/testObjectGraphWindow/c");
        Dataset propertiesDataset = object.getPropertiesDataset((IdentifierTranslator)this.subjects, 1, 1);
        this.logger.debug(propertiesDataset.toString());
        DatasetGraph datasetGraph = propertiesDataset.asDatasetGraph();
        Node s = this.createGraphSubjectNode("/testObjectGraphWindow");
        Node p = RdfLexicon.HAS_PRIMARY_IDENTIFIER.asNode();
        Node o = NodeFactory.createLiteral((String)object.getNode().getIdentifier());
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, o));
        p = RdfLexicon.HAS_CHILD.asNode();
        o = this.createGraphSubjectNode("/testObjectGraphWindow/a");
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, o));
        o = this.createGraphSubjectNode("/testObjectGraphWindow/b");
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, o));
        o = this.createGraphSubjectNode("/testObjectGraphWindow/c");
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, o));
        s = this.createGraphSubjectNode("/testObjectGraphWindow/b");
        p = RdfLexicon.HAS_PRIMARY_IDENTIFIER.asNode();
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, Node.ANY));
        s = this.createGraphSubjectNode("/testObjectGraphWindow/c");
        Assert.assertFalse((boolean)datasetGraph.contains(Node.ANY, s, p, Node.ANY));
    }

    @Test
    public void testUpdatingObjectGraph() throws RepositoryException {
        FedoraObject object = this.objectService.createObject(this.session, "/testObjectGraphUpdates");
        object.updatePropertiesDataset((IdentifierTranslator)this.subjects, "INSERT { <" + this.subjects.getSubject("/testObjectGraphUpdates").getURI() + "> " + "<info:fcrepo/zyx> \"a\" } WHERE {} ");
        Resource s = this.subjects.getSubject("/testObjectGraphUpdates");
        com.hp.hpl.jena.rdf.model.Property p = ResourceFactory.createProperty((String)"info:fcrepo/zyx");
        Literal o = ResourceFactory.createPlainLiteral((String)"a");
        Assert.assertTrue((boolean)object.getPropertiesDataset((IdentifierTranslator)this.subjects).getDefaultModel().contains(s, p, (RDFNode)o));
        object.updatePropertiesDataset((IdentifierTranslator)this.subjects, "DELETE { <" + this.createGraphSubjectNode("/testObjectGraphUpdates").getURI() + "> " + "<info:fcrepo/zyx> ?o }\n" + "INSERT { " + "<" + this.createGraphSubjectNode("/testObjectGraphUpdates").getURI() + "> " + "<info:fcrepo/zyx> \"b\" } " + "WHERE { " + "<" + this.createGraphSubjectNode("/testObjectGraphUpdates").getURI() + "> " + "<info:fcrepo/zyx> ?o } ");
        Assert.assertFalse((String)"found value we should have removed", (boolean)object.getPropertiesDataset((IdentifierTranslator)this.subjects).getDefaultModel().contains(s, p, (RDFNode)o));
        o = ResourceFactory.createPlainLiteral((String)"b");
        Assert.assertTrue((String)"could not find new value", (boolean)object.getPropertiesDataset((IdentifierTranslator)this.subjects).getDefaultModel().contains(s, p, (RDFNode)o));
    }

    @Test
    public void testAddVersionLabel() throws RepositoryException {
        FedoraObject object = this.objectService.createObject(this.session, "/testObjectVersionLabel");
        object.getNode().addMixin("mix:versionable");
        this.session.save();
        object.addVersionLabel("v0.0.1");
        this.session.save();
        Assert.assertTrue((boolean)Arrays.asList(object.getVersionHistory().getVersionLabels()).contains("v0.0.1"));
    }

    @Test
    public void testGetObjectVersionGraph() throws RepositoryException {
        FedoraObject object = this.objectService.createObject(this.session, "/testObjectVersionGraph");
        object.getNode().addMixin("mix:versionable");
        this.session.save();
        object.addVersionLabel("v0.0.1");
        this.session.save();
        Model graphStore = object.getVersionTriples((IdentifierTranslator)this.subjects).asModel();
        this.logger.debug(graphStore.toString());
        Resource s = this.subjects.getSubject("/testObjectVersionGraph");
        com.hp.hpl.jena.rdf.model.Property p = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#hasVersion");
        StmtIterator triples = graphStore.listStatements(s, p, (RDFNode)null);
        List list = triples.toList();
        Assert.assertEquals((long)1L, (long)list.size());
        s = ((Statement)list.get(0)).getObject().asResource();
        p = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#hasVersionLabel");
        Literal o = ResourceFactory.createPlainLiteral((String)"v0.0.1");
        Assert.assertTrue((boolean)graphStore.contains(s, p, (RDFNode)o));
    }

    @Test
    public void testUpdatingRdfTypedValues() throws RepositoryException {
        FedoraObject object = this.objectService.createObject(this.session, "/testObjectRdfType");
        Dataset propertiesDataset = object.getPropertiesDataset((IdentifierTranslator)this.subjects, 0, -2);
        this.logger.debug(propertiesDataset.toString());
        object.updatePropertiesDataset((IdentifierTranslator)this.subjects, "PREFIX example: <http://example.org/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\nINSERT { <" + this.createGraphSubjectNode("/testObjectRdfType").getURI() + "> example:int-property \"0\"^^xsd:long } " + "WHERE { }");
        Assert.assertEquals((long)3L, (long)object.getNode().getProperty("example:int-property").getType());
        Assert.assertEquals((long)0L, (long)object.getNode().getProperty("example:int-property").getValues()[0].getLong());
    }

    @Test
    public void testUpdatingRdfType() throws RepositoryException {
        FedoraObject object = this.objectService.createObject(this.session, "/testObjectRdfType");
        Dataset propertiesDataset = object.getPropertiesDataset((IdentifierTranslator)this.subjects, 0, -2);
        this.logger.debug(propertiesDataset.toString());
        object.updatePropertiesDataset((IdentifierTranslator)this.subjects, "INSERT { <" + this.createGraphSubjectNode("/testObjectRdfType").getURI() + "> <" + RDF.type + "> <http://some/uri> } WHERE { }");
        Assert.assertEquals((long)11L, (long)object.getNode().getProperty("rdf:type").getType());
        Assert.assertEquals((Object)"http://some/uri", (Object)object.getNode().getProperty("rdf:type").getValues()[0].getString());
    }

    @Test
    public void testEtagValue() throws RepositoryException {
        FedoraObject object = this.objectService.createObject(this.session, "/testEtagObject");
        this.session.save();
        String actual = object.getEtagValue();
        Assert.assertNotNull((Object)actual);
        Assert.assertNotEquals((Object)"", (Object)actual);
    }

    @Test
    public void testGetReferences() throws RepositoryException {
        String pid = UUID.randomUUID().toString();
        this.objectService.createObject(this.session, pid);
        FedoraObject subject = this.objectService.createObject(this.session, pid + "/a");
        FedoraObject object = this.objectService.createObject(this.session, pid + "/b");
        Value value = this.session.getValueFactory().createValue(object.getNode());
        subject.getNode().setProperty("fedorarelsext:isPartOf", new Value[]{value});
        this.session.save();
        Model model = object.getReferencesTriples((IdentifierTranslator)this.subjects).asModel();
        Assert.assertTrue((boolean)model.contains(this.subjects.getSubject(subject.getPath()), ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/rels-ext#isPartOf"), (RDFNode)this.subjects.getSubject(object.getPath())));
    }

    @Test
    public void testReplaceProperties() throws RepositoryException {
        String pid = UUID.randomUUID().toString();
        FedoraObject object = this.objectService.createObject(this.session, pid);
        StmtIterator stmtIterator = object.getPropertiesDataset((IdentifierTranslator)this.subjects).getDefaultModel().listStatements();
        Model model = ModelFactory.createDefaultModel().add(stmtIterator);
        Resource resource = model.createResource();
        Resource subject = this.subjects.getSubject(object.getPath());
        com.hp.hpl.jena.rdf.model.Property predicate = model.createProperty("info:xyz");
        model.add(subject, predicate, (RDFNode)resource);
        model.add(resource, model.createProperty("http://purl.org/dc/elements/1.1/title"), "xyz");
        object.replaceProperties((IdentifierTranslator)this.subjects, model);
        PropertyIterator properties = new PropertyIterator(object.getNode().getProperties());
        UnmodifiableIterator relation = Iterators.filter((Iterator)properties, (Predicate)new Predicate<Property>(){

            public boolean apply(Property property) {
                try {
                    return property.getName().contains("xyz_ref");
                }
                catch (RepositoryException e) {
                    return false;
                }
            }
        });
        Assert.assertTrue((boolean)relation.hasNext());
        Property next = (Property)relation.next();
        Value[] values = next.getValues();
        Assert.assertEquals((long)1L, (long)values.length);
        javax.jcr.Node skolemizedNode = this.session.getNodeByIdentifier(values[0].getString());
        Assert.assertTrue((boolean)skolemizedNode.getPath().contains("/.well-known/genid/"));
        Assert.assertEquals((Object)"xyz", (Object)skolemizedNode.getProperty("dc:title").getValues()[0].getString());
    }
}

