/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.kernel.impl.services;

import javax.inject.Inject;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.fcrepo.integration.kernel.impl.AbstractIT;
import org.fcrepo.kernel.FedoraObject;
import org.fcrepo.kernel.services.NodeService;
import org.fcrepo.kernel.services.ObjectService;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"/spring-test/repo.xml"})
public class NodeServiceImplIT
extends AbstractIT {
    @Inject
    private Repository repository;
    @Inject
    NodeService nodeService;
    @Inject
    ObjectService objectService;

    @Test
    public void testDeleteObject() throws RepositoryException {
        Session session = this.repository.login();
        String pid = this.getRandomPid();
        this.nodeService.findOrCreateObject(session, "/" + pid);
        session.save();
        this.nodeService.deleteObject(session, "/" + pid);
        session.save();
        Assert.assertFalse((boolean)session.nodeExists("/" + pid));
    }

    @Test
    public void testDeleteObjectWithInboundReferences() throws RepositoryException {
        Session session = this.repository.login();
        String pid = this.getRandomPid();
        FedoraObject resourceA = this.objectService.createObject(session, "/" + pid + "/a");
        FedoraObject resourceB = this.objectService.createObject(session, "/" + pid + "/b");
        Value value = session.getValueFactory().createValue(resourceB.getNode());
        resourceA.getNode().setProperty("fedorarelsext:hasMember", new Value[]{value});
        session.save();
        this.nodeService.deleteObject(session, "/" + pid + "/a");
        session.save();
        this.nodeService.deleteObject(session, "/" + pid + "/b");
        session.save();
        Assert.assertFalse((boolean)session.nodeExists("/" + pid + "/b"));
    }
}

