/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.kernel.impl.services;

import com.google.common.io.Files;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.update.UpdateAction;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import javax.inject.Inject;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Repository;
import javax.jcr.Session;
import org.fcrepo.integration.kernel.impl.AbstractIT;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.impl.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.services.DatastreamService;
import org.fcrepo.kernel.services.RepositoryService;
import org.jgroups.util.Util;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.jcr.api.Problems;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"/spring-test/repo.xml"})
public class RepositoryServiceImplIT
extends AbstractIT {
    @Inject
    private Repository repository;
    @Inject
    RepositoryService repositoryService;
    @Inject
    DatastreamService datastreamService;
    private static final IdentifierTranslator idTranslator = new DefaultIdentifierTranslator();

    @Test
    public void testGetAllObjectsDatastreamSize() throws Exception {
        Session session = this.repository.login();
        double originalSize = this.repositoryService.getRepositorySize().longValue();
        this.datastreamService.createDatastream(session, "testObjectServiceNode", "application/octet-stream", null, (InputStream)new ByteArrayInputStream("asdf".getBytes()));
        session.save();
        session.logout();
        session = this.repository.login();
        double afterSize = this.repositoryService.getRepositorySize().longValue();
        Util.assertEquals((Object)4.0, (Object)(afterSize - originalSize));
        session.logout();
    }

    @Test
    public void testGetNamespaceRegistryGraph() throws Exception {
        Session session = this.repository.login();
        Dataset registryGraph = this.repositoryService.getNamespaceRegistryDataset(session, idTranslator);
        NamespaceRegistry namespaceRegistry = session.getWorkspace().getNamespaceRegistry();
        this.logger.info(namespaceRegistry.toString());
        this.logger.info(registryGraph.toString());
        for (String s : namespaceRegistry.getPrefixes()) {
            if (s.isEmpty() || s.equals("xmlns") || s.equals("jcr")) continue;
            String uri = namespaceRegistry.getURI(s);
            Assert.assertTrue((String)("expected to find JCR namespaces " + s + " in graph"), (boolean)registryGraph.asDatasetGraph().contains(Node.ANY, ResourceFactory.createResource((String)uri).asNode(), RdfLexicon.HAS_NAMESPACE_PREFIX.asNode(), ResourceFactory.createPlainLiteral((String)s).asNode()));
        }
        session.logout();
    }

    @Test
    public void testUpdateNamespaceRegistryGraph() throws Exception {
        Session session = this.repository.login();
        Dataset registryGraph = this.repositoryService.getNamespaceRegistryDataset(session, idTranslator);
        NamespaceRegistry namespaceRegistry = session.getWorkspace().getNamespaceRegistry();
        UpdateAction.parseExecute((String)("INSERT { <info:abc> <" + RdfLexicon.HAS_NAMESPACE_PREFIX.toString() + "> \"abc\" } WHERE { }"), (Dataset)registryGraph);
        Util.assertEquals((Object)"abc", (Object)namespaceRegistry.getPrefix("info:abc"));
        session.logout();
    }

    @Test
    public void testBackupRepository() throws Exception {
        Session session = this.repository.login();
        this.datastreamService.createDatastream(session, "testObjectServiceNode0", "application/octet-stream", null, (InputStream)new ByteArrayInputStream("asdfx".getBytes()));
        session.save();
        File backupDirectory = Files.createTempDir();
        Problems problems = this.repositoryService.backupRepository(session, backupDirectory);
        Assert.assertFalse((boolean)problems.hasProblems());
        session.logout();
    }

    @Test
    public void testRestoreRepository() throws Exception {
        Session session = this.repository.login();
        this.datastreamService.createDatastream(session, "testObjectServiceNode1", "application/octet-stream", null, (InputStream)new ByteArrayInputStream("asdfy".getBytes()));
        session.save();
        File backupDirectory = Files.createTempDir();
        this.repositoryService.backupRepository(session, backupDirectory);
        Problems problems = this.repositoryService.restoreRepository(session, backupDirectory);
        Assert.assertFalse((boolean)problems.hasProblems());
        session.logout();
    }
}

