/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils;

import com.google.common.base.Predicate;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Iterator;
import java.util.TimeZone;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.fcrepo.kernel.impl.rdf.JcrRdfTools;
import org.fcrepo.kernel.impl.utils.FedoraTypesUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.JcrValueFactory;
import org.modeshape.jcr.api.Namespaced;

public class FedoraTypesUtilsTest {
    @Mock
    private Node mockNode;
    @Mock
    private Session mockSession;
    @Mock
    private ValueFactory mockVF;
    @Mock
    private InputStream mockInput;
    @Mock
    private JcrValueFactory mockJVF;
    @Mock
    private Workspace mockWS;
    @Mock
    private NodeTypeManager mockNTM;
    @Mock
    private NodeType mockNodeType;
    @Mock
    private PropertyDefinition mockPropertyDefinition;
    @Mock
    private Version mockVersion;
    @Mock
    private VersionManager mockVersionManager;
    @Mock
    private VersionHistory mockVersionHistory;
    @Mock
    private Repository mockRepository;
    @Mock
    private QueryManager mockQueryManager;
    @Mock
    private Query mockQuery;
    @Mock
    private QueryResult mockResults;
    @Mock
    private RowIterator mockIterator;
    @Mock
    private Row mockRow;
    @Mock
    private Value mockValue;
    @Mock
    private Value mockValue2;
    @Mock
    private Property mockProperty;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testIsMultipleValuedProperty() throws RepositoryException {
        Property mockYes = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)mockYes.isMultiple()).thenReturn((Object)true);
        Property mockNo = (Property)Mockito.mock(Property.class);
        Predicate test = FedoraTypesUtils.isMultipleValuedProperty;
        try {
            test.apply(null);
            Assert.fail((String)"Null values should throw a NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        boolean actual = test.apply((Object)mockYes);
        Assert.assertEquals((Object)true, (Object)actual);
        actual = test.apply((Object)mockNo);
        Assert.assertEquals((Object)false, (Object)actual);
        Mockito.when((Object)mockYes.isMultiple()).thenThrow(new Throwable[]{new RepositoryException()});
        try {
            test.apply((Object)mockYes);
            Assert.fail((String)"Unexpected completion after RepositoryException!");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    @Test
    public void testIsBinaryContentProperty() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)2);
        Mockito.when((Object)this.mockProperty.getName()).thenReturn((Object)"jcr:data");
        Assert.assertTrue((boolean)FedoraTypesUtils.isBinaryContentProperty.apply((Object)this.mockProperty));
    }

    @Test
    public void testIsReferenceProperty() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)9);
        Mockito.when((Object)this.mockProperty.getName()).thenReturn((Object)"foo_ref");
        Assert.assertTrue((boolean)FedoraTypesUtils.isReferenceProperty.apply((Object)this.mockProperty));
    }

    @Test
    public void testIsReferencePropertyWeak() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)10);
        Mockito.when((Object)this.mockProperty.getName()).thenReturn((Object)"foo_ref");
        Assert.assertTrue((boolean)FedoraTypesUtils.isReferenceProperty.apply((Object)this.mockProperty));
    }

    @Test
    public void testIsInternalProperty() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)9);
        Mockito.when((Object)this.mockProperty.getName()).thenReturn((Object)"foo_ref");
        Assert.assertTrue((boolean)FedoraTypesUtils.isInternalProperty.apply((Object)this.mockProperty));
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)2);
        Mockito.when((Object)this.mockProperty.getName()).thenReturn((Object)"jcr:data");
        Assert.assertTrue((boolean)FedoraTypesUtils.isInternalProperty.apply((Object)this.mockProperty));
    }

    @Test
    public void testIsNotBinaryContentProperty() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)1);
        Assert.assertFalse((boolean)FedoraTypesUtils.isBinaryContentProperty.apply((Object)this.mockProperty));
    }

    @Test
    public void testContentButNotBinaryContentProperty() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)1);
        Mockito.when((Object)this.mockProperty.getName()).thenReturn((Object)"jcr:data");
        Assert.assertFalse((boolean)FedoraTypesUtils.isBinaryContentProperty.apply((Object)this.mockProperty));
    }

    @Test
    public void testGetPredicateForProperty() throws RepositoryException {
        PropertyMock mockProp = (PropertyMock)Mockito.mock(PropertyMock.class);
        JcrRdfTools.getPredicateForProperty.apply((Object)mockProp);
        Mockito.when((Object)mockProp.getNamespaceURI()).thenThrow(new Throwable[]{new RepositoryException()});
        try {
            JcrRdfTools.getPredicateForProperty.apply((Object)mockProp);
            Assert.fail((String)"Unexpected completion after RepositoryException!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetDefinitionForPropertyName() throws RepositoryException {
        String mockPropertyName = "mock:property";
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWS);
        Mockito.when((Object)this.mockWS.getNodeTypeManager()).thenReturn((Object)this.mockNTM);
        Mockito.when((Object)this.mockNTM.getNodeType(Matchers.anyString())).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockPropertyDefinition.getName()).thenReturn((Object)"mock:property");
        PropertyDefinition[] PDs = new PropertyDefinition[]{this.mockPropertyDefinition};
        Mockito.when((Object)this.mockNodeType.getPropertyDefinitions()).thenReturn((Object)PDs);
        PropertyDefinition actual = FedoraTypesUtils.getDefinitionForPropertyName((Node)this.mockNode, (String)"mock:property");
        Assert.assertEquals((Object)this.mockPropertyDefinition, (Object)actual);
        actual = FedoraTypesUtils.getDefinitionForPropertyName((Node)this.mockNode, (String)"mock:property:fail");
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testConvertDateToXSDString() {
        String expected = "2006-11-13T09:40:55.001Z";
        Calendar date = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        date.set(2006, 10, 13, 9, 40, 55);
        date.set(14, 1);
        Assert.assertEquals((Object)"2006-11-13T09:40:55.001Z", (Object)FedoraTypesUtils.convertDateToXSDString((long)date.getTimeInMillis()));
    }

    @Test
    public void testGetVersionHistoryForSessionAndPath() throws RepositoryException {
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWS);
        Mockito.when((Object)this.mockWS.getVersionManager()).thenReturn((Object)this.mockVersionManager);
        Mockito.when((Object)this.mockVersionManager.getVersionHistory("/my/path")).thenReturn((Object)this.mockVersionHistory);
        VersionHistory versionHistory = FedoraTypesUtils.getVersionHistory((Session)this.mockSession, (String)"/my/path");
        Assert.assertEquals((Object)this.mockVersionHistory, (Object)versionHistory);
    }

    @Test
    public void testIsInternalNode() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNodeType.isNodeType("mode:system")).thenReturn((Object)true);
        Assert.assertTrue((String)"mode:system nodes should be treated as internal nodes!", (boolean)FedoraTypesUtils.isInternalNode.apply((Object)this.mockNode));
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNodeType.isNodeType("mode:system")).thenReturn((Object)false);
        Assert.assertFalse((String)"Nodes that are not mode:system types should not be treated as internal nodes!", (boolean)FedoraTypesUtils.isInternalNode.apply((Object)this.mockNode));
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenThrow(new Throwable[]{new RepositoryException()});
        try {
            FedoraTypesUtils.isInternalNode.apply((Object)this.mockNode);
            Assert.fail((String)"Unexpected completion of FedoraTypesUtils.isInternalNode after RepositoryException!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testPredicateExceptionHandling() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenThrow(new Throwable[]{new RepositoryException()});
        try {
            FedoraTypesUtils.isFedoraResource.apply((Object)this.mockNode);
            Assert.fail((String)"Unexpected FedoraTypesUtils.isFedoraResource completion after RepositoryException!");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            FedoraTypesUtils.isFedoraObject.apply((Object)this.mockNode);
            Assert.fail((String)"Unexpected FedoraTypesUtils.isFedoraObject completion after RepositoryException!");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            FedoraTypesUtils.isFedoraDatastream.apply((Object)this.mockNode);
            Assert.fail((String)"Unexpected FedoraTypesUtils.isFedoraDatastream completion after RepositoryException!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testValue2String() throws RepositoryException {
        Mockito.when((Object)this.mockValue.getString()).thenReturn((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)FedoraTypesUtils.value2string.apply((Object)this.mockValue));
        Mockito.when((Object)this.mockValue.getString()).thenThrow(new Throwable[]{new RepositoryException()});
        try {
            FedoraTypesUtils.value2string.apply((Object)this.mockValue);
            Assert.fail((String)"Unexpected FedoraTypesUtils.value2string completion after RepositoryException!");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            FedoraTypesUtils.value2string.apply(null);
            Assert.fail((String)"Unexpected FedoraTypesUtils.value2string completion with null argument!");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testProperty2values() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)false);
        Mockito.when((Object)this.mockProperty.getValue()).thenReturn((Object)this.mockValue);
        Assert.assertEquals((String)"Found wrong Value!", ((Iterator)FedoraTypesUtils.property2values.apply((Object)this.mockProperty)).next(), (Object)this.mockValue);
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)true);
        Mockito.when((Object)this.mockProperty.getValues()).thenReturn((Object)new Value[]{this.mockValue, this.mockValue2});
        Iterator testIterator = (Iterator)FedoraTypesUtils.property2values.apply((Object)this.mockProperty);
        Assert.assertEquals((String)"Found wrong Value!", testIterator.next(), (Object)this.mockValue);
        Assert.assertEquals((String)"Found wrong Value!", testIterator.next(), (Object)this.mockValue2);
    }

    @Test
    public void testPropertyContainsWithNull() throws RepositoryException {
        Assert.assertFalse((boolean)FedoraTypesUtils.propertyContains(null, (String)"any-string"));
    }

    @Test
    public void testSingleValuedPropertyContains() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)false);
        Mockito.when((Object)this.mockProperty.getString()).thenReturn((Object)"some-string");
        Assert.assertTrue((boolean)FedoraTypesUtils.propertyContains((Property)this.mockProperty, (String)"some-string"));
        Assert.assertFalse((boolean)FedoraTypesUtils.propertyContains((Property)this.mockProperty, (String)"some-other-string"));
    }

    @Test
    public void testMultiValuedPropertyContains() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)true);
        Mockito.when((Object)this.mockProperty.getValues()).thenReturn((Object)new Value[]{this.mockValue});
        Mockito.when((Object)this.mockValue.getString()).thenReturn((Object)"some-string");
        Assert.assertTrue((boolean)FedoraTypesUtils.propertyContains((Property)this.mockProperty, (String)"some-string"));
        Assert.assertFalse((boolean)FedoraTypesUtils.propertyContains((Property)this.mockProperty, (String)"some-other-string"));
    }

    static interface PropertyMock
    extends Property,
    Namespaced {
    }
}

