/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils.iterators;

import com.google.common.collect.ImmutableMap;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.fcrepo.kernel.impl.rdf.JcrRdfTools;
import org.fcrepo.kernel.impl.utils.iterators.RdfRemover;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.modeshape.jcr.api.NamespaceRegistry;

public class RdfRemoverTest {
    private RdfRemover testRemover;
    @Mock
    private javax.jcr.Node mockNode;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private ValueFactory mockValueFactory;
    @Mock
    private Value mockValue;
    @Mock
    private Value mockValue2;
    @Mock
    private NamespaceRegistry mockNamespaceRegistry;
    @Mock
    private Property mockProperty;
    @Mock
    private NodeTypeManager mockNodeTypeManager;
    @Mock
    private NodeType mockNodeType;
    @Mock
    private PropertyDefinition mockPropertyDefinition;
    @Mock
    private Session mockSession;
    @Mock
    private Iterator<Triple> mockTriples;
    private RdfStream testStream;
    @Mock
    private IdentifierTranslator mockGraphSubjects;
    private static final Model m = ModelFactory.createDefaultModel();
    private static final String propertyNamespacePrefix = "ex";
    private static final String propertyNamespaceUri = "http://www.example.com#";
    private static final String propertyBaseName = "example-property";
    private static final String propertyLongName = "http://www.example.com#example-property";
    private static final Map<String, String> mockNamespaceMap = ImmutableMap.of((Object)"ex", (Object)"http://www.example.com#", (Object)"rdf", (Object)RDF.type.getNameSpace());
    private static final String description = "Description.";
    private static final Triple descriptiveTriple = Triple.create((Node)NodeFactory.createAnon(), (Node)NodeFactory.createURI((String)"http://www.example.com#example-property"), (Node)NodeFactory.createLiteral((String)"Description."));
    private static final Statement descriptiveStmnt = m.asStatement(descriptiveTriple);
    private static final Resource mockNodeSubject = descriptiveStmnt.getSubject();
    private static final String mixinLongName = RDF.type.getNameSpace() + "someType";
    private static final String mixinShortName = "rdf:someType";
    private static final Resource mixinObject = ResourceFactory.createResource((String)mixinLongName);
    private static final Triple mixinTriple = Triple.create((Node)mockNodeSubject.asNode(), (Node)RDF.type.asNode(), (Node)mixinObject.asNode());
    private static final String propertyShortName = "ex:example-property";
    private static final Statement mixinStmnt = m.asStatement(mixinTriple);

    @Test
    public void testRemovingNonExistentProperty() throws Exception {
        Mockito.when((Object)this.mockNode.hasProperty(propertyShortName)).thenReturn((Object)false);
        this.testRemover = new RdfRemover(this.mockGraphSubjects, this.mockSession, this.testStream);
        this.testRemover.operateOnProperty(descriptiveStmnt, this.mockNode);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockProperty});
    }

    @Test
    public void testRemovingExistentProperty() throws Exception {
        Mockito.when((Object)this.mockNode.hasProperty(propertyShortName)).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.getProperty(propertyShortName)).thenReturn((Object)this.mockProperty);
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)false);
        Mockito.when((Object)this.mockProperty.getValue()).thenReturn((Object)this.mockValue);
        this.testRemover = new RdfRemover(this.mockGraphSubjects, this.mockSession, this.testStream);
        this.testRemover.operateOnProperty(descriptiveStmnt, this.mockNode);
        ((Property)Mockito.verify((Object)this.mockProperty)).setValue((Value)null);
    }

    @Test
    public void testRemovingExistentMixin() throws Exception {
        this.testRemover = new RdfRemover(this.mockGraphSubjects, this.mockSession, this.testStream);
        this.testRemover.operateOnMixin(mixinStmnt.getObject().asResource(), this.mockNode);
        ((javax.jcr.Node)Mockito.verify((Object)this.mockNode)).removeMixin(mixinShortName);
    }

    @Test
    public void testRemovingNonExistentMixin() throws Exception {
        ((javax.jcr.Node)Mockito.doThrow((Throwable)new NoSuchNodeTypeException("Expected.")).when((Object)this.mockNode)).removeMixin(mixinShortName);
        this.testRemover = new RdfRemover(this.mockGraphSubjects, this.mockSession, this.testStream);
        this.testRemover.operateOnMixin(mixinStmnt.getObject().asResource(), this.mockNode);
        ((javax.jcr.Node)Mockito.verify((Object)this.mockNode)).removeMixin(mixinShortName);
    }

    @Test
    public void testRemovingMixinThatCannotExistInRepo() throws Exception {
        Mockito.when((Object)this.mockNodeTypeManager.hasNodeType(mixinShortName)).thenReturn((Object)false);
        this.testRemover = new RdfRemover(this.mockGraphSubjects, this.mockSession, this.testStream);
        this.testRemover.operateOnMixin(mixinStmnt.getObject().asResource(), this.mockNode);
        ((javax.jcr.Node)Mockito.verify((Object)this.mockNode, (VerificationMode)Mockito.never())).removeMixin(mixinShortName);
    }

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockNode.getName()).thenReturn((Object)"mockNode");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/mockNode");
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockSession.getValueFactory()).thenReturn((Object)this.mockValueFactory);
        Mockito.when((Object)this.mockSession.getNamespacePrefix(JcrRdfTools.getJcrNamespaceForRDFNamespace((String)RDF.type.getNameSpace()))).thenReturn((Object)"rdf");
        Mockito.when((Object)this.mockValueFactory.createValue(description, 1)).thenReturn((Object)this.mockValue);
        Mockito.when((Object)this.mockWorkspace.getNamespaceRegistry()).thenReturn((Object)this.mockNamespaceRegistry);
        Mockito.when((Object)this.mockNamespaceRegistry.getURI(propertyNamespacePrefix)).thenReturn((Object)propertyNamespaceUri);
        Mockito.when((Object)this.mockNamespaceRegistry.getURI("rdf")).thenReturn((Object)RDF.type.getNameSpace());
        Mockito.when((Object)this.mockNamespaceRegistry.isRegisteredUri(propertyNamespaceUri)).thenReturn((Object)true);
        Mockito.when((Object)this.mockNamespaceRegistry.isRegisteredUri(RDF.type.getNameSpace())).thenReturn((Object)true);
        Mockito.when((Object)this.mockNamespaceRegistry.getPrefix(propertyNamespaceUri)).thenReturn((Object)propertyNamespacePrefix);
        Mockito.when((Object)this.mockNamespaceRegistry.getPrefix(RDF.type.getNameSpace())).thenReturn((Object)"rdf");
        Mockito.when((Object)this.mockWorkspace.getNodeTypeManager()).thenReturn((Object)this.mockNodeTypeManager);
        Mockito.when((Object)this.mockNodeTypeManager.getNodeType("fedora:resource")).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNodeTypeManager.hasNodeType(mixinShortName)).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        Mockito.when((Object)this.mockNode.canAddMixin(mixinShortName)).thenReturn((Object)true);
        Mockito.when((Object)this.mockNodeType.getPropertyDefinitions()).thenReturn((Object)new PropertyDefinition[]{this.mockPropertyDefinition});
        Mockito.when((Object)this.mockPropertyDefinition.isMultiple()).thenReturn((Object)false);
        Mockito.when((Object)this.mockPropertyDefinition.getName()).thenReturn((Object)propertyShortName);
        Mockito.when((Object)this.mockPropertyDefinition.getRequiredType()).thenReturn((Object)1);
        Mockito.when((Object)this.mockGraphSubjects.getSubject(this.mockNode.getPath())).thenReturn((Object)mockNodeSubject);
        Mockito.when((Object)this.mockTriples.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when((Object)this.mockTriples.next()).thenReturn((Object)descriptiveTriple, (Object[])new Triple[]{mixinTriple});
        this.testStream = new RdfStream(this.mockTriples);
        this.testStream.namespaces(mockNamespaceMap);
    }
}

