/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.update.UpdateAction;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.apache.commons.codec.digest.DigestUtils;
import org.fcrepo.jcr.FedoraJcrTypes;
import org.fcrepo.kernel.FedoraResource;
import org.fcrepo.kernel.impl.rdf.JcrRdfTools;
import org.fcrepo.kernel.impl.services.ServiceHelpers;
import org.fcrepo.kernel.impl.utils.FedoraTypesUtils;
import org.fcrepo.kernel.impl.utils.JcrPropertyStatementListener;
import org.fcrepo.kernel.impl.utils.iterators.RdfAdder;
import org.fcrepo.kernel.impl.utils.iterators.RdfRemover;
import org.fcrepo.kernel.rdf.GraphProperties;
import org.fcrepo.kernel.rdf.HierarchyRdfContextOptions;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.utils.iterators.DifferencingIterator;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.modeshape.jcr.api.JcrTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedoraResourceImpl
extends JcrTools
implements FedoraJcrTypes,
FedoraResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(FedoraResourceImpl.class);
    protected Node node = null;

    public FedoraResourceImpl() {
        super(false);
    }

    public FedoraResourceImpl(Node node) {
        this();
        this.node = node;
    }

    public FedoraResourceImpl(Session session, String path, String nodeType) throws RepositoryException {
        this();
        this.initializeNewResourceProperties(session, path, nodeType);
    }

    private void initializeNewResourceProperties(Session session, String path, String nodeType) throws RepositoryException {
        this.node = this.findOrCreateNode(session, path, "nt:folder", nodeType);
        if (this.node.isNew() && !FedoraTypesUtils.isFedoraResource.apply((Object)this.node) && !FedoraTypesUtils.isFrozen.apply((Object)this.node)) {
            this.node.addMixin("fedora:resource");
        }
    }

    public boolean hasContent() throws RepositoryException {
        return this.node.hasNode("jcr:content");
    }

    public Node getNode() {
        return this.node;
    }

    public String getPath() throws RepositoryException {
        return this.node.getPath();
    }

    public Date getCreatedDate() throws RepositoryException {
        if (this.node.hasProperty("jcr:created")) {
            return new Date(this.node.getProperty("jcr:created").getDate().getTimeInMillis());
        }
        LOGGER.debug("Node {} does not have a createdDate", (Object)this.node);
        return null;
    }

    public Date getLastModifiedDate() throws RepositoryException {
        Date createdDate = this.getCreatedDate();
        if (this.node.hasProperty("jcr:lastModified")) {
            return new Date(this.node.getProperty("jcr:lastModified").getDate().getTimeInMillis());
        }
        LOGGER.debug("Could not get last modified date property for node {}", (Object)this.node);
        if (createdDate != null) {
            LOGGER.trace("Using created date for last modified date for node {}", (Object)this.node);
            return createdDate;
        }
        return null;
    }

    public Long getSize() throws RepositoryException {
        return ServiceHelpers.getObjectSize(this.node);
    }

    public Collection<String> getModels() throws RepositoryException {
        if (FedoraTypesUtils.isFrozen.apply((Object)this.node)) {
            return Lists.newArrayList((Iterator)Iterators.transform((Iterator)((Iterator)FedoraTypesUtils.property2values.apply((Object)this.node.getProperty("jcr:frozenMixinTypes"))), FedoraTypesUtils.value2string));
        }
        return FedoraTypesUtils.map(this.node.getMixinNodeTypes(), FedoraTypesUtils.nodetype2name);
    }

    public Dataset updatePropertiesDataset(IdentifierTranslator subjects, String sparqlUpdateStatement) throws RepositoryException {
        Dataset dataset = this.getPropertiesDataset(subjects);
        UpdateRequest request = UpdateFactory.create((String)sparqlUpdateStatement, (String)dataset.getContext().getAsString(GraphProperties.URI_SYMBOL));
        dataset.getDefaultModel().setNsPrefixes(request.getPrefixMapping());
        UpdateAction.execute((UpdateRequest)request, (Dataset)dataset);
        return dataset;
    }

    public Dataset getPropertiesDataset(IdentifierTranslator graphSubjects, int offset, int limit) throws RepositoryException {
        JcrRdfTools jcrRdfTools = JcrRdfTools.withContext(graphSubjects, this.getNode().getSession());
        RdfStream propertiesStream = jcrRdfTools.getJcrTriples(this.getNode());
        HierarchyRdfContextOptions serializationOptions = new HierarchyRdfContextOptions(limit, offset);
        propertiesStream.concat((Iterator)jcrRdfTools.getTreeTriples(this.getNode(), serializationOptions));
        Dataset dataset = DatasetFactory.create((Model)propertiesStream.asModel());
        Model problemsModel = ModelFactory.createDefaultModel();
        JcrPropertyStatementListener listener = JcrPropertyStatementListener.getListener(graphSubjects, this.node.getSession(), problemsModel);
        dataset.getDefaultModel().register((ModelChangedListener)listener);
        dataset.addNamedModel("problems", problemsModel);
        dataset.getContext().set(GraphProperties.URI_SYMBOL, (Object)graphSubjects.getSubject(this.getNode().getPath()));
        return dataset;
    }

    public Dataset getPropertiesDataset(IdentifierTranslator subjects) throws RepositoryException {
        return this.getPropertiesDataset(subjects, 0, -1);
    }

    public RdfStream getTriples(IdentifierTranslator graphSubjects) throws RepositoryException {
        JcrRdfTools jcrRdfTools = JcrRdfTools.withContext(graphSubjects, this.getNode().getSession());
        return jcrRdfTools.getJcrTriples(this.getNode());
    }

    public RdfStream getHierarchyTriples(IdentifierTranslator graphSubjects, HierarchyRdfContextOptions serializationOptions) throws RepositoryException {
        JcrRdfTools jcrRdfTools = JcrRdfTools.withContext(graphSubjects, this.getNode().getSession());
        return jcrRdfTools.getTreeTriples(this.getNode(), serializationOptions);
    }

    public RdfStream getVersionTriples(IdentifierTranslator graphSubjects) throws RepositoryException {
        return JcrRdfTools.withContext(graphSubjects, this.node.getSession()).getVersionTriples(this.node);
    }

    public RdfStream getReferencesTriples(IdentifierTranslator graphSubjects) throws RepositoryException {
        return JcrRdfTools.withContext(graphSubjects, this.node.getSession()).getReferencesTriples(this.node);
    }

    public void addVersionLabel(String label) throws RepositoryException {
        VersionHistory versionHistory = this.getVersionHistory();
        versionHistory.addVersionLabel(this.getBaseVersion().getName(), label, true);
    }

    public Version getBaseVersion() throws RepositoryException {
        return this.node.getSession().getWorkspace().getVersionManager().getBaseVersion(this.node.getPath());
    }

    public VersionHistory getVersionHistory() throws RepositoryException {
        return this.node.getSession().getWorkspace().getVersionManager().getVersionHistory(this.node.getPath());
    }

    public Boolean isNew() {
        return this.node.isNew();
    }

    public RdfStream replaceProperties(IdentifierTranslator graphSubjects, Model inputModel) throws RepositoryException {
        RdfStream originalTriples = this.getTriples(graphSubjects);
        RdfStream replacementStream = RdfStream.fromModel((Model)inputModel);
        ImmutableSet replacementTriples = ImmutableSet.copyOf((Iterator)replacementStream.iterator());
        DifferencingIterator differencer = new DifferencingIterator((Set)replacementTriples, (Iterator)originalTriples);
        new RdfRemover(graphSubjects, this.getNode().getSession(), replacementStream.withThisContext((Iterator)differencer)).consume();
        new RdfAdder(graphSubjects, this.getNode().getSession(), replacementStream.withThisContext((Iterable)differencer.notCommon())).consume();
        return replacementStream.withThisContext(Iterables.concat((Iterable)differencer.common(), (Iterable)differencer.notCommon()));
    }

    public String getEtagValue() throws RepositoryException {
        Date lastModifiedDate = this.getLastModifiedDate();
        if (lastModifiedDate != null) {
            return DigestUtils.shaHex((String)(this.node.getPath() + lastModifiedDate.getTime()));
        }
        return "";
    }
}

