/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.observer;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import org.fcrepo.kernel.impl.utils.FedoraTypesUtils;
import org.fcrepo.kernel.observer.EventFilter;
import org.fcrepo.kernel.utils.EventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFilter
implements EventFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFilter.class);
    private Session session;

    public DefaultFilter() {
    }

    private DefaultFilter(Session session) {
        this.session = session;
    }

    public Predicate<Event> getFilter(Session session) {
        return new DefaultFilter(session);
    }

    public boolean apply(Event event) {
        try {
            switch (EventType.valueOf((Integer)event.getType())) {
                case NODE_REMOVED: {
                    String path = event.getPath();
                    if (!path.startsWith("jcr:", path.lastIndexOf(47) + 1)) {
                        return true;
                    }
                    break;
                }
                default: {
                    String nodeId = event.getIdentifier();
                    Node n = this.session.getNodeByIdentifier(nodeId);
                    if (FedoraTypesUtils.isFedoraObject.apply((Object)n) || FedoraTypesUtils.isFedoraDatastream.apply((Object)n)) {
                        return true;
                    }
                }
            }
        }
        catch (PathNotFoundException e) {
            LOGGER.trace("Dropping event from outside our assigned workspace:\n", (Throwable)e);
            return false;
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return false;
    }
}

