/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.observer.eventmappings;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.fcrepo.kernel.observer.FedoraEvent;
import org.fcrepo.kernel.observer.eventmappings.InternalExternalEventMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllNodeEventsOneEvent
implements InternalExternalEventMapper {
    private static final Function<Event, String> EXTRACT_NODE_ID = new Function<Event, String>(){

        public String apply(Event ev) {
            try {
                String id = ev.getIdentifier();
                log.debug("Sorting an event by identifier: {}", (Object)id);
                return id;
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    private static final Logger log = LoggerFactory.getLogger(AllNodeEventsOneEvent.class);

    public Iterator<FedoraEvent> apply(final Iterator<Event> events) {
        return new Iterator<FedoraEvent>(){
            final Multimap<String, Event> sortedEvents;
            final Iterator<String> nodeIds;
            {
                this.sortedEvents = Multimaps.index((Iterator)events, (Function)EXTRACT_NODE_ID);
                this.nodeIds = this.sortedEvents.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.nodeIds.hasNext();
            }

            @Override
            public FedoraEvent next() {
                Iterator nodeSpecificEvents = this.sortedEvents.get((Object)this.nodeIds.next()).iterator();
                Event firstEvent = (Event)nodeSpecificEvents.next();
                FedoraEvent fedoraEvent = new FedoraEvent(firstEvent);
                try {
                    this.addProperty(fedoraEvent, firstEvent);
                    while (nodeSpecificEvents.hasNext()) {
                        Event otherEvent = (Event)nodeSpecificEvents.next();
                        fedoraEvent.addType(Integer.valueOf(otherEvent.getType()));
                        this.addProperty(fedoraEvent, otherEvent);
                    }
                }
                catch (Exception ex) {
                    log.warn("Danger: swallowing exception", (Throwable)ex);
                }
                return fedoraEvent;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void addProperty(FedoraEvent fedoraEvent, Event e) {
                try {
                    if (e.getType() == 4 || e.getType() == 16 || e.getType() == 8) {
                        fedoraEvent.addProperty(e.getPath().substring(e.getPath().lastIndexOf("/") + 1));
                    } else {
                        log.trace("Not adding non-event property: {}, {}", (Object)fedoraEvent, (Object)e);
                    }
                }
                catch (RepositoryException ex) {
                    throw Throwables.propagate((Throwable)ex);
                }
            }
        };
    }
}

