/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import org.fcrepo.kernel.Lock;
import org.fcrepo.kernel.impl.services.AbstractService;
import org.fcrepo.kernel.services.LockService;
import org.springframework.stereotype.Component;

@Component
public class LockServiceImpl
extends AbstractService
implements LockService {
    public Lock acquireLock(Session session, String path, boolean deep) throws RepositoryException {
        LockManager lockManager = session.getWorkspace().getLockManager();
        if (lockManager.isLocked(path)) {
            throw new LockException("Already locked!");
        }
        return new JCRLock(lockManager.lock(path, deep, false, -1L, session.getUserID()));
    }

    public Lock getLock(Session session, String path) throws RepositoryException {
        LockManager lockManager = session.getWorkspace().getLockManager();
        if (!lockManager.isLocked(path)) {
            throw new PathNotFoundException("No lock at path " + path + "!");
        }
        return new JCRLock(lockManager.getLock(path));
    }

    public void releaseLock(Session session, String path) throws RepositoryException {
        LockManager lockManager = session.getWorkspace().getLockManager();
        if (!lockManager.isLocked(path)) {
            throw new PathNotFoundException("No lock at path " + path + "!");
        }
        session.getWorkspace().getLockManager().unlock(path);
    }

    private static class JCRLock
    implements Lock {
        private boolean isDeep;
        private String token;

        public JCRLock(javax.jcr.lock.Lock lock) throws RepositoryException {
            this.isDeep = lock.isDeep();
            this.token = lock.getLockToken();
        }

        public String getLockToken() {
            return this.token;
        }

        public boolean isDeep() {
            return this.isDeep;
        }
    }
}

