/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.fcrepo.kernel.Transaction;
import org.fcrepo.kernel.exception.TransactionMissingException;
import org.fcrepo.kernel.impl.services.AbstractService;
import org.fcrepo.kernel.impl.services.TransactionServiceImpl;
import org.fcrepo.kernel.impl.utils.FedoraTypesUtils;
import org.fcrepo.kernel.services.TransactionService;
import org.fcrepo.kernel.services.VersionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VersionServiceImpl
extends AbstractService
implements VersionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionService.class);
    protected static final String VERSIONABLE = "mix:versionable";
    protected static final String VERSION_POLICY = "fedoraconfig:versioningPolicy";
    protected static final String AUTO_VERSION = "auto-version";
    @Autowired
    private TransactionService txService;

    public void nodeUpdated(Session session, String absPath) throws RepositoryException {
        this.nodeUpdated(session.getNode(absPath));
    }

    public void nodeUpdated(Node n) throws RepositoryException {
        if (VersionServiceImpl.isImplicitVersioningEnabled(n)) {
            if (!VersionServiceImpl.isVersioningEnabled(n)) {
                this.enableVersioning(n);
            }
            this.queueOrCommitCheckpoint(n.getSession(), n.getPath());
        } else {
            LOGGER.trace("No implicit version checkpoint set for {}", (Object)n.getPath());
        }
    }

    public Collection<String> createVersion(Workspace workspace, Collection<String> paths) throws RepositoryException {
        HashSet<String> versions = new HashSet<String>();
        for (String absPath : paths) {
            Node node = workspace.getSession().getNode(absPath);
            if (!VersionServiceImpl.isVersioningEnabled(node)) {
                this.enableVersioning(node);
            }
            versions.add(this.checkpoint(workspace, absPath));
        }
        return versions;
    }

    public void revertToVersion(Workspace workspace, String absPath, String label) throws RepositoryException {
        Version v = this.getVersionForLabel(workspace, absPath, label);
        if (v == null) {
            throw new PathNotFoundException("Unknown version \"" + label + "\"!");
        }
        VersionManager versionManager = workspace.getVersionManager();
        versionManager.checkin(absPath);
        versionManager.restore(v, true);
        versionManager.checkout(absPath);
        this.nodeUpdated(workspace.getSession(), absPath);
    }

    public void removeVersion(Workspace workspace, String absPath, String label) throws RepositoryException {
        String[] versionLabels;
        Version v = this.getVersionForLabel(workspace, absPath, label);
        if (v == null) {
            throw new PathNotFoundException("Unknown version \"" + label + "\"!");
        }
        if (workspace.getVersionManager().getBaseVersion(absPath).equals(v)) {
            throw new VersionException("Cannot remove current version");
        }
        VersionHistory history = v.getContainingHistory();
        for (String versionLabel : versionLabels = history.getVersionLabels(v)) {
            LOGGER.debug("Removing label: {}", (Object)versionLabel);
            history.removeVersionLabel(versionLabel);
        }
        history.removeVersion(v.getName());
    }

    private Version getVersionForLabel(Workspace workspace, String absPath, String label) throws RepositoryException {
        VersionHistory history = workspace.getVersionManager().getVersionHistory(absPath);
        if (history.hasVersionLabel(label)) {
            return history.getVersionByLabel(label);
        }
        VersionIterator versionIt = history.getAllVersions();
        if (versionIt == null) {
            return null;
        }
        while (versionIt.hasNext()) {
            Version v = versionIt.nextVersion();
            if (!v.getFrozenNode().getIdentifier().equals(label)) continue;
            return v;
        }
        return null;
    }

    private static boolean isVersioningEnabled(Node n) throws RepositoryException {
        return n.isNodeType(VERSIONABLE);
    }

    private void enableVersioning(Node node) throws RepositoryException {
        node.addMixin(VERSIONABLE);
        node.getSession().save();
    }

    private static boolean isImplicitVersioningEnabled(Node n) throws RepositoryException {
        if (!n.hasProperty(VERSION_POLICY)) {
            return false;
        }
        Property p = n.getProperty(VERSION_POLICY);
        return FedoraTypesUtils.propertyContains(p, AUTO_VERSION);
    }

    private void queueOrCommitCheckpoint(Session session, String absPath) throws RepositoryException {
        String txId = TransactionServiceImpl.getCurrentTransactionId(session);
        if (txId == null) {
            this.checkpoint(session.getWorkspace(), absPath);
        } else {
            this.queueCheckpoint(session, absPath);
        }
    }

    private String checkpoint(Workspace workspace, String absPath) throws RepositoryException {
        LOGGER.trace("Setting implicit version checkpoint set for {}", (Object)absPath);
        Version v = workspace.getVersionManager().checkpoint(absPath);
        return v == null ? null : v.getFrozenNode().getIdentifier();
    }

    private void queueCheckpoint(Session session, String absPath) throws TransactionMissingException {
        Transaction tx = this.txService.getTransaction(session);
        LOGGER.trace("Queuing implicit version checkpoint set for {}", (Object)absPath);
        tx.addPathToVersion(absPath);
    }

    public void checkpoint(Node node) throws RepositoryException {
        Preconditions.checkNotNull((Object)node, (Object)"Cannot checkpoint null nodes");
        Session session = node.getSession();
        String absPath = node.getPath();
        if (node.isNodeType(VERSIONABLE)) {
            LOGGER.trace("Setting checkpoint for {}", (Object)absPath);
            String txId = TransactionServiceImpl.getCurrentTransactionId(session);
            if (txId != null) {
                Transaction tx = this.txService.getTransaction(session);
                tx.addPathToVersion(absPath);
            } else {
                session.getWorkspace().getVersionManager().checkpoint(absPath);
            }
        } else {
            LOGGER.trace("No checkpoint set for unversionable {}", (Object)absPath);
        }
    }

    public void setTxService(TransactionService txService) {
        this.txService = txService;
    }
}

