/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils.iterators;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.fcrepo.kernel.impl.rdf.JcrRdfTools;
import org.fcrepo.kernel.impl.rdf.ManagedRdf;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.fcrepo.kernel.utils.iterators.RdfStreamConsumer;
import org.modeshape.jcr.api.JcrTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PersistingRdfStreamConsumer
implements RdfStreamConsumer {
    private final RdfStream stream;
    private final IdentifierTranslator idTranslator;
    private final Session session;
    protected final Predicate<Triple> isFedoraSubjectTriple;
    private final Map<AnonId, Resource> skolemizedBnodeMap;
    private final JcrRdfTools jcrRdfTools;
    private static final JcrTools jcrTools = new JcrTools();
    private static final Model m = ModelFactory.createDefaultModel();
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistingRdfStreamConsumer.class);

    public PersistingRdfStreamConsumer(final IdentifierTranslator graphSubjects, Session session, RdfStream stream) {
        this.idTranslator = graphSubjects;
        this.jcrRdfTools = JcrRdfTools.withContext(graphSubjects, session);
        this.isFedoraSubjectTriple = new Predicate<Triple>(){

            public boolean apply(Triple t) {
                boolean result;
                boolean bl = result = graphSubjects.isFedoraGraphSubject(m.asStatement(t).getSubject()) || t.getSubject().isBlank();
                if (result) {
                    LOGGER.debug("Discovered a Fedora-relevant subject in triple: {}.", (Object)t);
                } else {
                    LOGGER.debug("Ignoring triple: {}.", (Object)t);
                }
                return result;
            }
        };
        this.skolemizedBnodeMap = new HashMap<AnonId, Resource>();
        this.stream = stream.withThisContext(stream.filter(Predicates.and((Predicate)Predicates.not(ManagedRdf.isManagedTriple), this.isFedoraSubjectTriple)).iterator());
        this.session = session;
    }

    public void consume() throws RepositoryException {
        while (this.stream.hasNext()) {
            Statement t = m.asStatement((Triple)this.stream.next());
            LOGGER.debug("Operating triple {}.", (Object)t);
            if (t.getObject().isAnon()) {
                t = t.changeObject((RDFNode)this.getSkolemizedResource(t.getObject()));
            }
            if (t.getSubject().isAnon()) {
                t = m.createStatement(this.getSkolemizedResource((RDFNode)t.getSubject()), t.getPredicate(), t.getObject());
            }
            LOGGER.trace("Operating on skolemized triple {}.", (Object)t);
            this.operateOnTriple(t);
        }
    }

    private Resource getSkolemizedResource(RDFNode resource) throws RepositoryException {
        AnonId id = resource.asResource().getId();
        if (!this.skolemizedBnodeMap.containsKey(id)) {
            Node orCreateNode = jcrTools.findOrCreateNode(this.session, "/.well-known/genid/" + UUID.randomUUID().toString());
            orCreateNode.addMixin("fedora:blanknode");
            Resource skolemizedSubject = this.idTranslator().getSubject(orCreateNode.getPath());
            this.skolemizedBnodeMap.put(id, skolemizedSubject);
        }
        return this.skolemizedBnodeMap.get(id);
    }

    protected void operateOnTriple(Statement t) throws RepositoryException {
        Resource subject = t.getSubject();
        Node subjectNode = this.session().getNode(this.idTranslator().getPathFromSubject(subject));
        if (t.getPredicate().equals(RDF.type) && t.getObject().isResource()) {
            Resource mixinResource = t.getObject().asResource();
            if (!ManagedRdf.isManagedMixin.apply((Object)mixinResource)) {
                LOGGER.debug("Operating on node: {} with mixin: {}.", (Object)subjectNode, (Object)mixinResource);
                this.operateOnMixin(mixinResource, subjectNode);
            } else {
                LOGGER.debug("Found repository-managed mixin on which we will not operate.");
            }
        } else {
            LOGGER.debug("Operating on node: {} from triple: {}.", (Object)subjectNode, (Object)t);
            this.operateOnProperty(t, subjectNode);
        }
    }

    protected String getPropertyNameFromPredicate(Node subjectNode, Property predicate) throws RepositoryException {
        return this.jcrRdfTools().getPropertyNameFromPredicate(subjectNode, predicate, (Map<String, String>)this.stream.namespaces());
    }

    protected String getPropertyNameFromPredicate(Node subjectNode, Resource predicate) throws RepositoryException {
        return this.jcrRdfTools().getPropertyNameFromPredicate(subjectNode, predicate, (Map<String, String>)this.stream.namespaces());
    }

    protected Value createValue(Node subjectNode, RDFNode object, Integer propertyType) throws RepositoryException {
        return this.jcrRdfTools().createValue(subjectNode, object, (int)propertyType);
    }

    protected abstract void operateOnProperty(Statement var1, Node var2) throws RepositoryException;

    protected abstract void operateOnMixin(Resource var1, Node var2) throws RepositoryException;

    public ListenableFuture<Boolean> consumeAsync() {
        SettableFuture result = SettableFuture.create();
        try {
            this.consume();
            result.set((Object)true);
        }
        catch (Exception e) {
            LOGGER.warn("Got exception consuming RDF stream", (Throwable)e);
            result.setException((Throwable)e);
            result.set((Object)false);
        }
        return result;
    }

    public RdfStream stream() {
        return this.stream;
    }

    public IdentifierTranslator idTranslator() {
        return this.idTranslator;
    }

    public Session session() {
        return this.session;
    }

    public JcrRdfTools jcrRdfTools() {
        return this.jcrRdfTools;
    }
}

