/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.security.AccessControlException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.xml.XmlCharacters;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.ValueFormatException;

@NotThreadSafe
class JcrNamespaceRegistry
implements org.modeshape.jcr.api.NamespaceRegistry {
    static final String DEFAULT_NAMESPACE_PREFIX = "";
    static final String DEFAULT_NAMESPACE_URI = "";
    static final String XML_NAMESPACE_PREFIX = "xml";
    static final String XML_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    static final String XMLNS_NAMESPACE_PREFIX = "xmlns";
    static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    static final String XML_SCHEMA_NAMESPACE_PREFIX = "xs";
    static final String XML_SCHEMA_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema";
    static final String XML_SCHEMA_INSTANCE_NAMESPACE_PREFIX = "xsi";
    static final String XML_SCHEMA_INSTANCE_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    static final Set<String> STANDARD_BUILT_IN_PREFIXES;
    static final Set<String> STANDARD_BUILT_IN_URIS;
    static final Map<String, String> STANDARD_BUILT_IN_NAMESPACES_BY_PREFIX;
    static final Map<String, String> STANDARD_BUILT_IN_PREFIXES_BY_NAMESPACE;
    private final Behavior behavior;
    private final NamespaceRegistry registry;
    private final NamespaceRegistry workspaceRegistry;
    private final JcrSession session;

    protected JcrNamespaceRegistry(NamespaceRegistry workspaceRegistry, JcrSession session) {
        this(Behavior.WORKSPACE, null, workspaceRegistry, session);
    }

    JcrNamespaceRegistry(Behavior behavior, NamespaceRegistry localRegistry, NamespaceRegistry workspaceRegistry, JcrSession session) {
        this.behavior = behavior;
        this.registry = localRegistry != null ? localRegistry : workspaceRegistry;
        this.workspaceRegistry = workspaceRegistry;
        this.session = session;
        assert (this.behavior != null);
        assert (this.registry != null);
        assert (this.workspaceRegistry != null);
        assert (this.session != null);
    }

    protected final void checkSession() throws RepositoryException {
        this.session.checkLive();
    }

    public String getPrefix(String uri) throws NamespaceException, RepositoryException {
        String prefix;
        this.checkSession();
        if (this.behavior == Behavior.WORKSPACE && (prefix = STANDARD_BUILT_IN_PREFIXES_BY_NAMESPACE.get(uri)) != null) {
            return prefix;
        }
        prefix = this.registry.getPrefixForNamespaceUri(uri, false);
        if (prefix == null) {
            throw new NamespaceException(JcrI18n.noNamespaceWithUri.text(new Object[]{uri}));
        }
        return prefix;
    }

    public String[] getPrefixes() throws RepositoryException {
        this.checkSession();
        Set namespaces = this.registry.getNamespaces();
        String[] prefixes = new String[namespaces.size()];
        int i = 0;
        for (NamespaceRegistry.Namespace namespace : namespaces) {
            prefixes[i++] = namespace.getPrefix();
        }
        return prefixes;
    }

    public String getURI(String prefix) throws NamespaceException, RepositoryException {
        String uri;
        this.checkSession();
        if (this.behavior == Behavior.WORKSPACE && (uri = STANDARD_BUILT_IN_NAMESPACES_BY_PREFIX.get(prefix)) != null) {
            return uri;
        }
        uri = this.registry.getNamespaceForPrefix(prefix);
        if (uri == null) {
            throw new NamespaceException(JcrI18n.noNamespaceWithPrefix.text(new Object[]{prefix}));
        }
        return uri;
    }

    public String[] getURIs() throws RepositoryException {
        this.checkSession();
        Set namespaces = this.registry.getNamespaces();
        String[] uris = new String[namespaces.size()];
        int i = 0;
        for (NamespaceRegistry.Namespace namespace : namespaces) {
            uris[i++] = namespace.getNamespaceUri();
        }
        return uris;
    }

    public boolean isRegisteredPrefix(String prefix) {
        return this.registry.getNamespaceForPrefix(prefix) != null;
    }

    public boolean isRegisteredUri(String uri) {
        return this.registry.isRegisteredNamespaceUri(uri);
    }

    public synchronized void registerNamespace(String prefix, String uri) throws NamespaceException, RepositoryException {
        CheckArg.isNotNull((Object)prefix, (String)"prefix");
        CheckArg.isNotNull((Object)uri, (String)"uri");
        this.checkSession();
        if ("".equals(prefix) || "".equals(uri)) {
            throw new NamespaceException(JcrI18n.unableToChangeTheDefaultNamespace.text(new Object[0]));
        }
        if (prefix.toLowerCase().startsWith(XML_NAMESPACE_PREFIX)) {
            throw new NamespaceException(JcrI18n.unableToRegisterNamespaceUsingXmlPrefix.text(new Object[]{prefix, uri}));
        }
        if (!XmlCharacters.isValidNcName((String)prefix)) {
            throw new NamespaceException(JcrI18n.unableToRegisterNamespaceWithInvalidPrefix.text(new Object[]{prefix, uri}));
        }
        try {
            this.session.nameFactory().create(prefix);
        }
        catch (ValueFormatException e) {
            throw new NamespaceException(JcrI18n.unableToRegisterNamespaceWithInvalidPrefix.text(new Object[]{prefix, uri}));
        }
        String existingPrefixForURI = this.registry.getPrefixForNamespaceUri(uri, false);
        if (prefix.equals(existingPrefixForURI)) {
            return;
        }
        boolean global = false;
        switch (this.behavior) {
            case SESSION: {
                String existingUriForPrefix = this.registry.getNamespaceForPrefix(prefix);
                if (existingUriForPrefix != null) {
                    this.registry.unregister(existingUriForPrefix);
                }
                this.registry.unregister(uri);
                break;
            }
            case WORKSPACE: {
                global = true;
                if (STANDARD_BUILT_IN_PREFIXES.contains(prefix)) {
                    throw new NamespaceException(JcrI18n.unableToRegisterReservedNamespacePrefix.text(new Object[]{prefix, uri}));
                }
                if (STANDARD_BUILT_IN_URIS.contains(uri)) {
                    throw new NamespaceException(JcrI18n.unableToRegisterReservedNamespaceUri.text(new Object[]{prefix, uri}));
                }
                try {
                    this.session.checkWorkspacePermission(this.session.workspaceName(), "register_namespace");
                }
                catch (AccessControlException ace) {
                    throw new AccessDeniedException((Throwable)ace);
                }
                if (existingPrefixForURI != null) {
                    this.checkURINotInUse(uri);
                }
                this.registry.unregister(uri);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        try {
            this.registry.register(prefix, uri);
            this.session.signalNamespaceChanges(global);
        }
        catch (RuntimeException e) {
            throw new RepositoryException(e.getMessage(), e.getCause());
        }
    }

    public synchronized void unregisterNamespace(String prefix) throws NamespaceException, AccessDeniedException, RepositoryException {
        String uri;
        CheckArg.isNotNull((Object)prefix, (String)"prefix");
        this.checkSession();
        if (this.behavior.equals((Object)Behavior.WORKSPACE)) {
            try {
                this.session.checkWorkspacePermission(this.session.workspaceName(), "register_namespace");
            }
            catch (AccessControlException ace) {
                throw new AccessDeniedException((Throwable)ace);
            }
        }
        if ((uri = this.registry.getNamespaceForPrefix(prefix)) == null) {
            throw new NamespaceException(JcrI18n.unableToUnregisterPrefixForNamespaceThatIsNotRegistered.text(new Object[]{prefix}));
        }
        if (STANDARD_BUILT_IN_PREFIXES.contains(prefix)) {
            throw new NamespaceException(JcrI18n.unableToUnregisterReservedNamespacePrefix.text(new Object[]{prefix, uri}));
        }
        if (STANDARD_BUILT_IN_URIS.contains(uri)) {
            throw new NamespaceException(JcrI18n.unableToUnregisterReservedNamespaceUri.text(new Object[]{prefix, uri}));
        }
        this.checkURINotInUse(uri);
        boolean global = false;
        switch (this.behavior) {
            case WORKSPACE: {
                global = true;
                break;
            }
            case SESSION: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        try {
            this.registry.unregister(uri);
            this.session.signalNamespaceChanges(global);
        }
        catch (RuntimeException e) {
            throw new RepositoryException(e.getMessage(), e.getCause());
        }
    }

    private void checkURINotInUse(String uri) throws RepositoryException {
        NodeTypes nodeTypes = this.session.nodeTypes();
        for (Name nodeTypeName : nodeTypes.getAllNodeTypeNames()) {
            if (!nodeTypeName.getNamespaceUri().equals(uri)) continue;
            throw new NamespaceException(JcrI18n.unableToUnregisterPrefixForNamespaceUsedByNodeType.text(new Object[]{uri, nodeTypeName}));
        }
    }

    public String registerNamespace(String uri) throws UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        CheckArg.isNotNull((Object)uri, (String)"uri");
        this.checkSession();
        String prefix = this.registry.getPrefixForNamespaceUri(uri, false);
        if (prefix != null) {
            return prefix;
        }
        boolean global = false;
        switch (this.behavior) {
            case SESSION: {
                break;
            }
            case WORKSPACE: {
                global = true;
                try {
                    this.session.checkWorkspacePermission(this.session.workspaceName(), "register_namespace");
                    break;
                }
                catch (AccessControlException ace) {
                    throw new AccessDeniedException((Throwable)ace);
                }
            }
            default: {
                assert (false);
                break;
            }
        }
        try {
            prefix = this.registry.getPrefixForNamespaceUri(uri, true);
            this.session.signalNamespaceChanges(global);
            return prefix;
        }
        catch (RuntimeException e) {
            throw new RepositoryException(e.getMessage(), e.getCause());
        }
    }

    public String toString() {
        return this.registry.toString();
    }

    static {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("", "");
        namespaces.put("jcr", "http://www.jcp.org/jcr/1.0");
        namespaces.put("nt", "http://www.jcp.org/jcr/nt/1.0");
        namespaces.put("mix", "http://www.jcp.org/jcr/mix/1.0");
        namespaces.put("sv", "http://www.jcp.org/jcr/sv/1.0");
        namespaces.put(XML_NAMESPACE_PREFIX, XML_NAMESPACE_URI);
        namespaces.put(XMLNS_NAMESPACE_PREFIX, XMLNS_NAMESPACE_URI);
        namespaces.put(XML_SCHEMA_NAMESPACE_PREFIX, XML_SCHEMA_NAMESPACE_URI);
        namespaces.put(XML_SCHEMA_INSTANCE_NAMESPACE_PREFIX, XML_SCHEMA_INSTANCE_NAMESPACE_URI);
        namespaces.put("mode", "http://www.modeshape.org/1.0");
        HashMap<String, String> prefixes = new HashMap<String, String>();
        for (Map.Entry entry : namespaces.entrySet()) {
            String uri = (String)entry.getValue();
            String prefix = (String)entry.getKey();
            prefixes.put(uri, prefix);
        }
        STANDARD_BUILT_IN_NAMESPACES_BY_PREFIX = Collections.unmodifiableMap(namespaces);
        STANDARD_BUILT_IN_PREFIXES_BY_NAMESPACE = Collections.unmodifiableMap(prefixes);
        STANDARD_BUILT_IN_PREFIXES = Collections.unmodifiableSet(namespaces.keySet());
        STANDARD_BUILT_IN_URIS = Collections.unmodifiableSet(new HashSet(namespaces.values()));
    }

    public static enum Behavior {
        SESSION,
        WORKSPACE;

    }
}

