/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.kernel.impl.services;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.inject.Inject;
import javax.jcr.Repository;
import javax.jcr.Session;
import org.apache.tika.io.IOUtils;
import org.fcrepo.integration.kernel.impl.AbstractIT;
import org.fcrepo.kernel.models.FedoraBinary;
import org.fcrepo.kernel.services.BinaryService;
import org.fcrepo.kernel.services.ContainerService;
import org.jgroups.util.Util;
import org.junit.Test;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"/spring-test/repo.xml"})
public class BinaryServiceImplIT
extends AbstractIT {
    @Inject
    private Repository repository;
    @Inject
    ContainerService containerService;
    @Inject
    BinaryService binaryService;

    @Test
    public void testCreateDatastreamNode() throws Exception {
        Session session = this.repository.login();
        ((FedoraBinary)this.binaryService.findOrCreate(session, "/testDatastreamNode")).setContent((InputStream)new ByteArrayInputStream("asdf".getBytes()), "application/octet-stream", null, null, null);
        session.save();
        session.logout();
        session = this.repository.login();
        Util.assertTrue((boolean)session.getRootNode().hasNode("testDatastreamNode"));
        Util.assertEquals((Object)"asdf", (Object)session.getNode("/testDatastreamNode").getNode("jcr:content").getProperty("jcr:data").getString());
        session.logout();
    }

    @Test
    public void testCreateDatastreamNodeWithfilename() throws Exception {
        Session session = this.repository.login();
        ((FedoraBinary)this.binaryService.findOrCreate(session, "/testDatastreamNode")).setContent((InputStream)new ByteArrayInputStream("asdf".getBytes()), "application/octet-stream", null, "xyz.jpg", null);
        session.save();
        session.logout();
        session = this.repository.login();
        Util.assertTrue((boolean)session.getRootNode().hasNode("testDatastreamNode"));
        Util.assertEquals((Object)"xyz.jpg", (Object)session.getNode("/testDatastreamNode").getNode("jcr:content").getProperty("premis:hasOriginalName").getString());
        session.logout();
    }

    @Test
    public void testGetDatastreamContentInputStream() throws Exception {
        Session session = this.repository.login();
        ByteArrayInputStream is = new ByteArrayInputStream("asdf".getBytes());
        this.containerService.findOrCreate(session, "/testDatastreamServiceObject");
        ((FedoraBinary)this.binaryService.findOrCreate(session, "/testDatastreamServiceObject/testDatastreamNode")).setContent((InputStream)is, "application/octet-stream", null, null, null);
        session.save();
        session.logout();
        session = this.repository.login();
        FedoraBinary binary = (FedoraBinary)this.binaryService.findOrCreate(session, "/testDatastreamServiceObject/testDatastreamNode");
        Util.assertEquals((Object)"asdf", (Object)IOUtils.toString((InputStream)binary.getContent(), (String)"UTF-8"));
        session.logout();
    }
}

