/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.apache.tika.io.IOUtils;
import org.fcrepo.jcr.FedoraJcrTypes;
import org.fcrepo.kernel.exception.InvalidChecksumException;
import org.fcrepo.kernel.impl.FedoraBinaryImpl;
import org.fcrepo.kernel.impl.utils.TestHelpers;
import org.fcrepo.kernel.models.FedoraBinary;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.ValueFactory;

public class FedoraBinaryImplTest
implements FedoraJcrTypes {
    private static final String testDsId = "testDs";
    private FedoraBinary testObj;
    @Mock
    private Session mockSession;
    @Mock
    private Node mockRootNode;
    @Mock
    private Node mockDsNode;
    @Mock
    private InputStream mockStream;
    @Mock
    private ValueFactory mockVF;
    @Mock
    private NodeType mockDsNodeType;
    @Mock
    private Node mockContent;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        NodeType[] nodeTypes = new NodeType[]{this.mockDsNodeType};
        try {
            Mockito.when((Object)this.mockDsNodeType.getName()).thenReturn((Object)"fedora:NonRdfSourceDescription");
            Mockito.when((Object)this.mockDsNode.getMixinNodeTypes()).thenReturn((Object)nodeTypes);
            Mockito.when((Object)this.mockDsNode.getName()).thenReturn((Object)testDsId);
            Mockito.when((Object)this.mockContent.getSession()).thenReturn((Object)this.mockSession);
            NodeType mockNodeType = (NodeType)Mockito.mock(NodeType.class);
            Mockito.when((Object)mockNodeType.getName()).thenReturn((Object)"nt:file");
            Mockito.when((Object)this.mockDsNode.getPrimaryNodeType()).thenReturn((Object)mockNodeType);
            this.testObj = new FedoraBinaryImpl(this.mockContent);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void tearDown() {
        this.mockSession = null;
        this.mockRootNode = null;
        this.mockDsNode = null;
    }

    @Test
    public void testGetNode() {
        Assert.assertEquals((Object)this.testObj.getNode(), (Object)this.mockContent);
    }

    @Test
    public void testGetContent() throws RepositoryException, IOException {
        String expected = "asdf";
        TestHelpers.getContentNodeMock(this.mockContent, "asdf");
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)this.mockContent);
        String actual = IOUtils.toString((InputStream)this.testObj.getContent());
        Assert.assertEquals((Object)"asdf", (Object)actual);
        ((Node)Mockito.verify((Object)this.mockContent)).getProperty("jcr:data");
    }

    @Test
    public void testGetBinaryContent() throws RepositoryException {
        javax.jcr.Binary mockBinary = (javax.jcr.Binary)Mockito.mock(javax.jcr.Binary.class);
        Property mockProperty = (Property)Mockito.mock(Property.class);
        TestHelpers.getContentNodeMock(this.mockContent, "abc");
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)this.mockContent);
        Mockito.when((Object)this.mockContent.getProperty("jcr:data")).thenReturn((Object)mockProperty);
        Mockito.when((Object)mockProperty.getBinary()).thenReturn((Object)mockBinary);
        Assert.assertEquals((Object)mockBinary, (Object)this.testObj.getBinaryContent());
    }

    @Test
    public void testSetContent() throws RepositoryException, InvalidChecksumException {
        Binary mockBin = (Binary)Mockito.mock(Binary.class);
        TestHelpers.getContentNodeMock(this.mockContent, 8);
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)this.mockContent);
        Mockito.when((Object)this.mockDsNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getValueFactory()).thenReturn((Object)this.mockVF);
        Mockito.when((Object)this.mockVF.createBinary((InputStream)Matchers.any(InputStream.class), (String)Matchers.any(String.class))).thenReturn((Object)mockBin);
        Property mockData = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)this.mockContent.canAddMixin("fedora:Binary")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContent.setProperty("jcr:data", (javax.jcr.Binary)mockBin)).thenReturn((Object)mockData);
        Mockito.when((Object)this.mockContent.getProperty("jcr:data")).thenReturn((Object)mockData);
        Mockito.when((Object)mockData.getBinary()).thenReturn((Object)mockBin);
        this.testObj.setContent(this.mockStream, null, null, null, null);
    }

    @Test
    public void testSetContentWithFilename() throws RepositoryException, InvalidChecksumException {
        Binary mockBin = (Binary)Mockito.mock(Binary.class);
        TestHelpers.getContentNodeMock(this.mockContent, 8);
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)this.mockContent);
        Mockito.when((Object)this.mockDsNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getValueFactory()).thenReturn((Object)this.mockVF);
        Mockito.when((Object)this.mockVF.createBinary((InputStream)Matchers.any(InputStream.class), (String)Matchers.any(String.class))).thenReturn((Object)mockBin);
        Property mockData = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)this.mockContent.canAddMixin("fedora:Binary")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContent.setProperty("jcr:data", (javax.jcr.Binary)mockBin)).thenReturn((Object)mockData);
        Mockito.when((Object)this.mockContent.getProperty("jcr:data")).thenReturn((Object)mockData);
        Mockito.when((Object)mockData.getBinary()).thenReturn((Object)mockBin);
        this.testObj.setContent(this.mockStream, null, null, "xyz", null);
        ((Node)Mockito.verify((Object)this.mockContent)).setProperty("premis:hasOriginalName", "xyz");
    }

    @Test(expected=InvalidChecksumException.class)
    public void testSetContentWithChecksumMismatch() throws RepositoryException, InvalidChecksumException, URISyntaxException {
        Binary mockBin = (Binary)Mockito.mock(Binary.class);
        TestHelpers.getContentNodeMock(this.mockContent, 8);
        Mockito.when((Object)this.mockDsNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)this.mockContent);
        Mockito.when((Object)this.mockSession.getValueFactory()).thenReturn((Object)this.mockVF);
        Mockito.when((Object)this.mockVF.createBinary((InputStream)Matchers.any(InputStream.class), (String)Matchers.any(String.class))).thenReturn((Object)mockBin);
        Property mockData = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)this.mockContent.canAddMixin("fedora:Binary")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContent.setProperty("jcr:data", (javax.jcr.Binary)mockBin)).thenReturn((Object)mockData);
        Mockito.when((Object)this.mockContent.getProperty("jcr:data")).thenReturn((Object)mockData);
        Mockito.when((Object)mockData.getBinary()).thenReturn((Object)mockBin);
        this.testObj.setContent(this.mockStream, null, new URI("urn:sha1:xyz"), null, null);
    }

    @Test
    public void getContentSize() throws RepositoryException {
        int expectedContentLength = 2;
        TestHelpers.getContentNodeMock(this.mockContent, 2);
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)this.mockContent);
        long actual = this.testObj.getContentSize();
        ((Node)Mockito.verify((Object)this.mockContent)).getProperty("premis:hasSize");
        Assert.assertEquals((long)2L, (long)actual);
    }

    @Test
    public void getContentDigest() throws RepositoryException {
        String content = "asdf";
        URI expected = URI.create(TestHelpers.checksumString("asdf"));
        TestHelpers.getContentNodeMock(this.mockContent, "asdf");
        URI actual = this.testObj.getContentDigest();
        Assert.assertEquals((Object)expected, (Object)actual);
        ((Node)Mockito.verify((Object)this.mockContent)).getProperty("fedora:digest");
    }

    @Test
    public void testGetMimeType() throws RepositoryException {
        TestHelpers.getContentNodeMock(this.mockContent, 8);
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)this.mockContent);
        Mockito.when((Object)this.mockDsNode.hasNode("jcr:content")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContent.hasProperty("jcr:mimeType")).thenReturn((Object)true);
        Property mockProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)this.mockContent.getProperty("jcr:mimeType")).thenReturn((Object)mockProperty);
        Mockito.when((Object)mockProperty.getString()).thenReturn((Object)"application/x-mime-type");
        Assert.assertEquals((Object)"application/x-mime-type", (Object)this.testObj.getMimeType());
    }

    @Test
    public void testGetMimeTypeWithNoContent() throws RepositoryException {
        Mockito.when((Object)this.mockDsNode.hasNode("jcr:content")).thenReturn((Object)false);
        Assert.assertEquals((Object)"application/octet-stream", (Object)this.testObj.getMimeType());
    }

    @Test
    public void testGetMimeTypeWithDefault() throws RepositoryException {
        TestHelpers.getContentNodeMock(this.mockContent, 8);
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)this.mockContent);
        Mockito.when((Object)this.mockDsNode.hasNode("jcr:content")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContent.hasProperty("jcr:mimeType")).thenReturn((Object)false);
        Assert.assertEquals((Object)"application/octet-stream", (Object)this.testObj.getMimeType());
    }

    @Test
    public void testGetCreatedDate() throws RepositoryException {
        Date expected = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(expected);
        Property mockProp = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)mockProp.getDate()).thenReturn((Object)cal);
        Mockito.when((Object)this.mockContent.hasProperty("jcr:created")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContent.getProperty("jcr:created")).thenReturn((Object)mockProp);
        Date actual = this.testObj.getCreatedDate();
        Assert.assertEquals((long)expected.getTime(), (long)actual.getTime());
    }

    @Test
    public void testGetLastModifiedDate() throws RepositoryException {
        Date expected = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(expected);
        Property mockProp = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)mockProp.getDate()).thenReturn((Object)cal);
        Mockito.when((Object)this.mockContent.hasProperty("jcr:lastModified")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContent.getProperty("jcr:lastModified")).thenReturn((Object)mockProp);
        Date actual = this.testObj.getLastModifiedDate();
        Assert.assertEquals((long)expected.getTime(), (long)actual.getTime());
    }
}

