/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.identifiers;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.fcrepo.kernel.impl.identifiers.HttpPidMinter;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class HttpPidMinterTest {
    @Test
    public void testMintPid() throws Exception {
        HttpPidMinter testMinter = new HttpPidMinter("http://localhost/minter", "POST", "", "", ".*/", "");
        HttpClient mockClient = (HttpClient)Mockito.mock(HttpClient.class);
        HttpResponse mockResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        ByteArrayEntity entity = new ByteArrayEntity("/foo/bar/baz".getBytes());
        testMinter.client = mockClient;
        Mockito.when((Object)mockClient.execute((HttpUriRequest)Matchers.isA(HttpUriRequest.class))).thenReturn((Object)mockResponse);
        Mockito.when((Object)mockResponse.getEntity()).thenReturn((Object)entity);
        String pid = testMinter.mintPid();
        ((HttpClient)Mockito.verify((Object)mockClient)).execute((HttpUriRequest)Matchers.isA(HttpUriRequest.class));
        Assert.assertEquals((Object)pid, (Object)"baz");
    }

    @Test
    public void testMintPidXPath() throws Exception {
        HttpPidMinter testMinter = new HttpPidMinter("http://localhost/minter", "POST", "", "", "", "/test/id");
        HttpClient mockClient = (HttpClient)Mockito.mock(HttpClient.class);
        HttpResponse mockResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        ByteArrayEntity entity = new ByteArrayEntity("<test><id>baz</id></test>".getBytes());
        testMinter.client = mockClient;
        Mockito.when((Object)mockClient.execute((HttpUriRequest)Matchers.isA(HttpUriRequest.class))).thenReturn((Object)mockResponse);
        Mockito.when((Object)mockResponse.getEntity()).thenReturn((Object)entity);
        String pid = testMinter.mintPid();
        ((HttpClient)Mockito.verify((Object)mockClient)).execute((HttpUriRequest)Matchers.isA(HttpUriRequest.class));
        Assert.assertEquals((Object)pid, (Object)"baz");
    }

    @Test
    public void testHttpClient() {
        HttpPidMinter testMinter = new HttpPidMinter("http://localhost/minter", "POST", "user", "pass", "", "");
        HttpClient client = testMinter.buildClient();
        Assert.assertNotNull((Object)client);
    }
}

