/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.identifiers;

import java.util.regex.Pattern;
import org.fcrepo.kernel.impl.identifiers.UUIDPathMinter;
import org.junit.Assert;
import org.junit.Test;

public class UUIDPathMinterTest {
    public static final String UUID_PATTERN = "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}";
    private static final String PID_PATTERN = "[a-f0-9]{3}/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}";

    @Test
    public void testMintPid() {
        String pid = new UUIDPathMinter(3, 1).mintPid();
        Assert.assertTrue((String)"PID wasn't a UUID path", (boolean)Pattern.compile(PID_PATTERN).matcher(pid).find());
    }

    @Test
    public void testMintPidWithoutSegments() {
        String pid = new UUIDPathMinter(0, 0).mintPid();
        Assert.assertTrue((String)"PID wasn't a UUID path", (boolean)Pattern.compile(UUID_PATTERN).matcher(pid).find());
    }
}

