/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.converters;

import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.util.Collections;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.fcrepo.kernel.impl.rdf.converters.PropertyConverter;
import org.fcrepo.kernel.impl.utils.FedoraTypesUtils;
import org.fcrepo.kernel.impl.utils.JcrPropertyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.api.NamespaceRegistry;

public class PropertyConverterTest {
    public static final Map<String, String> EMPTY_NAMESPACE_MAP = Collections.emptyMap();
    @Mock
    private JcrPropertyMock mockNamespacedProperty;
    @Mock
    private Node mockNode;
    @Mock
    private Session mockSession;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private NamespaceRegistry mockNsRegistry;
    private static final String mockUri = "http://example.com/";
    private PropertyConverter testObj;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new PropertyConverter();
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getNamespaceRegistry()).thenReturn((Object)this.mockNsRegistry);
        this.mockNamespaceRegistry(this.mockNsRegistry);
    }

    @Test
    public final void shouldMapInternalReferencePropertiesToPublicUris() throws RepositoryException {
        Mockito.when((Object)this.mockNamespacedProperty.getNamespaceURI()).thenReturn((Object)"info:xyz#");
        Mockito.when((Object)this.mockNamespacedProperty.getLocalName()).thenReturn((Object)FedoraTypesUtils.getReferencePropertyName((String)"some_reference"));
        Mockito.when((Object)this.mockNamespacedProperty.getType()).thenReturn((Object)9);
        Mockito.when((Object)this.mockNamespacedProperty.getName()).thenReturn((Object)("xyz:" + FedoraTypesUtils.getReferencePropertyName((String)"some_reference")));
        Property property = (Property)this.testObj.convert((Object)this.mockNamespacedProperty);
        assert (property != null);
        Assert.assertEquals((Object)"some_reference", (Object)property.getLocalName());
    }

    @Test
    public void testGetPredicateForProperty() throws RepositoryException {
        Mockito.when((Object)this.mockNamespacedProperty.getNamespaceURI()).thenThrow(new Throwable[]{new RepositoryException()});
        try {
            this.testObj.convert((Object)this.mockNamespacedProperty);
            Assert.fail((String)"Unexpected completion after RepositoryException!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public final void shouldMapRdfPredicatesToJcrProperties() throws RepositoryException {
        Property p = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#", (String)"uuid");
        Assert.assertEquals((Object)"jcr:uuid", (Object)PropertyConverter.getPropertyNameFromPredicate((Node)this.mockNode, (Resource)p, EMPTY_NAMESPACE_MAP));
    }

    @Test
    public final void shouldReuseRegisteredNamespaces() throws RepositoryException {
        Property p = ResourceFactory.createProperty((String)mockUri, (String)"uuid");
        Assert.assertEquals((Object)"some-prefix:uuid", (Object)PropertyConverter.getPropertyNameFromPredicate((Node)this.mockNode, (Resource)p, EMPTY_NAMESPACE_MAP));
    }

    @Test
    public final void shouldRegisterUnknownUris() throws RepositoryException {
        Mockito.when((Object)this.mockNsRegistry.registerNamespace("not-registered-uri#")).thenReturn((Object)"ns001");
        Property p = ResourceFactory.createProperty((String)"not-registered-uri#", (String)"uuid");
        Assert.assertEquals((Object)"ns001:uuid", (Object)PropertyConverter.getPropertyNameFromPredicate((Node)this.mockNode, (Resource)p, EMPTY_NAMESPACE_MAP));
    }

    private void mockNamespaceRegistry(NamespaceRegistry mockRegistry) throws RepositoryException {
        Mockito.when((Object)mockRegistry.isRegisteredUri(mockUri)).thenReturn((Object)true);
        Mockito.when((Object)mockRegistry.isRegisteredUri("not-registered-uri#")).thenReturn((Object)false);
        Mockito.when((Object)mockRegistry.isRegisteredUri("http://www.jcp.org/jcr/1.0")).thenReturn((Object)true);
        Mockito.when((Object)mockRegistry.getPrefix("http://www.jcp.org/jcr/1.0")).thenReturn((Object)"jcr");
        Mockito.when((Object)mockRegistry.getPrefix(mockUri)).thenReturn((Object)"some-prefix");
        Mockito.when((Object)mockRegistry.getURI("jcr")).thenReturn((Object)"http://www.jcp.org/jcr/1.0");
        Mockito.when((Object)mockRegistry.getURI("some-prefix")).thenReturn((Object)mockUri);
        Mockito.when((Object)mockRegistry.getPrefixes()).thenReturn((Object)new String[]{"jcr", "some-prefix"});
    }
}

