/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.converters;

import com.google.common.base.Converter;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.fcrepo.kernel.impl.rdf.converters.ValueConverter;
import org.fcrepo.kernel.impl.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.models.FedoraResource;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.infinispan.schematic.document.ParsingException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.RepositoryConfiguration;

@RunWith(value=Parameterized.class)
public class ValueConverterTest {
    static Repository repo;
    private Session session;
    private Converter<Resource, FedoraResource> subjects;
    private Converter<Value, RDFNode> testObj;
    @Parameterized.Parameter(value=0)
    public RDFNode externalValue;
    private static ModeShapeEngine engine;

    @Test
    public void test() throws IOException {
        Assert.assertThat((Object)this.testObj.convert(this.testObj.reverse().convert((Object)this.externalValue)), (Matcher)this.sameValueAs(this.externalValue));
    }

    @Parameterized.Parameters
    public static Iterable<Object[]> data() {
        return Arrays.asList({ResourceFactory.createTypedLiteral((Object)"x")}, {ResourceFactory.createTypedLiteral((Object)0)}, {ResourceFactory.createTypedLiteral((Object)1L)}, {ResourceFactory.createTypedLiteral((Object)new BigDecimal("2.123"))}, {ResourceFactory.createTypedLiteral((Object)3.0)}, {ResourceFactory.createTypedLiteral((Object)3.1415)}, {ResourceFactory.createTypedLiteral((Object)Calendar.getInstance())}, {ResourceFactory.createTypedLiteral((Object)1)}, {ResourceFactory.createTypedLiteral((Object)42)}, {ResourceFactory.createTypedLiteral((String)"255", (RDFDatatype)XSDDatatype.XSDunsignedByte)}, {ResourceFactory.createTypedLiteral((String)"255", (RDFDatatype)XSDDatatype.XSDunsignedShort)}, {ResourceFactory.createTypedLiteral((String)"255", (RDFDatatype)XSDDatatype.XSDunsignedInt)}, {ResourceFactory.createTypedLiteral((String)"255", (RDFDatatype)XSDDatatype.XSDunsignedLong)}, {ResourceFactory.createTypedLiteral((String)"-255", (RDFDatatype)XSDDatatype.XSDnonPositiveInteger)}, {ResourceFactory.createTypedLiteral((String)"255", (RDFDatatype)XSDDatatype.XSDnonNegativeInteger)}, {ResourceFactory.createTypedLiteral((String)"255", (RDFDatatype)XSDDatatype.XSDpositiveInteger)}, {ResourceFactory.createTypedLiteral((String)"-255", (RDFDatatype)XSDDatatype.XSDnegativeInteger)}, {ResourceFactory.createTypedLiteral((Object)true)}, {ResourceFactory.createResource((String)"info:x")}, {ResourceFactory.createTypedLiteral((String)"2014-10-24T01:23:45Z", (RDFDatatype)XSDDatatype.XSDdateTime)}, {ResourceFactory.createTypedLiteral((String)"some-invalid-data", (RDFDatatype)XSDDatatype.XSDdateTime)}, {ResourceFactory.createTypedLiteral((String)"2014-10-24", (RDFDatatype)XSDDatatype.XSDdate)}, {ResourceFactory.createTypedLiteral((String)"01:02:03", (RDFDatatype)XSDDatatype.XSDtime)}, {ResourceFactory.createTypedLiteral((String)"---31", (RDFDatatype)XSDDatatype.XSDgDay)}, {ResourceFactory.createTypedLiteral((String)"--10", (RDFDatatype)XSDDatatype.XSDgMonth)}, {ResourceFactory.createTypedLiteral((String)"--02-29", (RDFDatatype)XSDDatatype.XSDgMonthDay)}, {ResourceFactory.createTypedLiteral((String)"2001", (RDFDatatype)XSDDatatype.XSDgYear)}, {ResourceFactory.createTypedLiteral((String)"ABCDEF", (RDFDatatype)XSDDatatype.XSDhexBinary)}, {ResourceFactory.createTypedLiteral((String)"eHl6", (RDFDatatype)XSDDatatype.XSDbase64Binary)}, {ResourceFactory.createTypedLiteral((String)"eHl6", (RDFDatatype)XSDDatatype.XSDnormalizedString)}, {ResourceFactory.createTypedLiteral((String)"some:uri", (RDFDatatype)XSDDatatype.XSDanyURI)}, {ResourceFactory.createTypedLiteral((String)"tokenize this", (RDFDatatype)XSDDatatype.XSDtoken)}, {ResourceFactory.createTypedLiteral((String)"name", (RDFDatatype)XSDDatatype.XSDName)}, {ResourceFactory.createTypedLiteral((String)"qname", (RDFDatatype)XSDDatatype.XSDQName)}, {ResourceFactory.createTypedLiteral((String)"en-us", (RDFDatatype)XSDDatatype.XSDlanguage)}, {ResourceFactory.createTypedLiteral((String)"name", (RDFDatatype)XSDDatatype.XSDNMTOKEN)}, {ResourceFactory.createTypedLiteral((String)"some-id", (RDFDatatype)XSDDatatype.XSDID)}, {ResourceFactory.createTypedLiteral((String)"ncname", (RDFDatatype)XSDDatatype.XSDNCName)}, {ResourceFactory.createTypedLiteral((Object)Float.valueOf(2.0123f))}, {ResourceFactory.createLangLiteral((String)"xyz", (String)"de")});
    }

    @Before
    public void setUp() throws IOException, RepositoryException {
        this.session = repo.login();
        this.subjects = new DefaultIdentifierTranslator(this.session);
        this.testObj = new ValueConverter(this.session, this.subjects);
    }

    private SameValueAsMatcher sameValueAs(RDFNode expected) {
        return new SameValueAsMatcher(expected);
    }

    @BeforeClass
    public static void setUpJcrRepository() throws ParsingException, FileNotFoundException, RepositoryException {
        engine = new ModeShapeEngine();
        engine.start();
        RepositoryConfiguration config = RepositoryConfiguration.read((String)"{ \"name\": \"test\" }");
        repo = engine.deploy(config);
    }

    @AfterClass
    public static void shutdownJcr() {
        engine.shutdown();
    }

    class SameValueAsMatcher
    extends BaseMatcher<RDFNode> {
        private RDFNode expected;

        SameValueAsMatcher(RDFNode expected) {
            this.expected = expected;
        }

        public void describeTo(Description description) {
            description.appendText("is <" + this.expected + ">");
        }

        public boolean matches(Object o) {
            if (!(o instanceof RDFNode)) {
                return false;
            }
            RDFNode object = (RDFNode)o;
            if (this.expected.isLiteral() && object.isLiteral()) {
                return this.expected.asLiteral().sameValueAs(object.asLiteral()) || this.expected.toString().equals(object.toString());
            }
            return object.equals(this.expected);
        }
    }
}

