/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.rdf.impl.ContentRdfContext;
import org.fcrepo.kernel.impl.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.models.FedoraBinary;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.models.NonRdfSourceDescription;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentRdfContextTest {
    private Resource mockContentSubject;
    private Resource mockSubject;
    private static final String mockNodeTypePrefix = "jcr";
    private static final String mockNodeName = "mockNode";
    @Mock
    private NonRdfSourceDescription mockResource;
    @Mock
    private Node mockNode;
    @Mock
    private FedoraBinary mockBinary;
    @Mock
    private Node mockBinaryNode;
    @Mock
    private NodeType mockNodeType;
    private IdentifierConverter<Resource, FedoraResource> idTranslator;
    @Mock
    private Session mockSession;
    @Mock
    private Repository mockRepository;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private NamespaceRegistry mockNamespaceRegistry;
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentRdfContextTest.class);

    @Test
    public void testForLowLevelStorageTriples() throws IOException {
        Model results = new ContentRdfContext((FedoraResource)this.mockResource, this.idTranslator).asModel();
        ContentRdfContextTest.logRdf("Retrieved RDF for testForLowLevelStorageTriples():", results);
        Assert.assertTrue((String)"Didn't find triple showing node has content!", (boolean)results.contains(this.mockSubject, RdfLexicon.DESCRIBES, (RDFNode)this.mockContentSubject));
    }

    @Test
    public void testFedoraBinaryTriples() throws IOException {
        Model results = new ContentRdfContext((FedoraResource)this.mockBinary, this.idTranslator).asModel();
        Assert.assertTrue((String)"Didn't find triple showing content has node!", (boolean)results.contains(this.mockContentSubject, RdfLexicon.DESCRIBED_BY, (RDFNode)this.mockSubject));
    }

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockBinary.getNode()).thenReturn((Object)this.mockBinaryNode);
        Mockito.when((Object)this.mockBinary.getDescription()).thenReturn((Object)this.mockResource);
        Mockito.when((Object)this.mockBinaryNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockResource.getNode()).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockResource.getPath()).thenReturn((Object)"/mockNode");
        Mockito.when((Object)this.mockSession.getRepository()).thenReturn((Object)this.mockRepository);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getNamespaceRegistry()).thenReturn((Object)this.mockNamespaceRegistry);
        Mockito.when((Object)this.mockNamespaceRegistry.getURI(mockNodeTypePrefix)).thenReturn((Object)"http://www.jcp.org/jcr/1.0");
        Mockito.when((Object)this.mockResource.getDescribedResource()).thenReturn((Object)this.mockBinary);
        Mockito.when((Object)this.mockNode.hasProperties()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        Mockito.when((Object)this.mockBinaryNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        Mockito.when((Object)this.mockBinaryNode.hasProperties()).thenReturn((Object)false);
        Mockito.when((Object)this.mockBinary.getPath()).thenReturn((Object)"/mockNode/jcr:content");
        this.idTranslator = new DefaultIdentifierTranslator(this.mockSession);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockBinaryNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNodeType.getSupertypes()).thenReturn((Object)new NodeType[]{this.mockNodeType});
        Mockito.when((Object)this.mockNodeType.getName()).thenReturn((Object)"jcr:mockNode");
        this.mockSubject = (Resource)this.idTranslator.reverse().convert((Object)this.mockResource);
        this.mockContentSubject = (Resource)this.idTranslator.reverse().convert((Object)this.mockBinary);
    }

    private static void logRdf(String message, Model model) throws IOException {
        LOGGER.debug(message);
        try (StringWriter w = new StringWriter();){
            model.write((Writer)w);
            LOGGER.debug("\n" + ((Object)w).toString());
        }
    }
}

