/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.impl.rdf.impl.ReferencesRdfContext;
import org.fcrepo.kernel.impl.testutilities.TestPropertyIterator;
import org.fcrepo.kernel.models.FedoraResource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ReferencesRdfContextTest {
    @Mock
    private Session mockSession;
    @Mock
    private FedoraResource mockResource;
    @Mock
    private Node mockNode;
    private DefaultIdentifierTranslator translator;
    private ReferencesRdfContext testObj;
    private PropertyIterator weakReferencesProperties;
    private PropertyIterator strongReferencesProperties;
    @Mock
    private Property mockWeakProperty;
    @Mock
    private Property mockStrongProperty;
    @Mock
    private Node mockPropertyParent;
    @Mock
    private Value mockWeakValue;
    @Mock
    private Value mockStrongValue;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        this.translator = new DefaultIdentifierTranslator(this.mockSession);
        Mockito.when((Object)this.mockResource.getNode()).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockResource.getPath()).thenReturn((Object)"/a");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/a");
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getNodeByIdentifier("uuid")).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockPropertyParent.getPath()).thenReturn((Object)"/b");
        Mockito.when((Object)this.mockWeakProperty.getName()).thenReturn((Object)"info:weak");
        Mockito.when((Object)this.mockWeakProperty.getParent()).thenReturn((Object)this.mockPropertyParent);
        Mockito.when((Object)this.mockWeakProperty.getValue()).thenReturn((Object)this.mockWeakValue);
        Mockito.when((Object)this.mockWeakValue.getType()).thenReturn((Object)10);
        Mockito.when((Object)this.mockWeakValue.getString()).thenReturn((Object)"uuid");
        Mockito.when((Object)this.mockStrongProperty.getName()).thenReturn((Object)"info:strong");
        Mockito.when((Object)this.mockStrongProperty.getParent()).thenReturn((Object)this.mockPropertyParent);
        Mockito.when((Object)this.mockStrongProperty.getValue()).thenReturn((Object)this.mockStrongValue);
        Mockito.when((Object)this.mockStrongValue.getType()).thenReturn((Object)9);
        Mockito.when((Object)this.mockStrongValue.getString()).thenReturn((Object)"uuid");
        this.weakReferencesProperties = new TestPropertyIterator(this.mockWeakProperty);
        Mockito.when((Object)this.mockNode.getWeakReferences()).thenReturn((Object)this.weakReferencesProperties);
        this.strongReferencesProperties = new TestPropertyIterator(this.mockStrongProperty);
        Mockito.when((Object)this.mockNode.getReferences()).thenReturn((Object)this.strongReferencesProperties);
        this.testObj = new ReferencesRdfContext(this.mockResource, (IdentifierConverter)this.translator);
    }

    @Test
    public void testStrongReferences() {
        Model model = this.testObj.asModel();
        Assert.assertTrue((boolean)model.contains(ResourceFactory.createResource((String)"info:fedora/b"), ResourceFactory.createProperty((String)"info:strong"), (RDFNode)ResourceFactory.createResource((String)"info:fedora/a")));
    }

    @Test
    public void testWeakReferences() {
        Model model = this.testObj.asModel();
        Assert.assertTrue((boolean)model.contains(ResourceFactory.createResource((String)"info:fedora/b"), ResourceFactory.createProperty((String)"info:weak"), (RDFNode)ResourceFactory.createResource((String)"info:fedora/a")));
    }
}

