/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.exception.ResourceTypeException;
import org.fcrepo.kernel.impl.services.BinaryServiceImpl;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class BinaryServiceImplTest {
    private BinaryServiceImpl testObj;
    @Mock
    private Session mockSession;
    @Mock
    private Node mockDsNode;
    @Mock
    private Node mockNode;
    @Mock
    private Node mockRoot;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new BinaryServiceImpl();
        Mockito.when((Object)this.mockSession.getRootNode()).thenReturn((Object)this.mockRoot);
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockDsNode.getParent()).thenReturn((Object)this.mockRoot);
        Mockito.when((Object)this.mockRoot.isNew()).thenReturn((Object)false);
    }

    @Test
    public void testFindOrCreateBinary() throws Exception {
        String testPath = "/foo/bar";
        Mockito.when((Object)this.mockRoot.getNode("/foo/bar".substring(1))).thenReturn((Object)this.mockDsNode);
        Mockito.when((Object)this.mockNode.isNodeType("fedora:Binary")).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNode("/")).thenReturn((Object)this.mockRoot);
        this.testObj.findOrCreate(this.mockSession, "/foo/bar");
        ((Node)Mockito.verify((Object)this.mockRoot)).getNode("/foo/bar".substring(1));
    }

    @Test
    public void testAsBinary() throws Exception {
        Mockito.when((Object)this.mockNode.isNodeType("fedora:Binary")).thenReturn((Object)true);
        this.testObj.cast(this.mockNode);
    }

    @Test(expected=ResourceTypeException.class)
    public void testAsBinaryWithNonbinary() throws Exception {
        Mockito.when((Object)this.mockNode.isNodeType("fedora:Binary")).thenReturn((Object)false);
        this.testObj.cast(this.mockNode);
    }
}

