/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.fcrepo.jcr.FedoraJcrTypes;
import org.fcrepo.kernel.exception.TombstoneException;
import org.fcrepo.kernel.impl.services.ContainerServiceImpl;
import org.fcrepo.kernel.models.Container;
import org.fcrepo.kernel.services.ContainerService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.modeshape.jcr.api.JcrTools;

public class ContainerServiceImplTest
implements FedoraJcrTypes {
    @Mock
    private Session mockSession;
    @Mock
    private Node mockRoot;
    @Mock
    private Node mockNode;
    @Mock
    private Node mockParent;
    @Mock
    private NodeType mockNodeType;
    private ContainerService testObj;
    @Mock
    private JcrTools mockJcrTools;
    private final String testPath = "/foo";

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new ContainerServiceImpl();
        Mockito.when((Object)this.mockSession.getRootNode()).thenReturn((Object)this.mockRoot);
        Mockito.when((Object)this.mockSession.nodeExists("/")).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNode("/")).thenReturn((Object)this.mockRoot);
        Mockito.when((Object)this.mockRoot.getNode("/foo".substring(1))).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockRoot);
        Mockito.when((Object)this.mockRoot.isNew()).thenReturn((Object)false);
    }

    @Test
    public void testCreateObject() {
        Node actual = ((Container)this.testObj.findOrCreate(this.mockSession, "/foo")).getNode();
        Assert.assertEquals((Object)this.mockNode, (Object)actual);
    }

    @Test
    public void testCreateObjectWithHierarchy() throws Exception {
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockParent);
        Mockito.when((Object)this.mockParent.getParent()).thenReturn((Object)this.mockRoot);
        Mockito.when((Object)this.mockParent.isNew()).thenReturn((Object)true);
        Mockito.when((Object)this.mockRoot.getNode("foo/bar")).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockNode.isNew()).thenReturn((Object)true);
        Node actual = ((Container)this.testObj.findOrCreate(this.mockSession, "/foo/bar")).getNode();
        Assert.assertEquals((Object)this.mockNode, (Object)actual);
        ((Node)Mockito.verify((Object)this.mockParent)).addMixin("fedora:Pairtree");
    }

    @Test
    public void testCreateObjectWithExistingHierarchy() throws Exception {
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockParent);
        Mockito.when((Object)this.mockParent.getParent()).thenReturn((Object)this.mockRoot);
        Mockito.when((Object)this.mockParent.isNew()).thenReturn((Object)false);
        Mockito.when((Object)this.mockRoot.hasNode("foo")).thenReturn((Object)true);
        Mockito.when((Object)this.mockRoot.getNode("foo")).thenReturn((Object)this.mockParent);
        Mockito.when((Object)this.mockRoot.getNode("foo/bar")).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockNode.isNew()).thenReturn((Object)true);
        Node actual = ((Container)this.testObj.findOrCreate(this.mockSession, "/foo/bar")).getNode();
        Assert.assertEquals((Object)this.mockNode, (Object)actual);
        ((Node)Mockito.verify((Object)this.mockParent, (VerificationMode)Mockito.never())).addMixin("fedora:Pairtree");
    }

    @Test
    public void testGetObject() throws RepositoryException {
        String testPath = "/foo";
        Mockito.when((Object)this.mockSession.getNode("/foo")).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockJcrTools.findOrCreateNode(this.mockSession, "/foo", "nt:folder", "nt:folder")).thenReturn((Object)this.mockNode);
        Container actual = (Container)this.testObj.findOrCreate(this.mockSession, "/foo");
        Assert.assertEquals((Object)this.mockNode, (Object)actual.getNode());
    }

    @Test(expected=TombstoneException.class)
    public void testThrowsTombstoneExceptionOnCreateOnTombstone() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockParent);
        Mockito.when((Object)this.mockParent.getParent()).thenReturn((Object)this.mockRoot);
        Mockito.when((Object)this.mockParent.isNew()).thenReturn((Object)false);
        Mockito.when((Object)this.mockParent.isNodeType("fedora:Tombstone")).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.nodeExists("/foo")).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNode("/foo")).thenReturn((Object)this.mockParent);
        Mockito.when((Object)this.mockRoot.getNode("foo/bar")).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockNode.isNew()).thenReturn((Object)true);
        this.testObj.findOrCreate(this.mockSession, "/foo/bar");
    }
}

