/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import java.io.InputStream;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeTypeIterator;
import org.fcrepo.kernel.exception.FedoraInvalidNamespaceException;
import org.fcrepo.kernel.impl.services.NodeServiceImpl;
import org.fcrepo.kernel.services.NodeService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;

public class NodeServiceImplTest {
    @Mock
    private NodeTypeIterator mockNTI;
    @Mock
    private NodeTypeManager mockNodeTypeManager;
    @Mock
    private Session mockSession;
    @Mock
    private Node mockRoot;
    @Mock
    private Node mockObjNode;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private PropertyIterator mockEmptyIterator;
    private NodeService testObj;
    @Mock
    private NamespaceRegistry mockNameReg;
    private static final String MOCK_PREFIX = "valid_ns";
    private static final String MOCK_URI = "http://example.org";

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new NodeServiceImpl();
        Mockito.when((Object)this.mockSession.getRootNode()).thenReturn((Object)this.mockRoot);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getNodeTypeManager()).thenReturn((Object)this.mockNodeTypeManager);
        Mockito.when((Object)this.mockNodeTypeManager.getAllNodeTypes()).thenReturn((Object)this.mockNTI);
        Mockito.when((Object)this.mockEmptyIterator.hasNext()).thenReturn((Object)false);
        String[] mockPrefixes = new String[]{MOCK_PREFIX};
        this.mockNameReg = (NamespaceRegistry)Mockito.mock(NamespaceRegistry.class);
        Mockito.when((Object)this.mockWorkspace.getNamespaceRegistry()).thenReturn((Object)this.mockNameReg);
        Mockito.when((Object)this.mockNameReg.getPrefixes()).thenReturn((Object)mockPrefixes);
        Mockito.when((Object)this.mockNameReg.getURI(MOCK_PREFIX)).thenReturn((Object)MOCK_URI);
    }

    @Test
    public void testCopyObject() throws RepositoryException {
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        this.testObj.copyObject(this.mockSession, "foo", "bar");
        ((Workspace)Mockito.verify((Object)this.mockWorkspace)).copy("foo", "bar");
    }

    @Test
    public void testMoveObject() throws RepositoryException {
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        this.testObj.moveObject(this.mockSession, "foo", "bar");
        ((Workspace)Mockito.verify((Object)this.mockWorkspace)).move("foo", "bar");
    }

    @Test
    public void testExists() throws RepositoryException {
        String existsPath = "/foo/bar/exists";
        Mockito.when((Object)this.mockSession.nodeExists("/foo/bar/exists")).thenReturn((Object)true);
        Assert.assertEquals((Object)true, (Object)this.testObj.exists(this.mockSession, "/foo/bar/exists"));
        Assert.assertEquals((Object)false, (Object)this.testObj.exists(this.mockSession, "/foo/bar"));
    }

    @Test(expected=FedoraInvalidNamespaceException.class)
    public void testInvalidPath() throws RepositoryException {
        String badPath = "/foo/bad_ns:bar";
        Mockito.when((Object)this.mockNameReg.getURI("bad_ns")).thenThrow(new Throwable[]{new FedoraInvalidNamespaceException("Invalid namespace (bad_ns)")});
        this.testObj.exists(this.mockSession, "/foo/bad_ns:bar");
    }

    @Test
    public void testGetNodeTypes() throws Exception {
        Mockito.when((Object)this.mockNodeTypeManager.getPrimaryNodeTypes()).thenReturn(Mockito.mock(NodeTypeIterator.class));
        Mockito.when((Object)this.mockNodeTypeManager.getMixinNodeTypes()).thenReturn(Mockito.mock(NodeTypeIterator.class));
        this.testObj.getNodeTypes(this.mockSession);
        ((NodeTypeManager)Mockito.verify((Object)this.mockNodeTypeManager)).getPrimaryNodeTypes();
        ((NodeTypeManager)Mockito.verify((Object)this.mockNodeTypeManager)).getMixinNodeTypes();
    }

    @Test
    public void testRegisterNodeTypes() throws Exception {
        try (InputStream mockInputStream = (InputStream)Mockito.mock(InputStream.class);){
            this.testObj.registerNodeTypes(this.mockSession, mockInputStream);
            ((NodeTypeManager)Mockito.verify((Object)this.mockNodeTypeManager)).registerNodeTypes(mockInputStream, true);
        }
    }
}

