/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.fcrepo.kernel.impl.services.VersionServiceImpl;
import org.fcrepo.kernel.services.VersionService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class VersionServiceImplTest {
    public static final String EXAMPLE_VERSIONED_PATH = "/example-versioned";
    public static final String EXAMPLE_UNVERSIONED_PATH = "/example-unversioned";
    private VersionService testObj;
    @Mock
    private Session mockSession;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private VersionManager mockVM;

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new VersionServiceImpl();
        this.mockSession = (Session)Mockito.mock(Session.class);
        this.mockWorkspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockWorkspace.getName()).thenReturn((Object)"default");
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        this.mockVM = (VersionManager)Mockito.mock(VersionManager.class);
        Mockito.when((Object)this.mockWorkspace.getVersionManager()).thenReturn((Object)this.mockVM);
        Node unversionedNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)unversionedNode.getPath()).thenReturn((Object)EXAMPLE_UNVERSIONED_PATH);
        Mockito.when((Object)unversionedNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)unversionedNode.isNodeType("mix:versionable")).thenReturn((Object)false);
        Mockito.when((Object)this.mockSession.getNode(EXAMPLE_UNVERSIONED_PATH)).thenReturn((Object)unversionedNode);
    }

    @Test
    public void testRevertToVersionByLabel() throws RepositoryException {
        String versionLabel = "v";
        VersionManager mockVersionManager = (VersionManager)Mockito.mock(VersionManager.class);
        VersionHistory mockHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        Version mockVersion1 = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)mockHistory.hasVersionLabel("v")).thenReturn((Object)true);
        Mockito.when((Object)mockHistory.getVersionByLabel("v")).thenReturn((Object)mockVersion1);
        Mockito.when((Object)this.mockWorkspace.getVersionManager()).thenReturn((Object)mockVersionManager);
        Mockito.when((Object)mockVersionManager.getVersionHistory(EXAMPLE_VERSIONED_PATH)).thenReturn((Object)mockHistory);
        this.testObj.revertToVersion(this.mockSession, EXAMPLE_VERSIONED_PATH, "v");
        ((VersionManager)Mockito.verify((Object)mockVersionManager)).restore(mockVersion1, true);
        ((VersionManager)Mockito.verify((Object)mockVersionManager, (VerificationMode)Mockito.never())).checkpoint(EXAMPLE_VERSIONED_PATH);
    }

    @Test
    public void testRevertToVersionByUUID() throws RepositoryException {
        String versionUUID = "uuid";
        VersionManager mockVersionManager = (VersionManager)Mockito.mock(VersionManager.class);
        VersionHistory mockHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        Version mockVersion1 = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)mockHistory.getVersionByLabel("uuid")).thenThrow(new Throwable[]{new VersionException()});
        VersionIterator mockVersionIterator = (VersionIterator)Mockito.mock(VersionIterator.class);
        Mockito.when((Object)mockHistory.getAllVersions()).thenReturn((Object)mockVersionIterator);
        Mockito.when((Object)mockVersionIterator.hasNext()).thenReturn((Object)true);
        Mockito.when((Object)mockVersionIterator.nextVersion()).thenReturn((Object)mockVersion1);
        Node mockFrozenNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)mockVersion1.getFrozenNode()).thenReturn((Object)mockFrozenNode);
        Mockito.when((Object)mockFrozenNode.getIdentifier()).thenReturn((Object)"uuid");
        Mockito.when((Object)this.mockWorkspace.getVersionManager()).thenReturn((Object)mockVersionManager);
        Mockito.when((Object)mockVersionManager.getVersionHistory(EXAMPLE_VERSIONED_PATH)).thenReturn((Object)mockHistory);
        this.testObj.revertToVersion(this.mockSession, EXAMPLE_VERSIONED_PATH, "uuid");
        ((VersionManager)Mockito.verify((Object)mockVersionManager)).restore(mockVersion1, true);
    }

    @Test(expected=PathNotFoundException.class)
    public void testRevertToUnknownVersion() throws RepositoryException {
        String versionUUID = "uuid";
        VersionManager mockVersionManager = (VersionManager)Mockito.mock(VersionManager.class);
        VersionHistory mockHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        Mockito.when((Object)mockHistory.getVersionByLabel("uuid")).thenThrow(new Throwable[]{new VersionException()});
        VersionIterator mockVersionIterator = (VersionIterator)Mockito.mock(VersionIterator.class);
        Mockito.when((Object)mockHistory.getAllVersions()).thenReturn((Object)mockVersionIterator);
        Mockito.when((Object)mockVersionIterator.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockWorkspace.getVersionManager()).thenReturn((Object)mockVersionManager);
        Mockito.when((Object)mockVersionManager.getVersionHistory(EXAMPLE_VERSIONED_PATH)).thenReturn((Object)mockHistory);
        this.testObj.revertToVersion(this.mockSession, EXAMPLE_VERSIONED_PATH, "uuid");
    }

    @Test
    public void testRemoveVersionByLabel() throws RepositoryException {
        String versionLabel = "versionName";
        String versionUUID = "uuid";
        String versionName = "Bob";
        String[] versionLabels = new String[]{"versionName"};
        VersionManager mockVersionManager = (VersionManager)Mockito.mock(VersionManager.class);
        VersionHistory mockHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        Version mockVersion1 = (Version)Mockito.mock(Version.class);
        Version mockVersion2 = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)mockVersion1.getContainingHistory()).thenReturn((Object)mockHistory);
        Mockito.when((Object)mockHistory.hasVersionLabel("versionName")).thenReturn((Object)true);
        Mockito.when((Object)mockHistory.getVersionByLabel("versionName")).thenReturn((Object)mockVersion1);
        Mockito.when((Object)mockHistory.getVersionLabels(mockVersion1)).thenReturn((Object)versionLabels);
        Mockito.when((Object)this.mockWorkspace.getVersionManager()).thenReturn((Object)mockVersionManager);
        Mockito.when((Object)mockVersionManager.getVersionHistory("/example")).thenReturn((Object)mockHistory);
        Mockito.when((Object)mockVersionManager.getBaseVersion("/example")).thenReturn((Object)mockVersion2);
        Node mockFrozenNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)mockVersion1.getFrozenNode()).thenReturn((Object)mockFrozenNode);
        Mockito.when((Object)mockFrozenNode.getIdentifier()).thenReturn((Object)"uuid");
        Mockito.when((Object)mockVersion1.getIdentifier()).thenReturn((Object)"uuid");
        Mockito.when((Object)mockVersion1.getName()).thenReturn((Object)"Bob");
        this.testObj.removeVersion(this.mockSession, "/example", "versionName");
        ((VersionHistory)Mockito.verify((Object)mockHistory)).removeVersion("Bob");
        ((VersionHistory)Mockito.verify((Object)mockHistory)).removeVersionLabel("versionName");
        ((VersionManager)Mockito.verify((Object)mockVersionManager, (VerificationMode)Mockito.never())).checkpoint("/example");
    }

    @Test
    public void testRemoveVersionByUUID() throws RepositoryException {
        String versionName = "Bob";
        String versionUUID = "uuid";
        String[] versionLabels = new String[]{};
        VersionManager mockVersionManager = (VersionManager)Mockito.mock(VersionManager.class);
        VersionHistory mockHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        Version mockVersion1 = (Version)Mockito.mock(Version.class);
        Version mockVersion2 = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)mockVersion1.getContainingHistory()).thenReturn((Object)mockHistory);
        Mockito.when((Object)mockHistory.getVersionByLabel("uuid")).thenThrow(new Throwable[]{new VersionException()});
        VersionIterator mockVersionIterator = (VersionIterator)Mockito.mock(VersionIterator.class);
        Mockito.when((Object)mockHistory.getAllVersions()).thenReturn((Object)mockVersionIterator);
        Mockito.when((Object)mockHistory.getVersionLabels(mockVersion1)).thenReturn((Object)versionLabels);
        Mockito.when((Object)mockVersionIterator.hasNext()).thenReturn((Object)true);
        Mockito.when((Object)mockVersionIterator.nextVersion()).thenReturn((Object)mockVersion1);
        Node mockFrozenNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)mockVersion1.getFrozenNode()).thenReturn((Object)mockFrozenNode);
        Mockito.when((Object)mockFrozenNode.getIdentifier()).thenReturn((Object)"uuid");
        Mockito.when((Object)mockVersion1.getIdentifier()).thenReturn((Object)"uuid");
        Mockito.when((Object)mockVersion1.getName()).thenReturn((Object)"Bob");
        Mockito.when((Object)this.mockWorkspace.getVersionManager()).thenReturn((Object)mockVersionManager);
        Mockito.when((Object)mockVersionManager.getVersionHistory("/example")).thenReturn((Object)mockHistory);
        Mockito.when((Object)mockVersionManager.getBaseVersion("/example")).thenReturn((Object)mockVersion2);
        this.testObj.removeVersion(this.mockSession, "/example", "uuid");
        ((VersionHistory)Mockito.verify((Object)mockHistory)).removeVersion("Bob");
    }

    @Test(expected=PathNotFoundException.class)
    public void testRemoveUnknownVersion() throws RepositoryException {
        String versionUUID = "uuid";
        VersionManager mockVersionManager = (VersionManager)Mockito.mock(VersionManager.class);
        VersionHistory mockHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        Mockito.when((Object)mockHistory.getVersionByLabel("uuid")).thenThrow(new Throwable[]{new VersionException()});
        VersionIterator mockVersionIterator = (VersionIterator)Mockito.mock(VersionIterator.class);
        Mockito.when((Object)mockHistory.getAllVersions()).thenReturn((Object)mockVersionIterator);
        Mockito.when((Object)mockVersionIterator.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockWorkspace.getVersionManager()).thenReturn((Object)mockVersionManager);
        Mockito.when((Object)mockVersionManager.getVersionHistory("/example")).thenReturn((Object)mockHistory);
        this.testObj.removeVersion(this.mockSession, "/example", "uuid");
    }

    @Test
    public void testMixinCreationWhenExplicitlyVersioning() throws RepositoryException {
        this.testObj.createVersion(this.mockSession, EXAMPLE_UNVERSIONED_PATH);
        Node unversionedNode = this.mockSession.getNode(EXAMPLE_UNVERSIONED_PATH);
        ((Node)Mockito.verify((Object)unversionedNode)).isNodeType("mix:versionable");
        ((Node)Mockito.verify((Object)unversionedNode)).addMixin("mix:versionable");
    }
}

