/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils;

import com.google.common.base.Predicate;
import java.io.InputStream;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.fcrepo.kernel.impl.utils.FedoraTypesUtils;
import org.fcrepo.kernel.services.functions.JcrPropertyFunctions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.JcrValueFactory;

public class FedoraTypesUtilsTest {
    @Mock
    private Node mockNode;
    @Mock
    private Session mockSession;
    @Mock
    private ValueFactory mockVF;
    @Mock
    private InputStream mockInput;
    @Mock
    private JcrValueFactory mockJVF;
    @Mock
    private Workspace mockWS;
    @Mock
    private NodeTypeManager mockNTM;
    @Mock
    private NodeType mockNodeType;
    @Mock
    private PropertyDefinition mockPropertyDefinition;
    @Mock
    private Version mockVersion;
    @Mock
    private VersionManager mockVersionManager;
    @Mock
    private VersionHistory mockVersionHistory;
    @Mock
    private Repository mockRepository;
    @Mock
    private QueryManager mockQueryManager;
    @Mock
    private Query mockQuery;
    @Mock
    private QueryResult mockResults;
    @Mock
    private RowIterator mockIterator;
    @Mock
    private Row mockRow;
    @Mock
    private Value mockValue;
    @Mock
    private Value mockValue2;
    @Mock
    private Property mockProperty;
    @Mock
    private Node mockRootNode;
    @Mock
    private Node mockContainer;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testIsMultipleValuedProperty() throws RepositoryException {
        Property mockYes = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)mockYes.isMultiple()).thenReturn((Object)true);
        Property mockNo = (Property)Mockito.mock(Property.class);
        Predicate test = JcrPropertyFunctions.isMultipleValuedProperty;
        try {
            test.apply(null);
            Assert.fail((String)"Null values should throw a NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        boolean actual = test.apply((Object)mockYes);
        Assert.assertEquals((Object)true, (Object)actual);
        actual = test.apply((Object)mockNo);
        Assert.assertEquals((Object)false, (Object)actual);
        Mockito.when((Object)mockYes.isMultiple()).thenThrow(new Throwable[]{new RepositoryException()});
        try {
            test.apply((Object)mockYes);
            Assert.fail((String)"Unexpected completion after RepositoryException!");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    @Test
    public void testIsBinaryContentProperty() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)2);
        Mockito.when((Object)this.mockProperty.getName()).thenReturn((Object)"jcr:data");
        Assert.assertTrue((boolean)JcrPropertyFunctions.isBinaryContentProperty.apply((Object)this.mockProperty));
    }

    @Test
    public void testIsInternalReferenceProperty() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)9);
        Mockito.when((Object)this.mockProperty.getName()).thenReturn((Object)FedoraTypesUtils.getReferencePropertyName((String)"foo"));
        Assert.assertTrue((boolean)FedoraTypesUtils.isInternalReferenceProperty.apply((Object)this.mockProperty));
    }

    @Test
    public void testIsInternalReferencePropertyWeak() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)10);
        Mockito.when((Object)this.mockProperty.getName()).thenReturn((Object)FedoraTypesUtils.getReferencePropertyName((String)"foo"));
        Assert.assertTrue((boolean)FedoraTypesUtils.isInternalReferenceProperty.apply((Object)this.mockProperty));
    }

    @Test
    public void testIsReferenceProperty() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNodeType.getPropertyDefinitions()).thenReturn((Object)new PropertyDefinition[]{this.mockPropertyDefinition});
        Mockito.when((Object)this.mockPropertyDefinition.getName()).thenReturn((Object)"some:reference_property");
        Mockito.when((Object)this.mockPropertyDefinition.getRequiredType()).thenReturn((Object)9);
        Assert.assertTrue((boolean)FedoraTypesUtils.isReferenceProperty((Node)this.mockNode, (String)"some:reference_property"));
    }

    @Test
    public void testIsReferencePropertyForOtherPropertyTypes() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNodeType.getPropertyDefinitions()).thenReturn((Object)new PropertyDefinition[]{this.mockPropertyDefinition});
        Mockito.when((Object)this.mockPropertyDefinition.getName()).thenReturn((Object)"some:reference_property");
        Mockito.when((Object)this.mockPropertyDefinition.getRequiredType()).thenReturn((Object)2);
        Assert.assertFalse((boolean)FedoraTypesUtils.isReferenceProperty((Node)this.mockNode, (String)"some:reference_property"));
    }

    @Test
    public void testIsReferencePropertyForMissingTypes() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNodeType.getPropertyDefinitions()).thenReturn((Object)new PropertyDefinition[0]);
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        Assert.assertFalse((boolean)FedoraTypesUtils.isReferenceProperty((Node)this.mockNode, (String)"some:reference_property"));
    }

    @Test
    public void testIsInternalProperty() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)2);
        Mockito.when((Object)this.mockProperty.getName()).thenReturn((Object)"jcr:data");
        Assert.assertTrue((boolean)FedoraTypesUtils.isInternalProperty.apply((Object)this.mockProperty));
    }

    @Test
    public void testIsNotBinaryContentProperty() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)1);
        Assert.assertFalse((boolean)JcrPropertyFunctions.isBinaryContentProperty.apply((Object)this.mockProperty));
    }

    @Test
    public void testContentButNotBinaryContentProperty() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)1);
        Mockito.when((Object)this.mockProperty.getName()).thenReturn((Object)"jcr:data");
        Assert.assertFalse((boolean)JcrPropertyFunctions.isBinaryContentProperty.apply((Object)this.mockProperty));
    }

    @Test
    public void testIsBlanknode() throws RepositoryException {
        Mockito.when((Object)this.mockNode.isNodeType("fedora:Blanknode")).thenReturn((Object)true);
        Assert.assertTrue((String)"Expected to be a blank node", (boolean)FedoraTypesUtils.isBlankNode.apply((Object)this.mockNode));
        Mockito.when((Object)this.mockNode.isNodeType("fedora:Blanknode")).thenReturn((Object)false);
        Assert.assertFalse((String)"Expected to not be a blank node", (boolean)FedoraTypesUtils.isBlankNode.apply((Object)this.mockNode));
    }

    @Test
    public void testIsInternalNode() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNode.isNodeType("mode:system")).thenReturn((Object)true);
        Assert.assertTrue((String)"mode:system nodes should be treated as internal nodes!", (boolean)FedoraTypesUtils.isInternalNode.apply((Object)this.mockNode));
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNode.isNodeType("mode:system")).thenReturn((Object)false);
        Assert.assertFalse((String)"Nodes that are not mode:system types should not be treated as internal nodes!", (boolean)FedoraTypesUtils.isInternalNode.apply((Object)this.mockNode));
        Mockito.when((Object)this.mockNode.isNodeType("mode:system")).thenThrow(new Throwable[]{new RepositoryException()});
        try {
            FedoraTypesUtils.isInternalNode.apply((Object)this.mockNode);
            Assert.fail((String)"Unexpected completion of FedoraTypesUtils.isInternalNode after RepositoryException!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testPredicateExceptionHandling() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenThrow(new Throwable[]{new RepositoryException()});
        Mockito.when((Object)this.mockNode.isNodeType(Matchers.anyString())).thenThrow(new Throwable[]{new RepositoryException()});
        try {
            FedoraTypesUtils.isContainer.apply((Object)this.mockNode);
            Assert.fail((String)"Unexpected FedoraTypesUtils.isContainer completion after RepositoryException!");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            FedoraTypesUtils.isNonRdfSourceDescription.apply((Object)this.mockNode);
            Assert.fail((String)"Unexpected FedoraTypesUtils.isNonRdfSourceDescription completion after RepositoryException!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testValue2String() throws RepositoryException {
        Mockito.when((Object)this.mockValue.getString()).thenReturn((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)JcrPropertyFunctions.value2string.apply((Object)this.mockValue));
        Mockito.when((Object)this.mockValue.getString()).thenThrow(new Throwable[]{new RepositoryException()});
        try {
            JcrPropertyFunctions.value2string.apply((Object)this.mockValue);
            Assert.fail((String)"Unexpected FedoraTypesUtils.value2string completion after RepositoryException!");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            JcrPropertyFunctions.value2string.apply(null);
            Assert.fail((String)"Unexpected FedoraTypesUtils.value2string completion with null argument!");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testProperty2values() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)false);
        Mockito.when((Object)this.mockProperty.getValue()).thenReturn((Object)this.mockValue);
        Assert.assertEquals((String)"Found wrong Value!", ((Iterator)JcrPropertyFunctions.property2values.apply((Object)this.mockProperty)).next(), (Object)this.mockValue);
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)true);
        Mockito.when((Object)this.mockProperty.getValues()).thenReturn((Object)new Value[]{this.mockValue, this.mockValue2});
        Iterator testIterator = (Iterator)JcrPropertyFunctions.property2values.apply((Object)this.mockProperty);
        Assert.assertEquals((String)"Found wrong Value!", testIterator.next(), (Object)this.mockValue);
        Assert.assertEquals((String)"Found wrong Value!", testIterator.next(), (Object)this.mockValue2);
    }

    @Test
    public void testGetClosestExistingAncestorRoot() throws RepositoryException {
        Mockito.when((Object)this.mockSession.getNode("/")).thenReturn((Object)this.mockRootNode);
        Mockito.when((Object)this.mockSession.nodeExists(Matchers.anyString())).thenReturn((Object)false);
        Node closestExistingAncestor = FedoraTypesUtils.getClosestExistingAncestor((Session)this.mockSession, (String)"/some/path");
        Assert.assertEquals((Object)this.mockRootNode, (Object)closestExistingAncestor);
    }

    @Test
    public void testGetClosestExistingAncestorContainer() throws RepositoryException {
        Mockito.when((Object)this.mockSession.getNode("/")).thenReturn((Object)this.mockRootNode);
        Mockito.when((Object)this.mockSession.nodeExists("/some")).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNode("/some")).thenReturn((Object)this.mockContainer);
        Node closestExistingAncestor = FedoraTypesUtils.getClosestExistingAncestor((Session)this.mockSession, (String)"/some/path");
        Assert.assertEquals((Object)this.mockContainer, (Object)closestExistingAncestor);
    }

    @Test
    public void testGetClosestExistingAncestorNode() throws RepositoryException {
        Mockito.when((Object)this.mockSession.getNode("/")).thenReturn((Object)this.mockRootNode);
        Mockito.when((Object)this.mockSession.nodeExists("/some")).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNode("/some")).thenReturn((Object)this.mockContainer);
        Mockito.when((Object)this.mockSession.nodeExists("/some/path")).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNode("/some/path")).thenReturn((Object)this.mockNode);
        Node closestExistingAncestor = FedoraTypesUtils.getClosestExistingAncestor((Session)this.mockSession, (String)"/some/path");
        Assert.assertEquals((Object)this.mockNode, (Object)closestExistingAncestor);
    }
}

