/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils.iterators;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.impl.rdf.ManagedRdf;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockitoAnnotations;

public class ManagedRdfTest {
    private static final Triple managedTriple = Triple.create((Node)NodeFactory.createAnon(), (Node)RdfLexicon.HAS_CHILD.asNode(), (Node)NodeFactory.createAnon());
    private static final Triple unManagedTriple = Triple.create((Node)NodeFactory.createAnon(), (Node)NodeFactory.createAnon(), (Node)NodeFactory.createAnon());
    private RdfStream testStream;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.testStream = new RdfStream(new Triple[]{managedTriple, unManagedTriple}).filter(Predicates.not((Predicate)ManagedRdf.isManagedTriple));
    }

    @Test
    public void testFiltering() {
        Assert.assertEquals((String)"Didn't get unmanaged triple!", (Object)unManagedTriple, (Object)this.testStream.next());
        Assert.assertFalse((String)"Failed to filter managed triple!", (boolean)this.testStream.hasNext());
    }

    @Test
    public void testMixinFiltering() {
        Assert.assertTrue((boolean)ManagedRdf.isManagedMixin.apply((Object)ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/repository#thing")));
        Assert.assertFalse((boolean)ManagedRdf.isManagedMixin.apply((Object)ResourceFactory.createResource((String)"myNS:thing")));
    }
}

