/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.Transaction;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.impl.TxAwareSession;

public class TransactionImpl
implements Transaction {
    public static final long DEFAULT_TIMEOUT = 180000L;
    public static final String TIMEOUT_SYSTEM_PROPERTY = "fcrepo4.tx.timeout";
    private final Session session;
    private final String id;
    private final String userName;
    private final Date created;
    private final Calendar expires;
    private Transaction.State state = Transaction.State.NEW;

    public TransactionImpl(Session session, String userName) {
        this.session = session;
        this.created = new Date();
        this.id = UUID.randomUUID().toString();
        this.expires = Calendar.getInstance();
        this.updateExpiryDate();
        this.userName = userName;
    }

    public Session getSession() {
        this.updateExpiryDate();
        return TxAwareSession.newInstance(this.session, this.id);
    }

    public Date getCreated() {
        return new Date(this.created.getTime());
    }

    public String getId() {
        return this.id;
    }

    public Transaction.State getState() throws RepositoryException {
        if (this.session != null && this.session.hasPendingChanges()) {
            return Transaction.State.DIRTY;
        }
        return this.state;
    }

    public Date getExpires() {
        return this.expires.getTime();
    }

    public void commit() {
        try {
            this.session.save();
            this.state = Transaction.State.COMMITED;
            this.expire();
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public void expire() {
        this.session.logout();
        this.expires.setTimeInMillis(System.currentTimeMillis());
    }

    public boolean isAssociatedWithUser(String userName) {
        boolean associatedWith = false;
        if (this.userName == null) {
            if (userName == null) {
                associatedWith = true;
            }
        } else {
            associatedWith = this.userName.equals(userName);
        }
        return associatedWith;
    }

    public void rollback() {
        this.state = Transaction.State.ROLLED_BACK;
        try {
            this.session.refresh(false);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
        this.expire();
    }

    public void updateExpiryDate() {
        long duration = System.getProperty(TIMEOUT_SYSTEM_PROPERTY) != null ? Long.parseLong(System.getProperty(TIMEOUT_SYSTEM_PROPERTY)) : 180000L;
        this.expires.setTimeInMillis(System.currentTimeMillis() + duration);
    }
}

