/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.identifiers;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.fcrepo.kernel.identifiers.PidMinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class HttpPidMinter
implements PidMinter {
    private static final Logger log = LoggerFactory.getLogger(HttpPidMinter.class);
    protected final String url;
    protected final String method;
    protected final String username;
    protected final String password;
    private final String regex;
    private XPathExpression xpath;
    protected HttpClient client;

    public HttpPidMinter(String url, String method, String username, String password, String regex, String xpath) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)url) ? 1 : 0) != 0, (Object)"Minter URL must be specified!");
        this.url = url;
        this.method = method;
        this.username = username;
        this.password = password;
        this.regex = regex;
        if (xpath != null) {
            try {
                this.xpath = XPathFactory.newInstance().newXPath().compile(xpath);
            }
            catch (XPathException ex) {
                log.warn("Error parsing xpath ({}): {}", (Object)xpath, (Object)ex);
            }
        }
        this.client = this.buildClient();
    }

    protected HttpClient buildClient() {
        HttpClientBuilder builder = HttpClientBuilder.create().useSystemProperties().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager());
        if (!StringUtils.isBlank((String)this.username) && !StringUtils.isBlank((String)this.password)) {
            URI uri = URI.create(this.url);
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(uri.getHost(), uri.getPort()), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
            builder = builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        return builder.build();
    }

    private HttpUriRequest minterRequest() {
        if (this.method != null && this.method.equalsIgnoreCase("GET")) {
            return new HttpGet(this.url);
        }
        if (this.method != null && this.method.equalsIgnoreCase("PUT")) {
            return new HttpPut(this.url);
        }
        return new HttpPost(this.url);
    }

    protected String responseToPid(String responseText) throws Exception {
        log.debug("responseToPid({})", (Object)responseText);
        if (!StringUtils.isBlank((String)this.regex)) {
            return responseText.replaceFirst(this.regex, "");
        }
        if (this.xpath != null) {
            return HttpPidMinter.xpath(responseText, this.xpath);
        }
        return responseText;
    }

    private static String xpath(String xml, XPathExpression xpath) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(new ByteArrayInputStream(xml.getBytes()));
        return xpath.evaluate(doc);
    }

    @Timed
    public String mintPid() {
        try {
            log.debug("mintPid()");
            HttpResponse resp = this.client.execute(this.minterRequest());
            return this.responseToPid(EntityUtils.toString((HttpEntity)resp.getEntity()));
        }
        catch (IOException ex) {
            log.warn("Error minting pid from {}: {}", (Object)this.url, (Object)ex);
            throw new RuntimeException("Error minting pid", ex);
        }
        catch (Exception ex) {
            log.warn("Error processing minter response", (Throwable)ex);
            throw new RuntimeException("Error processing minter response", ex);
        }
    }
}

