/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.identifiers;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.UUID;
import org.fcrepo.kernel.identifiers.PidMinter;
import org.fcrepo.metrics.RegistryService;

public class UUIDPathMinter
implements PidMinter {
    static final Timer timer = RegistryService.getInstance().getMetrics().timer(MetricRegistry.name(UUIDPathMinter.class, (String[])new String[]{"mint"}));
    private static final int DEFAULT_LENGTH = 2;
    private static final int DEFAULT_COUNT = 4;
    private final int length;
    private final int count;

    public UUIDPathMinter() {
        this(2, 4);
    }

    public UUIDPathMinter(int length, int count) {
        this.length = length;
        this.count = count;
    }

    public String mintPid() {
        try (Timer.Context context = timer.time();){
            String s = UUID.randomUUID().toString();
            if (this.length == 0 || this.count == 0) {
                String string = s;
                return string;
            }
            Iterable split = Splitter.fixedLength((int)this.length).split((CharSequence)s.substring(0, this.length * this.count));
            String string = Joiner.on((String)"/").join(split) + "/" + s;
            return string;
        }
    }
}

