/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.converters;

import com.google.common.base.Converter;
import com.google.common.base.Splitter;
import com.hp.hpl.jena.datatypes.BaseDatatype;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.impl.identifiers.NodeResourceConverter;
import org.fcrepo.kernel.models.FedoraResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueConverter
extends Converter<Value, RDFNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValueConverter.class);
    private final Session session;
    private final Converter<Node, Resource> graphSubjects;

    public ValueConverter(Session session, Converter<Resource, FedoraResource> graphSubjects) {
        this.session = session;
        this.graphSubjects = NodeResourceConverter.nodeToResource(graphSubjects);
    }

    protected RDFNode doForward(Value value) {
        try {
            switch (value.getType()) {
                case 6: {
                    return ValueConverter.literal2node(value.getBoolean());
                }
                case 5: {
                    return ValueConverter.literal2node(value.getDate());
                }
                case 12: {
                    return ValueConverter.literal2node(value.getDecimal());
                }
                case 4: {
                    return ValueConverter.literal2node(value.getDouble());
                }
                case 3: {
                    return ValueConverter.literal2node(value.getLong());
                }
                case 11: {
                    return ResourceFactory.createResource((String)value.getString());
                }
                case 8: 
                case 9: 
                case 10: {
                    return this.traverseLink(value);
                }
            }
            return ValueConverter.stringliteral2node(value.getString());
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    protected Value doBackward(RDFNode resource) {
        try {
            ValueFactory valueFactory = this.session.getValueFactory();
            if (resource.isAnon()) {
                return valueFactory.createValue(resource.toString(), 0);
            }
            RdfLiteralJcrValueBuilder rdfLiteralJcrValueBuilder = new RdfLiteralJcrValueBuilder();
            if (resource.isURIResource()) {
                rdfLiteralJcrValueBuilder.value(resource.asResource().getURI()).datatype("URI");
            } else {
                Literal literal = resource.asLiteral();
                RDFDatatype dataType = literal.getDatatype();
                rdfLiteralJcrValueBuilder.value(literal.getString()).datatype(dataType).lang(literal.getLanguage());
            }
            return valueFactory.createValue(rdfLiteralJcrValueBuilder.toString(), 1);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    private static Literal literal2node(Object literal) {
        Literal result = ResourceFactory.createTypedLiteral((Object)literal);
        LOGGER.trace("Converting {} into {}", literal, (Object)result);
        return result;
    }

    private static RDFNode stringliteral2node(String literal) {
        RdfLiteralJcrValueBuilder rdfLiteralJcrValueBuilder = new RdfLiteralJcrValueBuilder(literal);
        if (rdfLiteralJcrValueBuilder.hasLang()) {
            return ResourceFactory.createLangLiteral((String)rdfLiteralJcrValueBuilder.value(), (String)rdfLiteralJcrValueBuilder.lang());
        }
        if (rdfLiteralJcrValueBuilder.isResource()) {
            return ResourceFactory.createResource((String)rdfLiteralJcrValueBuilder.value());
        }
        if (rdfLiteralJcrValueBuilder.hasDatatypeUri()) {
            return ResourceFactory.createTypedLiteral((String)rdfLiteralJcrValueBuilder.value(), (RDFDatatype)rdfLiteralJcrValueBuilder.datatype());
        }
        return ResourceFactory.createPlainLiteral((String)literal);
    }

    private RDFNode traverseLink(Value v) throws RepositoryException {
        Node refNode = v.getType() == 8 ? this.session.getNode(v.getString()) : this.session.getNodeByIdentifier(v.getString());
        return this.getGraphSubject(refNode);
    }

    private RDFNode getGraphSubject(Node n) {
        return (RDFNode)this.graphSubjects.convert((Object)n);
    }

    protected static class RdfLiteralJcrValueBuilder {
        private static final String FIELD_DELIMITER = "\u0018^^\u0018";
        public static final Splitter JCR_VALUE_SPLITTER = Splitter.on((String)"\u0018^^\u0018");
        private String value;
        private String datatypeUri;
        private String lang;

        RdfLiteralJcrValueBuilder() {
        }

        public RdfLiteralJcrValueBuilder(String literal) {
            this();
            Iterator tokenizer = JCR_VALUE_SPLITTER.split((CharSequence)literal).iterator();
            this.value = (String)tokenizer.next();
            if (tokenizer.hasNext()) {
                this.datatypeUri = (String)tokenizer.next();
            }
            if (tokenizer.hasNext()) {
                this.lang = (String)tokenizer.next();
            }
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.value);
            if (this.hasDatatypeUri()) {
                b.append(FIELD_DELIMITER);
                b.append(this.datatypeUri);
            } else if (this.hasLang()) {
                b.append(FIELD_DELIMITER);
            }
            if (this.hasLang()) {
                b.append(FIELD_DELIMITER);
                b.append(this.lang);
            }
            return b.toString();
        }

        public String value() {
            return this.value;
        }

        public RDFDatatype datatype() {
            if (this.hasDatatypeUri()) {
                return new BaseDatatype(this.datatypeUri);
            }
            return null;
        }

        public String lang() {
            return this.lang;
        }

        public RdfLiteralJcrValueBuilder value(String value) {
            this.value = value;
            return this;
        }

        public RdfLiteralJcrValueBuilder datatype(String datatypeUri) {
            this.datatypeUri = datatypeUri;
            return this;
        }

        public RdfLiteralJcrValueBuilder datatype(RDFDatatype datatypeUri) {
            if (datatypeUri != null && !datatypeUri.getURI().isEmpty()) {
                this.datatypeUri = datatypeUri.getURI();
            }
            return this;
        }

        public RdfLiteralJcrValueBuilder lang(String lang) {
            this.lang = lang;
            return this;
        }

        public boolean hasLang() {
            return this.lang != null && !this.lang.isEmpty();
        }

        public boolean hasDatatypeUri() {
            return this.datatypeUri != null && !this.datatypeUri.isEmpty();
        }

        public boolean isResource() {
            return this.hasDatatypeUri() && this.datatypeUri.equals("URI");
        }
    }
}

