/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.rdf.impl.NodeRdfContext;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParentRdfContext
extends NodeRdfContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParentRdfContext.class);

    public ParentRdfContext(FedoraResource resource, IdentifierConverter<Resource, FedoraResource> idTranslator) throws RepositoryException {
        super(resource, idTranslator);
        if (resource.getNode().getDepth() > 0) {
            LOGGER.trace("Determined that this resource has a parent.");
            this.concat(this.parentContext());
        }
    }

    private Iterator<Triple> parentContext() {
        RdfStream parentStream = new RdfStream();
        Node containerSubject = ((Resource)this.translator().reverse().convert((Object)this.resource().getContainer())).asNode();
        parentStream.concat(Triple.create((Node)this.subject(), (Node)RdfLexicon.HAS_PARENT.asNode(), (Node)containerSubject));
        return parentStream;
    }
}

